/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.jmi.MatlabException;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.pmode.ClosableSessionConnections;
import com.mathworks.toolbox.distcomp.pmode.InitiateLabShutdown;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.SessionConstants;
import com.mathworks.toolbox.distcomp.pmode.SessionShutdownEvent;
import com.mathworks.toolbox.distcomp.pmode.ShutdownACKFromLab;
import com.mathworks.toolbox.distcomp.pmode.SyncBoolean;
import com.mathworks.toolbox.distcomp.pmode.shared.ErrorHandler;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.LabsResponseVector;
import com.mathworks.toolbox.distcomp.pmode.shared.OutputGroup;
import com.mathworks.toolbox.distcomp.pmode.shared.SessionService;
import com.mathworks.toolbox.distcomp.pmode.shared.Shutdown;
import com.mathworks.toolbox.distcomp.pmode.shared.ShutdownHandler;
import com.mathworks.toolbox.distcomp.util.i18n.I18NMatlabMessage;

class ClientShutdownHandlerImpl
implements ShutdownHandler {
    private OutputGroup fOutGroup;
    private ErrorHandler fErrorHandler;
    private LabsResponseVector fShutdownACKFromLabFromLabs;
    private SyncBoolean fHasShutdown = new SyncBoolean(false);
    private ClosableSessionConnections fClosableConnections;

    public ClientShutdownHandlerImpl(SessionService sessionService, OutputGroup outputGroup, ClosableSessionConnections closableSessionConnections) {
        this.fOutGroup = outputGroup;
        this.fShutdownACKFromLabFromLabs = new LabsResponseVector(this.fOutGroup.getNumDestinations());
        this.fClosableConnections = closableSessionConnections;
        this.fErrorHandler = sessionService.getErrorHandler();
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "Sending shutdown cancellation message.");
    }

    @Override
    public boolean normalShutdown() {
        if (this.fHasShutdown.setValueGetOldValue(true)) {
            return this.fShutdownACKFromLabFromLabs.hasAllResponses();
        }
        PackageInfo.LOGGER.log(DistcompLevel.TWO, "Initiating a shutdown.");
        this.fErrorHandler.deactivate();
        this.tellLabsToShutdown();
        this.shutdownClient(new SessionShutdownEvent(this, SessionShutdownEvent.ShutdownState.NORMAL));
        return this.fShutdownACKFromLabFromLabs.hasAllResponses();
    }

    @Override
    public void forceShutdown(I18NMatlabMessage i18NMatlabMessage) {
        if (this.fHasShutdown.setValueGetOldValue(true)) {
            return;
        }
        PackageInfo.LOGGER.log(DistcompLevel.ONE, "Initiating a forced shutdown.");
        this.fErrorHandler.deactivate();
        this.shutdownClient(new SessionShutdownEvent(this, SessionShutdownEvent.ShutdownState.ERROR, i18NMatlabMessage));
        this.cleanupStateInMatlabAndError(i18NMatlabMessage);
    }

    @Override
    public void dispatch(Shutdown shutdown, Instance instance) {
        if (shutdown instanceof ShutdownACKFromLab) {
            this.fShutdownACKFromLabFromLabs.receivedResponse(instance);
        } else {
            String string = "Received an unexpected class " + shutdown.getClass().getName();
            assert (false) : string;
        }
    }

    @Override
    public boolean hasShutdownBegun() {
        return this.fHasShutdown.getValue();
    }

    @Override
    public void sessionStartupComplete() {
    }

    private void shutdownClient(SessionShutdownEvent sessionShutdownEvent) {
        block2: {
            PackageInfo.LOGGER.log(DistcompLevel.THREE, "Did we receive ACK from all labs: " + this.fShutdownACKFromLabFromLabs.hasAllResponses());
            PackageInfo.LOGGER.log(DistcompLevel.THREE, "Closing IO and stopping executors.");
            try {
                this.fClosableConnections.run(sessionShutdownEvent);
            }
            catch (Throwable throwable) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)("Caught a Throwable when calling Runnable to close IO and stop executors." + throwable.getClass().getName()));
            }
        }
    }

    private void tellLabsToShutdown() {
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "Sending shutdown to all labs.");
        this.fOutGroup.sendToAll(new InitiateLabShutdown());
        this.fShutdownACKFromLabFromLabs.waitTillHasAllResponses(SessionConstants.sMAX_WAIT_FOR_ACK);
    }

    private void cleanupStateInMatlabAndError(final I18NMatlabMessage i18NMatlabMessage) {
        MatlabWorker matlabWorker = new MatlabWorker(){

            public Object runOnMatlabThread() throws Exception {
                try {
                    1.eval((String)"matlabpool exitleaveguiopen;");
                }
                catch (MatlabException matlabException) {
                    // empty catch block
                }
                int n = 0;
                boolean bl = true;
                try {
                    1.feval((String)"error", (Object[])new Object[]{i18NMatlabMessage.getMatlabErrorId(), i18NMatlabMessage.getLocalizedMessage()}, (int)n, (boolean)bl);
                }
                catch (MatlabException matlabException) {
                    // empty catch block
                }
                return null;
            }

            public void runOnAWTEventDispatchThread(Object object) {
            }
        };
        matlabWorker.start();
    }
}

