/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.parallelui;

import com.mathworks.common.icons.MiscellaneousIcon;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.toolbox.distcomp.parallelui.ParallelUI;
import com.mathworks.toolbox.distcomp.pmode.Labs;
import com.mathworks.toolbox.distcomp.pmode.shared.LabsCompletionObserver;
import com.mathworks.toolbox.distcomp.pmode.shared.ProcessInstance;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

class PromptPad {
    private final Labs fLabs;
    private JTextComponent fTextComponent;
    private JToolBar fToolBar;
    private JTextField fIncrementField;
    private JTextField fMultiplierField;
    private CaretListener fCaretListener;
    private MouseWheelListener fWheelListener;
    private KeyListener fKeyListener;
    private Action fIncrementAction = new IncrementAction();
    private Action fDecrementAction = new DecrementAction();
    private Action fMultiplyAction = new MultiplyAction();
    private Action fDivideAction = new DivideAction();
    private static NumberFormat sNumberFormat = NumberFormat.getNumberInstance(Locale.US);
    private static final double DEFAULT_INCREMENT = 1.0;
    private static final double DEFAULT_MULTIPLIER = 1.1;

    PromptPad(Labs labs) {
        this.fLabs = labs;
        this.fIncrementField = new AdjustmentFactorField(1.0);
        this.fIncrementField.setName("ValueIncrementTextField");
        this.fMultiplierField = new AdjustmentFactorField(1.1);
        this.fMultiplierField.setName("ValueMultiplierTextField");
        this.fToolBar = new MJToolBar();
        this.fToolBar.setFloatable(false);
        this.fToolBar.setName("PromptPadToolBar");
        this.fToolBar.add(this.fDecrementAction);
        this.fToolBar.add(this.fIncrementField);
        this.fToolBar.add(this.fIncrementAction);
        this.fToolBar.addSeparator();
        this.fToolBar.add(this.fDivideAction);
        this.fToolBar.add(this.fMultiplierField);
        this.fToolBar.add(this.fMultiplyAction);
    }

    void attachedTo(JTextComponent jTextComponent) {
        if (this.fTextComponent == jTextComponent) {
            return;
        }
        if (this.fTextComponent != null) {
            this.detach();
        }
        this.fTextComponent = jTextComponent;
        if (this.fCaretListener == null) {
            this.fCaretListener = new LocalCaretListener();
        }
        if (this.fWheelListener == null) {
            this.fWheelListener = new LocalWheelListener();
        }
        if (this.fKeyListener == null) {
            this.fKeyListener = new LocalKeyListener();
        }
        this.fTextComponent.addCaretListener(this.fCaretListener);
        this.fTextComponent.addMouseWheelListener(this.fWheelListener);
        this.fTextComponent.addKeyListener(this.fKeyListener);
    }

    void detach() {
        if (this.fTextComponent != null) {
            this.fTextComponent.removeCaretListener(this.fCaretListener);
            this.fTextComponent.removeMouseWheelListener(this.fWheelListener);
            this.fTextComponent.removeKeyListener(this.fKeyListener);
            this.fTextComponent = null;
        }
    }

    JToolBar getToolBar() {
        return this.fToolBar;
    }

    private void incrementNumber() {
        if (this.numericSelection(true)) {
            this.tweakNumber(107);
        }
    }

    private void decrementNumber() {
        if (this.numericSelection(true)) {
            this.tweakNumber(109);
        }
    }

    private void multiplyNumber() {
        if (this.numericSelection(true)) {
            this.tweakNumber(106);
        }
    }

    private void divideNumber() {
        if (this.numericSelection(true)) {
            this.tweakNumber(111);
        }
    }

    private void increaseIncrement() {
        try {
            double d = 2.0 * sNumberFormat.parse(this.fIncrementField.getText()).doubleValue();
            this.fIncrementField.setText(sNumberFormat.format(d));
            this.fIncrementField.revalidate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void decreaseIncrement() {
        try {
            double d = 0.5 * sNumberFormat.parse(this.fIncrementField.getText()).doubleValue();
            this.fIncrementField.setText(sNumberFormat.format(d));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void increaseMultiplier() {
        try {
            double d = 0.1 + sNumberFormat.parse(this.fMultiplierField.getText()).doubleValue();
            this.fMultiplierField.setText(sNumberFormat.format(d));
            this.fMultiplierField.revalidate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void decreaseMultiplier() {
        try {
            double d = sNumberFormat.parse(this.fMultiplierField.getText()).doubleValue() - 0.1;
            this.fMultiplierField.setText(sNumberFormat.format(d));
            this.fMultiplierField.revalidate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean numericSelection(boolean bl) {
        int n = this.fTextComponent.getSelectionStart();
        int n2 = this.fTextComponent.getDocument().getLength();
        try {
            int n3;
            for (n3 = this.fTextComponent.getSelectionEnd(); n3 < n2 && PromptPad.isNumeric(this.getTextStartEnd(n, n3 + 1)); ++n3) {
            }
            while (n > 0 && PromptPad.isNumeric(this.getTextStartEnd(n - 1, n3))) {
                --n;
            }
            if (n == n3) {
                return false;
            }
            String string = this.getTextStartEnd(n, n3);
            if (string.equals(".") || !PromptPad.isNumeric(string)) {
                return false;
            }
            if (bl) {
                this.fTextComponent.select(n, n3);
            }
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        return true;
    }

    private String getTextStartEnd(int n, int n2) throws BadLocationException {
        return this.fTextComponent.getText(n, n2 - n);
    }

    private static boolean isNumeric(String string) {
        if (string.equals(".")) {
            return true;
        }
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = sNumberFormat.parse(string, parsePosition);
        return number != null && parsePosition.getIndex() == string.length();
    }

    boolean atNumericValue() {
        return this.numericSelection(false);
    }

    private void tweakNumber(int n) {
        double d;
        String string = this.fTextComponent.getSelectedText();
        try {
            d = sNumberFormat.parse(string).doubleValue();
        }
        catch (ParseException parseException) {
            return;
        }
        try {
            double d2 = n == 107 || n == 109 ? sNumberFormat.parse(this.fIncrementField.getText()).doubleValue() : sNumberFormat.parse(this.fMultiplierField.getText()).doubleValue();
            d = n == 107 || n == 109 ? (n == 107 ? (d += d2) : (d -= d2)) : (n == 106 ? (d *= d2) : (d /= d2));
            int n2 = this.fTextComponent.getSelectionStart();
            int n3 = this.fTextComponent.getSelectionEnd() - n2;
            string = sNumberFormat.format(d);
            Document document = this.fTextComponent.getDocument();
            document.remove(n2, n3);
            document.insertString(n2, string, null);
            this.fTextComponent.select(n2, n2 + string.length());
            this.evaluate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void evaluate() {
        String string = this.fTextComponent.getText();
        if (string != null && string.length() > 0) {
            this.fTextComponent.setCursor(Cursor.getPredefinedCursor(3));
            this.fLabs.eval(string, new LocalCompletionObserver());
        }
    }

    static {
        sNumberFormat.setMaximumFractionDigits(5);
        sNumberFormat.setGroupingUsed(false);
    }

    private class AdjustmentFactorField
    extends MJTextField {
        AdjustmentFactorField(double d) {
            super(Double.toString(d));
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.width = 40;
            return dimension;
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }

    private class DivideAction
    extends MJAbstractAction {
        DivideAction() {
            super(null, (Icon)MiscellaneousIcon.DIVIDE.getIcon());
            this.setTip(ParallelUI.sRes.getString("tip.DivideValue"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PromptPad.this.divideNumber();
        }
    }

    private class MultiplyAction
    extends MJAbstractAction {
        MultiplyAction() {
            super(null, (Icon)MiscellaneousIcon.MULTIPLY.getIcon());
            this.setTip(ParallelUI.sRes.getString("tip.MultiplyValue"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PromptPad.this.multiplyNumber();
        }
    }

    private class DecrementAction
    extends MJAbstractAction {
        DecrementAction() {
            super(null, (Icon)MiscellaneousIcon.SUBTRACT.getIcon());
            this.setTip(ParallelUI.sRes.getString("tip.DecrementValue"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PromptPad.this.decrementNumber();
        }
    }

    private class IncrementAction
    extends MJAbstractAction {
        IncrementAction() {
            super(null, (Icon)MiscellaneousIcon.ADD.getIcon());
            this.setTip(ParallelUI.sRes.getString("tip.IncrementValue"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PromptPad.this.incrementNumber();
        }
    }

    private class LocalCompletionObserver
    implements LabsCompletionObserver {
        private LocalCompletionObserver() {
        }

        @Override
        public void handleOutput(String string, ProcessInstance processInstance) {
            ParallelUI.getObserver().handleOutput(string, processInstance);
        }

        @Override
        public void handleExecStatus(int n, ProcessInstance processInstance) {
            PromptPad.this.fTextComponent.setCursor(null);
            if (Matlab.getExecutionStatus((int)n) == 0 && Matlab.getCodeBlockStatus((int)n) == 0) {
                ParallelUI.getObserver().handleExecStatus(n, processInstance);
            } else {
                final String string = Matlab.getCodeBlockStatus((int)n) == 1 ? ParallelUI.sRes.getString("error.IncompleteEval") : ParallelUI.sRes.getString("error.InvalidEval");
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String string2 = ParallelUI.sRes.getString("error.EvalErrorTitle");
                        MJOptionPane.showMessageDialog((Component)PromptPad.this.fTextComponent, (Object)string, (String)string2, (int)0);
                    }
                });
            }
        }
    }

    private class LocalKeyListener
    implements KeyListener {
        boolean iConsumeSubsequent;

        private LocalKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            this.iConsumeSubsequent = false;
            if (keyEvent.getModifiers() == 2) {
                int n = keyEvent.getKeyCode();
                if (n == 107) {
                    PromptPad.this.incrementNumber();
                    this.iConsumeSubsequent = true;
                } else if (n == 109) {
                    PromptPad.this.decrementNumber();
                    this.iConsumeSubsequent = true;
                } else if (n == 106) {
                    PromptPad.this.multiplyNumber();
                    this.iConsumeSubsequent = true;
                } else if (n == 111) {
                    PromptPad.this.divideNumber();
                    this.iConsumeSubsequent = true;
                }
                if (this.iConsumeSubsequent) {
                    keyEvent.consume();
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (this.iConsumeSubsequent) {
                keyEvent.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (this.iConsumeSubsequent) {
                keyEvent.consume();
            }
        }
    }

    private class LocalWheelListener
    implements MouseWheelListener {
        private LocalWheelListener() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (!mouseWheelEvent.isControlDown() || mouseWheelEvent.isAltDown()) {
                Component component = mouseWheelEvent.getComponent();
                Container container = component.getParent();
                Point point = SwingUtilities.convertPoint(component, mouseWheelEvent.getPoint(), container);
                container.dispatchEvent(new MouseWheelEvent((Component)container, 507, mouseWheelEvent.getWhen(), mouseWheelEvent.getModifiers(), point.x, point.y, mouseWheelEvent.getClickCount(), mouseWheelEvent.isPopupTrigger(), mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation()));
            } else {
                mouseWheelEvent.consume();
                if (mouseWheelEvent.isControlDown() && mouseWheelEvent.isShiftDown()) {
                    if (mouseWheelEvent.getWheelRotation() > 0) {
                        PromptPad.this.decreaseIncrement();
                    } else if (mouseWheelEvent.getWheelRotation() < 0) {
                        PromptPad.this.increaseIncrement();
                    }
                } else if (mouseWheelEvent.getWheelRotation() > 0) {
                    PromptPad.this.decrementNumber();
                } else if (mouseWheelEvent.getWheelRotation() < 0) {
                    PromptPad.this.incrementNumber();
                }
            }
        }
    }

    private class LocalCaretListener
    implements CaretListener {
        private LocalCaretListener() {
        }

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            boolean bl = PromptPad.this.atNumericValue();
            PromptPad.this.fIncrementAction.setEnabled(bl);
            PromptPad.this.fDecrementAction.setEnabled(bl);
            PromptPad.this.fMultiplyAction.setEnabled(bl);
            PromptPad.this.fDivideAction.setEnabled(bl);
        }
    }
}

