/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.parallelui;

import com.mathworks.common.icons.CommonIcon;
import com.mathworks.mwswing.ChildAction;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.binding.KeyStrokeUtils;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.lang.ref.WeakReference;
import java.util.EnumMap;
import java.util.EnumSet;
import javax.swing.Action;
import javax.swing.KeyStroke;

class Actions {
    private EnumMap<Type, Action> fActionMap = new EnumMap(Type.class);
    private EnumMap<Type, WeakReference<Contributor>> fContributorMap = new EnumMap(Type.class);
    private EnumSet<Type> fFocusBasedTypes = EnumSet.of(Type.CUT, Type.COPY, Type.PASTE, Type.SELECT_ALL);
    private static final String CONTRIBUTOR_PROPERTY = "Contributor";

    Actions() {
        this.fActionMap.put(Type.CUT, (Action)((Object)new CutAction()));
        this.fActionMap.put(Type.COPY, (Action)((Object)new CopyAction()));
        this.fActionMap.put(Type.PASTE, (Action)((Object)new PasteAction()));
        this.fActionMap.put(Type.SELECT_ALL, (Action)((Object)new SelectAllAction()));
    }

    boolean isFocusBased(Type type) {
        return this.fFocusBasedTypes.contains((Object)type);
    }

    void registerContribution(Type type, Contributor contributor) {
        if (this.isFocusBased(type)) {
            contributor.getActionFocusComponent().addFocusListener(new ActionFocusListener(contributor));
        } else {
            this.fContributorMap.put(type, new WeakReference<Contributor>(contributor));
        }
    }

    Action getAction(Type type) {
        Action action = this.fActionMap.get((Object)type);
        if (action == null) {
            WeakReference<Contributor> weakReference = this.fContributorMap.get((Object)type);
            Contributor contributor = null;
            if (weakReference != null && (contributor = (Contributor)weakReference.get()) == null) {
                this.fContributorMap.remove((Object)type);
            }
            if (contributor != null && (action = contributor.getAction(type)) != null) {
                this.fActionMap.put(type, action);
            }
        }
        return action;
    }

    private static class SelectAllAction
    extends ChildAction {
        SelectAllAction() {
            super(null);
            this.setName(MJUtilities.intlString((String)"action.SelectAll"));
            this.setComponentName("SelectAll");
            DTMenuMergeTag.SELECT_ALL.setTag((Action)((Object)this));
            this.setAccelerator(KeyStroke.getKeyStroke(65, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK));
            this.setEnabled(false);
        }
    }

    private static class PasteAction
    extends ChildAction {
        PasteAction() {
            super(null);
            this.setName(MJUtilities.intlString((String)"action.Paste"));
            this.setComponentName("Paste");
            this.setAccelerator(KeyStroke.getKeyStroke(86, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK));
            this.setButtonOnlyIcon(CommonIcon.PASTE.getIcon());
            DTMenuMergeTag.PASTE.setTag((Action)((Object)this));
            this.setEnabled(false);
        }
    }

    private static class CopyAction
    extends ChildAction {
        CopyAction() {
            super(null);
            this.setName(MJUtilities.intlString((String)"action.Copy"));
            this.setComponentName("Copy");
            this.setAccelerator(KeyStroke.getKeyStroke(67, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK));
            this.setButtonOnlyIcon(CommonIcon.COPY.getIcon());
            DTMenuMergeTag.COPY.setTag((Action)((Object)this));
            this.setEnabled(false);
        }
    }

    private static class CutAction
    extends ChildAction {
        CutAction() {
            super(null);
            this.setName(MJUtilities.intlString((String)"action.Cut"));
            this.setComponentName("Cut");
            this.setAccelerator(KeyStroke.getKeyStroke(88, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK));
            this.setButtonOnlyIcon(CommonIcon.CUT.getIcon());
            DTMenuMergeTag.CUT.setTag((Action)((Object)this));
            this.setEnabled(false);
        }
    }

    private class ActionFocusListener
    implements FocusListener {
        Contributor iContributor;

        ActionFocusListener(Contributor contributor) {
            this.iContributor = contributor;
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            for (Type type : Actions.this.fFocusBasedTypes) {
                Action action = this.iContributor.getAction(type);
                if (action == null) continue;
                action.putValue(Actions.CONTRIBUTOR_PROPERTY, this.iContributor);
                ChildAction childAction = (ChildAction)Actions.this.fActionMap.get((Object)type);
                childAction.setParent(action);
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (focusEvent.isTemporary()) {
                return;
            }
            for (Type type : Actions.this.fFocusBasedTypes) {
                ChildAction childAction = (ChildAction)Actions.this.fActionMap.get((Object)type);
                Action action = childAction.getParent();
                if (action == null || action.getValue(Actions.CONTRIBUTOR_PROPERTY) != this.iContributor) continue;
                childAction.setParent(null);
                childAction.setEnabled(false);
            }
        }
    }

    static interface Contributor {
        public Action getAction(Type var1);

        public Component getActionFocusComponent();
    }

    static enum Type {
        UNDO,
        CUT,
        COPY,
        PASTE,
        SELECT_ALL,
        DELETE,
        CLEAR_OUTPUT,
        CLEAR_ALL_OUTPUT,
        CLEAR_HISTORY,
        DISPLAY_LABS,
        TARGET_LABS,
        SINGLE_OUTPUT,
        TILE_OUTPUT,
        TAB_OUTPUT,
        COMMANDS_IN_OUTPUT;

    }
}

