/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.mjs.security;

import com.mathworks.toolbox.distcomp.mjs.security.SharedSecretException;
import com.mathworks.toolbox.distcomp.service.PackageInfo;
import com.mathworks.toolbox.distcomp.util.security.KeyStoreFactory;
import com.mathworks.toolbox.distcomp.util.security.SSLContextFactory;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import javax.net.ssl.SSLContext;

public final class SharedSecret {
    private static final String SHARED_SECRET_ALIAS = "SHARED_SECRET";
    private static final String KEYSTORE_PATH_NOT_SPECIFIED = "KEYSTORE_PATH_NOT_SPECIFIED";
    private static SharedSecret sINSTANCE;
    private final KeyStore fKeyStore = SharedSecret.loadSharedSecret();

    public static SharedSecret getInstance() {
        if (sINSTANCE == null) {
            sINSTANCE = new SharedSecret();
        }
        return sINSTANCE;
    }

    private SharedSecret() {
    }

    public SSLContext createServerSSLContext() {
        SSLContextFactory sSLContextFactory = new SSLContextFactory();
        return sSLContextFactory.createServerSSLContext(this.getKeyStore(), this.getKeyPassword());
    }

    private KeyStore getKeyStore() {
        return this.fKeyStore;
    }

    private char[] getKeyPassword() {
        return SharedSecret.getPasswordFromProperties();
    }

    public Certificate getSharedSecretCertificate() {
        try {
            if (this.fKeyStore.containsAlias(SHARED_SECRET_ALIAS)) {
                return this.fKeyStore.getCertificate(SHARED_SECRET_ALIAS);
            }
            throw new SharedSecretException("Shared Secret keystore does not contain a certificate under the alias: SHARED_SECRET");
        }
        catch (KeyStoreException keyStoreException) {
            throw new SharedSecretException(keyStoreException);
        }
    }

    private static KeyStore loadSharedSecret() {
        String string = SharedSecret.getKeystorePathFromProperties();
        char[] cArray = SharedSecret.getPasswordFromProperties();
        PackageInfo.LOGGER.info("Loading shared secret from " + string);
        try {
            KeyStoreFactory keyStoreFactory = new KeyStoreFactory();
            return keyStoreFactory.createKeyStore(string, cArray);
        }
        catch (IOException iOException) {
            throw new SharedSecretException("The shared secret file could not be read successfully.  Make sure that\na shared secret file has been created and copied to the location set in\nthe mdce_def file.", iOException);
        }
    }

    private static String getKeystorePathFromProperties() {
        String string = System.getProperty("com.mathworks.toolbox.distcomp.mjs.security.keystorePath", KEYSTORE_PATH_NOT_SPECIFIED);
        if (KEYSTORE_PATH_NOT_SPECIFIED.equals(string)) {
            String string2 = System.getProperty("com.mathworks.toolbox.distcomp.mjs.security.defaultKeystorePath");
            if (string2 == null || string2.length() == 0) {
                throw new SharedSecretException("Both keystore file path properties com.mathworks.toolbox.distcomp.mjs.security.keystorePath and com.mathworks.toolbox.distcomp.mjs.security.defaultKeystorePath are not set.");
            }
            string = string2;
        }
        return string;
    }

    private static char[] getPasswordFromProperties() {
        String string = System.getProperty("com.mathworks.toolbox.distcomp.mjs.security.keystorePassword");
        if (string == null || string.length() == 0) {
            throw new SharedSecretException("Keystore password property com.mathworks.toolbox.distcomp.mjs.security.keystorePassword not set.");
        }
        return string.toCharArray();
    }
}

