/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.logging;

import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public final class DistcompSimpleFormatter
extends Formatter {
    private final ThreadLocal<SimpleDateFormat> fThreadLocalDateFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            super.initialValue();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy MM dd HH:mm:ss.SSS z");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            return simpleDateFormat;
        }
    };

    @Override
    public String format(LogRecord logRecord) {
        long l = logRecord.getMillis();
        String string = this.getTimeStamp(l);
        String string2 = Integer.toString(DistcompLevel.getValueFromLevel(logRecord.getLevel()));
        String string3 = logRecord.getMessage();
        String string4 = string + " | " + string2 + " | ";
        String string5 = string4 + string3 + "\n";
        Throwable throwable = logRecord.getThrown();
        while (throwable != null) {
            string5 = string5 + string4 + "Exception: " + throwable.toString() + "\n";
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                string5 = string5 + string4 + "[" + i + "] " + stackTraceElementArray[i].getClassName() + "." + stackTraceElementArray[i].getMethodName() + "(): ";
                if (stackTraceElementArray[i].getLineNumber() > 0) {
                    string5 = string5 + stackTraceElementArray[i].getLineNumber();
                }
                string5 = string5 + "\n";
            }
            if ((throwable = throwable.getCause()) == null) continue;
            string5 = string5 + string4 + "Caused by " + "\n";
        }
        return string5;
    }

    private String getTimeStamp(long l) {
        Date date = new Date(l);
        SimpleDateFormat simpleDateFormat = this.fThreadLocalDateFormat.get();
        return simpleDateFormat.format(date);
    }
}

