/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.local;

import com.mathworks.toolbox.distcomp.local.AbstractExecutableCommand;
import com.mathworks.toolbox.distcomp.local.LocalScheduler;
import com.mathworks.toolbox.distcomp.remote.util.StreamRedirector;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class ParallelJobCommand
extends AbstractExecutableCommand {
    private int[] fNumLabsRequested;
    private int fNumLabs;
    private Process[] fProcesses;

    public static ParallelJobCommand getNewInstance(String[] stringArray, String[] stringArray2, String[] stringArray3, String string, int[] nArray) throws IOException {
        return (ParallelJobCommand)ParallelJobCommand.addCommandToScheduler(new ParallelJobCommand(stringArray, stringArray2, stringArray3, string, nArray));
    }

    protected ParallelJobCommand(String[] stringArray, String[] stringArray2, String[] stringArray3, String string, int[] nArray) throws IOException {
        super(stringArray, stringArray2, stringArray3, string);
        if (nArray == null || nArray.length != 2) {
            throw new IllegalStateException("Invalid number of workers requested");
        }
        if (nArray[0] < 1 || nArray[0] > LocalScheduler.getInstance().getMaximumNumberOfWorkers() || nArray[0] > nArray[1]) {
            throw new IllegalStateException("More workers requested that available in the local scheduler. This job would never run.");
        }
        this.fNumLabsRequested = nArray;
    }

    public int getMaximumNumberOfLabs() {
        return this.fNumLabsRequested[1];
    }

    public int getMinimumNumberOfLabs() {
        return this.fNumLabsRequested[0];
    }

    public int getNumberOfLabs() {
        return this.fNumLabs;
    }

    public Process[] getProcesses() {
        return this.fProcesses;
    }

    @Override
    public synchronized String getState() {
        if (!this.hasStartedRunning()) {
            return "queued";
        }
        if (this.isRunning()) {
            return "running";
        }
        if (this.isCancelled()) {
            return "finished";
        }
        if (this.isDestroyed()) {
            return "destroyed";
        }
        if (this.isDone()) {
            for (int i = 0; i < this.fProcesses.length; ++i) {
                if (this.fProcesses[i] != null && this.fProcesses[i].exitValue() == 0) continue;
                return "failed";
            }
            return "finished";
        }
        return "unavailable";
    }

    private Future<Object>[] makeFutureArray(int n) {
        return new Future[n];
    }

    /*
     * Exception decompiling
     */
    @Override
    public Object onRun() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void destroyAllProcesses() {
        for (int i = 0; i < this.fProcesses.length; ++i) {
            if (this.fProcesses[i] == null) continue;
            this.fProcesses[i].destroy();
        }
    }

    private class ParallelTaskCommand
    implements Callable<Object> {
        private int fLabRank;
        private FileOutputStream fOutputStream;

        ParallelTaskCommand(int n, FileOutputStream fileOutputStream) {
            this.fLabRank = n;
            this.fOutputStream = fileOutputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive exception aggregation
         */
        @Override
        public Object call() throws Exception {
            boolean bl = false;
            try {
                Process process;
                Object object;
                Object object2 = ParallelJobCommand.this.fProcessBuilder;
                synchronized (object2) {
                    object = ParallelJobCommand.this.fProcessBuilder.environment();
                    object.put((String)"MDCE_NUMLABS", (String)Integer.toString(ParallelJobCommand.this.fNumLabs));
                    object.put((String)"MDCE_LABINDEX", (String)Integer.toString(this.fLabRank + 1));
                    ((ParallelJobCommand)ParallelJobCommand.this).fProcesses[this.fLabRank] = process = ParallelJobCommand.this.createProcessFromBuilderWithRetry();
                }
                try {
                    object2 = ParallelJobCommand.this.getStreamRedirector().addRedirect(process.getInputStream(), this.fOutputStream, "[" + this.fLabRank + "]");
                    object = ParallelJobCommand.this.getStreamRedirector().addRedirect(process.getErrorStream(), this.fOutputStream, "[" + this.fLabRank + "]");
                    try {
                        process.waitFor();
                        bl = true;
                        Object var5_9 = null;
                        ParallelJobCommand.this.getStreamRedirector().removeRedirect((StreamRedirector.RedirectionPair)object);
                        ParallelJobCommand.this.getStreamRedirector().removeRedirect((StreamRedirector.RedirectionPair)object2);
                        return var5_9;
                    }
                    catch (Throwable throwable) {
                        ParallelJobCommand.this.getStreamRedirector().removeRedirect((StreamRedirector.RedirectionPair)object);
                        ParallelJobCommand.this.getStreamRedirector().removeRedirect((StreamRedirector.RedirectionPair)object2);
                        throw throwable;
                    }
                }
                finally {
                    if (bl) {
                        if (process.exitValue() != 0) {
                            ParallelJobCommand.this.destroyAllProcesses();
                        }
                    } else {
                        process.destroy();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
            catch (Exception exception) {
                if (ParallelJobCommand.this.isDestroyed() || Thread.currentThread().isInterrupted()) {
                    return null;
                }
                exception.printStackTrace();
                throw exception;
            }
            catch (Error error) {
                error.printStackTrace();
                throw error;
            }
        }
    }
}

