/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.local;

import com.mathworks.toolbox.distcomp.local.LocalScheduler;
import com.mathworks.toolbox.distcomp.remote.util.StreamRedirector;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public abstract class AbstractLocalCommand
implements Callable<Object> {
    static final String QUEUED_STATE = "queued";
    static final String RUNNING_STATE = "running";
    static final String FINISHED_STATE = "finished";
    static final String FAILED_STATE = "failed";
    static final String CANCELLED_STATE = "finished";
    static final String DESTROYED_STATE = "destroyed";
    static final String UNKNOWN_STATE = "unavailable";
    protected Future fFuture;
    private LocalScheduler fScheduler = LocalScheduler.getInstance();
    private StreamRedirector fRedirector = StreamRedirector.getInstance();
    protected boolean fSubmitted = false;
    protected boolean fDispatched = false;
    protected boolean fStartedRunning = false;
    protected boolean fCancelled = false;
    protected boolean fDestroyed = false;
    protected UUID fUUID = UUID.randomUUID();

    protected AbstractLocalCommand() {
    }

    protected static AbstractLocalCommand addCommandToScheduler(AbstractLocalCommand abstractLocalCommand) {
        abstractLocalCommand.getScheduler().addCommand(abstractLocalCommand.getUUID(), abstractLocalCommand);
        return abstractLocalCommand;
    }

    public UUID getUUID() {
        return this.fUUID;
    }

    public synchronized boolean isSubmitted() {
        return this.fSubmitted;
    }

    public synchronized boolean isCancelled() {
        return this.fCancelled;
    }

    public synchronized boolean hasStartedRunning() {
        return this.fStartedRunning;
    }

    public synchronized boolean isRunning() {
        return this.fStartedRunning ? !this.fFuture.isDone() : false;
    }

    public synchronized boolean isDone() {
        return this.fSubmitted ? this.fFuture.isDone() : false;
    }

    public synchronized boolean isDestroyed() {
        return this.fDestroyed;
    }

    public LocalScheduler getScheduler() {
        return this.fScheduler;
    }

    public StreamRedirector getStreamRedirector() {
        return this.fRedirector;
    }

    public synchronized void submit() {
        if (!(this.fDestroyed || this.fCancelled || this.fSubmitted)) {
            this.fFuture = this.getScheduler().submit(this);
            this.fSubmitted = true;
        }
    }

    public synchronized boolean cancel() {
        this.fCancelled = true;
        return this.fSubmitted ? this.fFuture.cancel(true) : true;
    }

    public synchronized void destroy() {
        if (this.fSubmitted) {
            this.cancel();
        }
        this.getScheduler().removeCommand(this.fUUID);
        this.fDestroyed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call() throws Exception {
        AbstractLocalCommand abstractLocalCommand = this;
        synchronized (abstractLocalCommand) {
            assert (!this.fDispatched) : "Trying to run an AbstractLocalCommand twice";
            this.fDispatched = true;
        }
        return this.onRun();
    }

    public abstract Object onRun() throws Exception;

    public synchronized String getState() {
        if (!this.hasStartedRunning()) {
            return QUEUED_STATE;
        }
        if (this.isRunning()) {
            return RUNNING_STATE;
        }
        if (this.isCancelled()) {
            return "finished";
        }
        if (this.isDestroyed()) {
            return DESTROYED_STATE;
        }
        if (this.isDone()) {
            return "finished";
        }
        return UNKNOWN_STATE;
    }
}

