/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.jobmanager;

import com.mathworks.toolbox.distcomp.jobmanager.JobManagerConnectorSSLSecurityDescription;
import com.mathworks.toolbox.distcomp.pmode.shared.AcceptorSSLSecurityDescription;
import com.mathworks.toolbox.distcomp.pmode.shared.AcceptorSecurityDescription;
import com.mathworks.toolbox.distcomp.pmode.shared.ConnectionFactory;
import com.mathworks.toolbox.distcomp.pmode.shared.ConnectorSecurityDescription;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;

public class JobManagerAcceptorSSLSecurityDescription
implements AcceptorSecurityDescription {
    private final AcceptorSecurityDescription fAcceptorSecurityDescription;
    private final boolean fAcceptorUseClientMode;
    private final Certificate fCertificate;

    public JobManagerAcceptorSSLSecurityDescription(SSLContext sSLContext, boolean bl, Certificate certificate) {
        this.fAcceptorSecurityDescription = new AcceptorSSLSecurityDescription(sSLContext, bl, certificate);
        this.fAcceptorUseClientMode = bl;
        this.fCertificate = certificate;
    }

    @Override
    public ConnectionFactory createConnectionFactoryForAcceptor() {
        return this.fAcceptorSecurityDescription.createConnectionFactoryForAcceptor();
    }

    @Override
    public ConnectorSecurityDescription createConnectorSecurityDescription() {
        if (this.fCertificate == null) {
            return new JobManagerConnectorSSLSecurityDescription(!this.fAcceptorUseClientMode);
        }
        return this.fAcceptorSecurityDescription.createConnectorSecurityDescription();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JobManagerAcceptorSSLSecurityDescription jobManagerAcceptorSSLSecurityDescription = (JobManagerAcceptorSSLSecurityDescription)object;
        return !(this.fAcceptorSecurityDescription != null ? !this.fAcceptorSecurityDescription.equals(jobManagerAcceptorSSLSecurityDescription.fAcceptorSecurityDescription) : jobManagerAcceptorSSLSecurityDescription.fAcceptorSecurityDescription != null);
    }

    public int hashCode() {
        return this.fAcceptorSecurityDescription != null ? this.fAcceptorSecurityDescription.hashCode() : 0;
    }

    public String toString() {
        String string = this.fCertificate == null ? "not set" : ((X509Certificate)this.fCertificate).getSubjectX500Principal().toString();
        return "JobManagerAcceptorSSLSecurityDescription{fAcceptorUseClientMode=" + this.fAcceptorUseClientMode + ", fCertificate=" + string + '}';
    }
}

