/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.distcompobjects;

import com.mathworks.toolbox.distcomp.distcompobjects.RemoteListenerAndEvent;
import com.mathworks.toolbox.distcomp.util.ErrorPrinterImpl;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.UnknownEventException;

public final class EventNotifier
implements Runnable {
    private Thread fNotificationThread;
    private List<RemoteListenerAndEvent> fWaitingNotifications = Collections.synchronizedList(new LinkedList());

    public static EventNotifier getInstance() {
        return EventNotifierHolder.singleton;
    }

    private EventNotifier() {
        this.fNotificationThread = new Thread(this);
        this.fNotificationThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeferredNotification(RemoteListenerAndEvent remoteListenerAndEvent) {
        this.fWaitingNotifications.add(remoteListenerAndEvent);
        EventNotifier eventNotifier = this;
        synchronized (eventNotifier) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeferredNotification(Collection<RemoteListenerAndEvent> collection) {
        this.fWaitingNotifications.addAll(collection);
        EventNotifier eventNotifier = this;
        synchronized (eventNotifier) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Object object;
            if (!this.fWaitingNotifications.isEmpty()) {
                object = this.fWaitingNotifications.remove(0);
                RemoteEventListener remoteEventListener = ((RemoteListenerAndEvent)object).getListener();
                RemoteEvent remoteEvent = ((RemoteListenerAndEvent)object).getEvent();
                try {
                    remoteEventListener.notify(remoteEvent);
                }
                catch (RemoteException remoteException) {
                    new ErrorPrinterImpl().printError("A MATLAB client could not be contacted to trigger a callback.", remoteException);
                }
                catch (UnknownEventException unknownEventException) {
                    new ErrorPrinterImpl().printError("A callback could not be triggered because the MATLAB client\nwas no longer interested in the callback.", (Exception)((Object)unknownEventException));
                }
                catch (Throwable throwable) {
                    new ErrorPrinterImpl().printError(throwable);
                }
                continue;
            }
            try {
                object = this;
                synchronized (object) {
                    if (this.fWaitingNotifications.isEmpty()) {
                        this.wait();
                    }
                    continue;
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private static final class EventNotifierHolder {
        static final EventNotifier singleton = new EventNotifier();

        private EventNotifierHolder() {
        }
    }
}

