/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.distcompobjects;

import com.mathworks.toolbox.distcomp.distcompobjects.DistcompListenable;
import com.mathworks.toolbox.distcomp.distcompobjects.EventNotifier;
import com.mathworks.toolbox.distcomp.distcompobjects.Identifiable;
import com.mathworks.toolbox.distcomp.distcompobjects.ListenerInfo;
import com.mathworks.toolbox.distcomp.distcompobjects.RemoteListenerAndEvent;
import com.mathworks.toolbox.distcomp.util.ErrorPrinterImpl;
import java.io.IOException;
import java.rmi.MarshalledObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;

public abstract class DistcompListenableImpl
implements DistcompListenable,
Identifiable {
    protected Map<ListenerInfo, Long> fListenerInfoToNumEvents = DistcompListenableImpl.initMap();
    private long fSeqNum = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recordEvent(long l) {
        HashSet<RemoteListenerAndEvent> hashSet = new HashSet<RemoteListenerAndEvent>();
        Map<ListenerInfo, Long> map = this.fListenerInfoToNumEvents;
        synchronized (map) {
            Set<Map.Entry<ListenerInfo, Long>> set = this.fListenerInfoToNumEvents.entrySet();
            for (Map.Entry<ListenerInfo, Long> entry : set) {
                ListenerInfo listenerInfo = entry.getKey();
                Long l2 = entry.getValue();
                if (listenerInfo.getEventID() != l && listenerInfo.getEventID() != 0L) continue;
                long l3 = listenerInfo.getInterval();
                if (l2 < l3) {
                    this.fListenerInfoToNumEvents.put(listenerInfo, new Long(l2 + 1L));
                    continue;
                }
                try {
                    RemoteEvent remoteEvent = new RemoteEvent((Object)this.getID(), l, this.fSeqNum++, listenerInfo.getHandback());
                    RemoteEventListener remoteEventListener = (RemoteEventListener)listenerInfo.getListener().get();
                    hashSet.add(new RemoteListenerAndEvent(remoteEventListener, remoteEvent));
                }
                catch (IOException iOException) {
                    new ErrorPrinterImpl().printError("Unable to recover event listener", iOException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    new ErrorPrinterImpl().printError("Unable to recover event listener", classNotFoundException);
                }
                this.fListenerInfoToNumEvents.put(listenerInfo, new Long(0L));
            }
        }
        EventNotifier.getInstance().addDeferredNotification(hashSet);
    }

    @Override
    public void addEventListener(RemoteEventListener remoteEventListener, long l, long l2, MarshalledObject marshalledObject) {
        try {
            ListenerInfo listenerInfo = new ListenerInfo(new MarshalledObject<RemoteEventListener>(remoteEventListener), l, l2, marshalledObject);
            this.fListenerInfoToNumEvents.put(listenerInfo, new Long(0L));
        }
        catch (IOException iOException) {
            new ErrorPrinterImpl().printError("Unable to register listener for callbacks", iOException);
        }
    }

    @Override
    public void removeEventListener(RemoteEventListener remoteEventListener, long l, long l2) {
        try {
            this.fListenerInfoToNumEvents.remove(new ListenerInfo(new MarshalledObject<RemoteEventListener>(remoteEventListener), l, l2, null));
        }
        catch (IOException iOException) {
            new ErrorPrinterImpl().printError("Unable to register listener for callbacks", iOException);
        }
    }

    @Override
    public void removeEventListener(RemoteEventListener remoteEventListener) {
        this.removeEventListener(remoteEventListener, 0L, 0L);
    }

    protected static Map<ListenerInfo, Long> createListenerInfosMap(ListenerInfo[] listenerInfoArray) {
        Map<ListenerInfo, Long> map = DistcompListenableImpl.initMap();
        if (listenerInfoArray != null) {
            for (ListenerInfo listenerInfo : listenerInfoArray) {
                map.put(listenerInfo, new Long(0L));
            }
        }
        return map;
    }

    protected static ListenerInfo[] getListenerInfosFromMap(Map<ListenerInfo, Long> map) {
        return map.keySet().toArray(new ListenerInfo[0]);
    }

    private static Map<ListenerInfo, Long> initMap() {
        return Collections.synchronizedMap(new HashMap());
    }
}

