/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.server;

import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.Log;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.server.PeerSCExecutorDispatcher;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerActiveAcceptor;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerDispatcher;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerInstance;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerMessagingException;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerSession;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerSessionEndedEvent;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerSessionFatalErrorHandler;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerSessionListener;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.ProtocolId;
import com.mathworks.toolbox.distcomp.pmode.shared.AcceptorPlainSecurityDescription;
import com.mathworks.toolbox.distcomp.pmode.shared.Connection;
import com.mathworks.toolbox.distcomp.pmode.shared.Message;
import com.mathworks.toolbox.distcomp.pmode.shared.PlainConnectionFactory;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketAcceptInfo;
import com.mathworks.toolbox.distcomp.util.concurrent.SignalingAtomicBoolean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.UUID;

final class PeerSCExecutorService
implements PeerSessionListener {
    private PeerSession fServerSession;
    private PeerActiveAcceptor fPeerAcceptor;
    private final SignalingAtomicBoolean fHasEnded = new SignalingAtomicBoolean(false);

    PeerSCExecutorService(int n, UUID uUID, long l) throws FailedToStartException {
        UUID uUID2 = UUID.randomUUID();
        PeerInstance peerInstance = new PeerInstance(ProtocolId.WINSC, uUID, uUID2);
        try {
            String string = InetAddress.getLocalHost().getHostName();
            AcceptorPlainSecurityDescription acceptorPlainSecurityDescription = new AcceptorPlainSecurityDescription();
            PlainConnectionFactory plainConnectionFactory = new PlainConnectionFactory();
            ServerSocketAcceptInfo serverSocketAcceptInfo = new ServerSocketAcceptInfo(peerInstance.getGroupUuid(), n, 1, acceptorPlainSecurityDescription, 10000L);
            this.fPeerAcceptor = new PeerActiveAcceptor(string, peerInstance, serverSocketAcceptInfo);
            Connection connection = this.fPeerAcceptor.activelyAccept(100L, l);
            Log.LOGGER.finest("Accepted " + connection);
            PeerSCExecutorDispatcher peerSCExecutorDispatcher = new PeerSCExecutorDispatcher(connection.getRemoteInstance());
            HashSet<PeerDispatcher<? extends Message>> hashSet = new HashSet<PeerDispatcher<? extends Message>>();
            hashSet.add(peerSCExecutorDispatcher);
            HashSet<Connection> hashSet2 = new HashSet<Connection>();
            hashSet2.add(connection);
            this.fServerSession = new PeerSession(peerInstance, new PeerSessionFatalErrorHandler(), hashSet, hashSet2);
            this.fServerSession.addSessionListener(this);
            Log.LOGGER.finest("Set up PeerSession " + this.fServerSession);
        }
        catch (PeerMessagingException peerMessagingException) {
            throw new FailedToStartException("PeerSCExecutorService failed to start.", peerMessagingException);
        }
        catch (UnknownHostException unknownHostException) {
            throw new FailedToStartException("PeerSCExecutorService failed to start.", unknownHostException);
        }
    }

    public void awaitEnd() throws InterruptedException {
        Log.LOGGER.finest("started awaitEnd()");
        this.fHasEnded.awaitTrue();
        Log.LOGGER.finest("finished awaitEnd()");
    }

    public void end() {
        this.fHasEnded.set(true);
        Log.LOGGER.finest("signalled end");
        this.fServerSession.normalShutdown();
        this.fPeerAcceptor.close();
    }

    @Override
    public void sessionClosed(PeerSessionEndedEvent peerSessionEndedEvent) {
        Log.LOGGER.fine("PeerSession closed normally");
        this.end();
    }

    @Override
    public void sessionErrored(PeerSessionEndedEvent peerSessionEndedEvent) {
        Log.LOGGER.severe("PeerSession errored: " + peerSessionEndedEvent.getErrorMsg().getMessage());
        this.end();
    }

    static class FailedToStartException
    extends Exception {
        private FailedToStartException(String string) {
            super(string);
        }

        private FailedToStartException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

