/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control;

import com.mathworks.toolbox.distcomp.auth.credentials.AuthenticationToken;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.CredentialConsumerFactory;
import com.mathworks.toolbox.distcomp.auth.credentials.store.SingleUserCredentialStore;
import com.mathworks.toolbox.distcomp.control.ClusterLogsResults;
import com.mathworks.toolbox.distcomp.control.MDCSCommand;
import com.mathworks.toolbox.distcomp.control.MDCSCommandResults;
import com.mathworks.toolbox.distcomp.control.NoServicesFoundException;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerLocal;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.mjs.client.JobManagerClient;
import com.mathworks.toolbox.distcomp.service.ServiceAccessor;
import com.mathworks.toolbox.distcomp.service.UnicastServiceNotFoundException;
import com.mathworks.toolbox.distcomp.worker.WorkerLocal;
import java.rmi.RemoteException;
import net.jini.config.ConfigurationException;

public class ClusterLogsCommand
extends MDCSCommand {
    private static final long serialVersionUID = 1L;
    private String fRemoteHostname = "";
    private String fAction = "";
    private String fJobManagerName = "";
    private int fLogLevel = 0;

    public ClusterLogsCommand(String string, int n, String string2) {
        this.fAction = string;
        this.fLogLevel = n;
        this.fJobManagerName = string2;
    }

    public void setRemoteHostname(String string) {
        this.fRemoteHostname = string != null ? string : "";
    }

    @Override
    public String getPreRunDescription() {
        if (this.fRemoteHostname.length() == 0) {
            return "Running the cluster log level command.";
        }
        return "Running the cluster log level command on the host " + this.fRemoteHostname + ".";
    }

    @Override
    public MDCSCommandResults run() throws Exception {
        MDCSCommandResults mDCSCommandResults;
        JobManagerLocal[] jobManagerLocalArray;
        if (this.fAction.equals("getLocation")) {
            String string = System.getProperty("com.mathworks.toolbox.distcomp.logdir", null);
            return ClusterLogsResults.create(string);
        }
        if (this.fJobManagerName.isEmpty()) {
            this.fJobManagerName = System.getProperty("com.mathworks.toolbox.distcomp.default_jobmanager_name");
        }
        try {
            jobManagerLocalArray = ServiceAccessor.getJobManagers("localhost", this.fJobManagerName);
        }
        catch (UnicastServiceNotFoundException unicastServiceNotFoundException) {
            jobManagerLocalArray = new JobManagerLocal[]{};
        }
        assert (jobManagerLocalArray.length < 2) : "There cannot be more than one job manager with the same name on the same host";
        if (jobManagerLocalArray.length > 0) {
            mDCSCommandResults = this.runOnJobManager(jobManagerLocalArray[0]);
        } else {
            Object[] objectArray;
            try {
                objectArray = ServiceAccessor.getMLWorkers("localhost", "");
            }
            catch (UnicastServiceNotFoundException unicastServiceNotFoundException) {
                objectArray = new Object[]{};
            }
            if (objectArray.length < 1) {
                throw new NoServicesFoundException("No job managers called " + this.fJobManagerName + " or any workers were found on this machine");
            }
            mDCSCommandResults = this.runOnWorker((WorkerLocal[])objectArray);
        }
        return mDCSCommandResults;
    }

    private MDCSCommandResults runOnJobManager(JobManagerLocal jobManagerLocal) throws ConfigurationException, MJSException, RemoteException {
        MDCSCommandResults mDCSCommandResults;
        JobManagerClient jobManagerClient = new JobManagerClient(jobManagerLocal, ClusterLogsCommand.createCredentialConsumerFactory(), new SingleUserCredentialStore<AuthenticationToken>());
        if (this.fAction.equals("setLevel")) {
            jobManagerClient.setClusterLogLevel(this.fLogLevel);
            mDCSCommandResults = ClusterLogsResults.create(this.fLogLevel);
        } else if (this.fAction.equals("getLevel")) {
            mDCSCommandResults = ClusterLogsResults.create(jobManagerLocal.getClusterLogLevel());
        } else {
            throw new ConfigurationException("Invalid action for clusterlogs: " + this.fAction);
        }
        return mDCSCommandResults;
    }

    private MDCSCommandResults runOnWorker(WorkerLocal[] workerLocalArray) throws RemoteException, ConfigurationException, MJSException, NoServicesFoundException {
        MDCSCommandResults mDCSCommandResults;
        if (this.fAction.equals("setLevel")) {
            for (WorkerLocal workerLocal : workerLocalArray) {
                workerLocal.setLogLevel(this.fLogLevel);
            }
            mDCSCommandResults = ClusterLogsResults.create(this.fLogLevel);
        } else if (this.fAction.equals("getLevel")) {
            mDCSCommandResults = ClusterLogsResults.create(workerLocalArray[0].getLogLevel());
        } else {
            throw new ConfigurationException("Invalid action for clusterlogs: " + this.fAction);
        }
        return mDCSCommandResults;
    }

    private static CredentialConsumerFactory createCredentialConsumerFactory() {
        return CredentialConsumerFactory.TRIVIAL_FACTORY;
    }

    @Override
    public int maxTimeForRemoteTries() {
        return 10000;
    }

    @Override
    public int timeBetweenTriesInMilliSeconds() {
        return 2000;
    }
}

