/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.clusteraccess;

import com.mathworks.toolbox.distcomp.remote.RemoteExecutionException;
import com.mathworks.toolbox.distcomp.remote.util.HasMatlabSpecificMessage;

abstract class RemoteMachineException
extends Exception {
    private final ErrorCode fErrorCode;

    RemoteMachineException(ErrorCode errorCode, String string) {
        super(string);
        this.fErrorCode = errorCode;
    }

    RemoteMachineException(String string, RemoteExecutionException remoteExecutionException) {
        super(RemoteMachineException.createMessage(string, remoteExecutionException), remoteExecutionException);
        this.fErrorCode = ErrorCode.errorCodeFromREErrorCode(remoteExecutionException.getErrorCode());
    }

    RemoteMachineException(ErrorCode errorCode, String string, Exception exception) {
        super(RemoteMachineException.createMessage(string, exception), exception);
        this.fErrorCode = errorCode;
    }

    public ErrorCode getErrorCode() {
        return this.fErrorCode;
    }

    private static String createMessage(String string, Exception exception) {
        return string + ": " + RemoteMachineException.createMessage(exception);
    }

    private static String createMessage(Exception exception) {
        if (exception instanceof HasMatlabSpecificMessage) {
            HasMatlabSpecificMessage hasMatlabSpecificMessage = (HasMatlabSpecificMessage)((Object)exception);
            return hasMatlabSpecificMessage.getMatlabSpecificMessage();
        }
        return exception.getMessage();
    }

    public static enum ErrorCode {
        CONNECT("CouldNotConnect"),
        STARTOP("CouldNotStartRemoteOperation"),
        COMPLETEOP("CouldNotCompleteRemoteOperation"),
        STATE("BadClientState");

        private final String fMatlabCode;

        private ErrorCode(String string2) {
            this.fMatlabCode = string2;
        }

        public String getMatlabErrorId() {
            return this.fMatlabCode;
        }

        static ErrorCode errorCodeFromREErrorCode(RemoteExecutionException.ErrorCode errorCode) {
            if (RemoteExecutionException.ErrorCode.CONNECT == errorCode) {
                return CONNECT;
            }
            if (RemoteExecutionException.ErrorCode.STARTOP == errorCode) {
                return STARTOP;
            }
            if (RemoteExecutionException.ErrorCode.COMPLETEOP == errorCode) {
                return COMPLETEOP;
            }
            throw new AssertionError((Object)("Someone added a new sort of error code to " + RemoteExecutionException.class.getName()));
        }
    }
}

