/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.clusteraccess;

import com.mathworks.toolbox.distcomp.clusteraccess.CouldNotConnectException;
import com.mathworks.toolbox.distcomp.clusteraccess.CouldNotSendJobFilesException;
import com.mathworks.toolbox.distcomp.clusteraccess.ExecuteCommandChore;
import com.mathworks.toolbox.distcomp.clusteraccess.FileMirrorControl;
import com.mathworks.toolbox.distcomp.clusteraccess.HostInfo;
import com.mathworks.toolbox.distcomp.clusteraccess.JobAlreadyMirroredException;
import com.mathworks.toolbox.distcomp.clusteraccess.LastMirrorFilesChore;
import com.mathworks.toolbox.distcomp.clusteraccess.Logger;
import com.mathworks.toolbox.distcomp.clusteraccess.MirrorFilesChore;
import com.mathworks.toolbox.distcomp.clusteraccess.MirrorFilesInfo;
import com.mathworks.toolbox.distcomp.clusteraccess.NotConnectedToHostWithParametersException;
import com.mathworks.toolbox.distcomp.clusteraccess.RemoteMachineChore;
import com.mathworks.toolbox.distcomp.remote.DispatchException;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.JSchSessionLeaseSource;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

public final class ClusterAccess {
    public static final ClusterAccess INSTANCE = new ClusterAccess();
    private static final Map<HostInfo, FileMirrorControl> fHostInfoToFileMirrorControls = new LinkedHashMap<HostInfo, FileMirrorControl>(1);
    private final Lock fLock = new ReentrantLock();

    private ClusterAccess() {
    }

    public void connect(String string, ParameterMap parameterMap) throws DispatchException {
        JSchSessionLeaseSource.INSTANCE.ensureLeaseMonitorExists(string, parameterMap);
        HostInfo hostInfo = new HostInfo(string, parameterMap);
        this.getOrCreateFileMirrorControl(hostInfo);
    }

    public void disconnect(String string, ParameterMap parameterMap) {
        HostInfo hostInfo = new HostInfo(string, parameterMap);
        FileMirrorControl fileMirrorControl = this.removeFileMirrorControl(hostInfo);
        if (fileMirrorControl != null) {
            fileMirrorControl.cancelAllFileMirrorChores();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileMirrorControl removeFileMirrorControl(HostInfo hostInfo) {
        try {
            this.fLock.lock();
            FileMirrorControl fileMirrorControl = fHostInfoToFileMirrorControls.remove(hostInfo);
            return fileMirrorControl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    public RemoteMachineChore sendAndMirrorJobFiles(String string, ParameterMap parameterMap, MirrorFilesInfo mirrorFilesInfo) throws JobAlreadyMirroredException, InterruptedException, CouldNotSendJobFilesException, NotConnectedToHostWithParametersException, CouldNotConnectException {
        HostInfo hostInfo = new HostInfo(string, parameterMap);
        FileMirrorControl fileMirrorControl = this.getFileMirrorControl(hostInfo);
        return fileMirrorControl.sendAndMirrorJobFiles(mirrorFilesInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileMirrorControl getOrCreateFileMirrorControl(HostInfo hostInfo) {
        try {
            this.fLock.lock();
            FileMirrorControl fileMirrorControl = fHostInfoToFileMirrorControls.get(hostInfo);
            if (fileMirrorControl == null) {
                fileMirrorControl = new FileMirrorControl(hostInfo.getHostname(), hostInfo.getParameterMap());
                fHostInfoToFileMirrorControls.put(hostInfo, fileMirrorControl);
            }
            FileMirrorControl fileMirrorControl2 = fileMirrorControl;
            return fileMirrorControl2;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileMirrorControl getFileMirrorControl(HostInfo hostInfo) throws NotConnectedToHostWithParametersException {
        try {
            this.fLock.lock();
            FileMirrorControl fileMirrorControl = fHostInfoToFileMirrorControls.get(hostInfo);
            if (fileMirrorControl == null) {
                throw new NotConnectedToHostWithParametersException(hostInfo);
            }
            FileMirrorControl fileMirrorControl2 = fileMirrorControl;
            return fileMirrorControl2;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJobBeingMirrored(String string, ParameterMap parameterMap, int n) {
        HostInfo hostInfo = new HostInfo(string, parameterMap);
        try {
            this.fLock.lock();
            FileMirrorControl fileMirrorControl = this.getFileMirrorControl(hostInfo);
            boolean bl = fileMirrorControl.isBeingMirrored(n);
            return bl;
        }
        catch (NotConnectedToHostWithParametersException notConnectedToHostWithParametersException) {
            Logger.LOGGER.log(Level.WARNING, "Not connected to " + string + " with given parameters while inquiring about job " + n, notConnectedToHostWithParametersException);
            boolean bl = false;
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    public LastMirrorFilesChore doLastMirrorForJob(String string, ParameterMap parameterMap, MirrorFilesInfo mirrorFilesInfo) throws InterruptedException, NotConnectedToHostWithParametersException, CouldNotConnectException {
        HostInfo hostInfo = new HostInfo(string, parameterMap);
        FileMirrorControl fileMirrorControl = this.getFileMirrorControl(hostInfo);
        return fileMirrorControl.doLastMirrorForJob(mirrorFilesInfo);
    }

    public LastMirrorFilesChore stopMirroringJobGracefully(String string, ParameterMap parameterMap, MirrorFilesInfo mirrorFilesInfo, long l) throws NotConnectedToHostWithParametersException {
        HostInfo hostInfo = new HostInfo(string, parameterMap);
        FileMirrorControl fileMirrorControl = this.getFileMirrorControl(hostInfo);
        return fileMirrorControl.stopMirroringJobGracefully(mirrorFilesInfo, l);
    }

    public void cancelMirrorForJob(String string, ParameterMap parameterMap, int n) {
        HostInfo hostInfo = new HostInfo(string, parameterMap);
        try {
            FileMirrorControl fileMirrorControl = this.getFileMirrorControl(hostInfo);
            fileMirrorControl.cancelMirrorForJob(n);
        }
        catch (NotConnectedToHostWithParametersException notConnectedToHostWithParametersException) {
            Logger.LOGGER.log(Level.FINEST, "Trying to cancel mirroring for a job, but not connected to the host.", notConnectedToHostWithParametersException);
        }
    }

    public MirrorFilesChore resumeMirrorForJob(String string, ParameterMap parameterMap, MirrorFilesInfo mirrorFilesInfo) throws JobAlreadyMirroredException, NotConnectedToHostWithParametersException, CouldNotConnectException {
        HostInfo hostInfo = new HostInfo(string, parameterMap);
        FileMirrorControl fileMirrorControl = this.getFileMirrorControl(hostInfo);
        return fileMirrorControl.resumeMirrorForJob(mirrorFilesInfo);
    }

    public ExecuteCommandChore executeCommand(String string, ParameterMap parameterMap, String string2) throws InterruptedException, NotConnectedToHostWithParametersException, CouldNotConnectException {
        HostInfo hostInfo = new HostInfo(string, parameterMap);
        FileMirrorControl fileMirrorControl = this.getFileMirrorControl(hostInfo);
        return fileMirrorControl.executeCommand(string2);
    }

    public RemoteMachineChore removeFilesForJob(String string, ParameterMap parameterMap, MirrorFilesInfo mirrorFilesInfo) throws JobAlreadyMirroredException, InterruptedException, NotConnectedToHostWithParametersException, CouldNotConnectException {
        HostInfo hostInfo = new HostInfo(string, parameterMap);
        FileMirrorControl fileMirrorControl = this.getFileMirrorControl(hostInfo);
        return fileMirrorControl.removeFilesForJob(mirrorFilesInfo);
    }

    public MirrorFilesChore getMirrorFilesChore(String string, ParameterMap parameterMap, int n) {
        HostInfo hostInfo = new HostInfo(string, parameterMap);
        try {
            FileMirrorControl fileMirrorControl = this.getFileMirrorControl(hostInfo);
            return fileMirrorControl.getMirrorFilesChore(n);
        }
        catch (NotConnectedToHostWithParametersException notConnectedToHostWithParametersException) {
            Logger.LOGGER.log(Level.FINEST, "Trying to get a mirroring chore, but not connected to the host.", notConnectedToHostWithParametersException);
            return null;
        }
    }
}

