/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.credentials;

import com.mathworks.toolbox.distcomp.auth.CryptoException;
import com.mathworks.toolbox.distcomp.auth.CryptoModule;
import com.mathworks.toolbox.distcomp.auth.EncryptedObject;
import com.mathworks.toolbox.distcomp.auth.Erasable;
import com.mathworks.toolbox.distcomp.auth.credentials.CredentialCreationException;
import com.mathworks.toolbox.distcomp.auth.credentials.EncryptedWebLicenseCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.NontransferableCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;

public class WebLicenseCredentials
implements NontransferableCredentials {
    private final Erasable fWebLicenseToken;
    private final Erasable fLicenseID;
    private final Erasable fLicenseNumber;
    private final Erasable fWebUserName;
    private UserIdentity fUserIdentity;

    public WebLicenseCredentials(UserIdentity userIdentity, String string, String string2, String string3, String string4) {
        this.fWebUserName = new Erasable(string.getBytes());
        this.fWebLicenseToken = new Erasable(string2.getBytes());
        this.fLicenseID = new Erasable(string3.getBytes());
        this.fLicenseNumber = new Erasable(string4.getBytes());
        this.fUserIdentity = userIdentity;
    }

    protected WebLicenseCredentials(UserIdentity userIdentity, Erasable erasable, Erasable erasable2, Erasable erasable3, Erasable erasable4) {
        this.fWebUserName = erasable;
        this.fWebLicenseToken = erasable2;
        this.fLicenseID = erasable3;
        this.fLicenseNumber = erasable4;
        this.fUserIdentity = userIdentity;
    }

    public String getWebUserName() {
        return new String(this.fWebUserName.get());
    }

    public String getWebLicenseToken() {
        return new String(this.fWebLicenseToken.get());
    }

    public String getLicenseID() {
        return new String(this.fLicenseID.get());
    }

    public String getLicenseNumber() {
        return new String(this.fLicenseNumber.get());
    }

    @Override
    public EncryptedWebLicenseCredentials prepare(boolean bl, byte[] byArray, CryptoModule.Encryptor encryptor) throws CredentialCreationException {
        if (!bl) {
            return new EncryptedWebLicenseCredentials(this.fUserIdentity, this.fWebUserName, this.fWebLicenseToken, this.fLicenseID, this.fLicenseNumber);
        }
        try {
            EncryptedObject encryptedObject = encryptor.encryptWithSalt(this.fWebUserName, byArray);
            EncryptedObject encryptedObject2 = encryptor.encryptWithSalt(this.fWebLicenseToken, byArray);
            EncryptedObject encryptedObject3 = encryptor.encryptWithSalt(this.fLicenseID, byArray);
            EncryptedObject encryptedObject4 = encryptor.encryptWithSalt(this.fLicenseNumber, byArray);
            return new EncryptedWebLicenseCredentials(this.fUserIdentity, encryptedObject, encryptedObject2, encryptedObject3, encryptedObject4, byArray);
        }
        catch (CryptoException cryptoException) {
            throw new CredentialCreationException("Could not encrypt credentials", this.fUserIdentity, cryptoException);
        }
    }

    @Override
    public void erase() {
        this.fLicenseID.erase();
        this.fWebLicenseToken.erase();
        this.fWebUserName.erase();
    }

    @Override
    public UserIdentity getUserIdentity() {
        return this.fUserIdentity;
    }
}

