/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.credentials;

import com.mathworks.toolbox.distcomp.auth.CryptoException;
import com.mathworks.toolbox.distcomp.auth.CryptoModule;
import com.mathworks.toolbox.distcomp.auth.EncryptedObject;
import com.mathworks.toolbox.distcomp.auth.Erasable;
import com.mathworks.toolbox.distcomp.auth.credentials.CredentialCreationException;
import com.mathworks.toolbox.distcomp.auth.credentials.PlainCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.TransferableCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;

public class EncryptedPlainCredentials
implements TransferableCredentials {
    public static final EncryptedPlainCredentials EMPTY = new EncryptedPlainCredentials(new UserIdentity("nobody"), new Erasable());
    private final UserIdentity fUserIdentity;
    private final EncryptedObject fEncryptedPassword;
    private final byte[] fSalt;
    private final boolean fEncrypted;

    public EncryptedPlainCredentials(UserIdentity userIdentity, EncryptedObject encryptedObject, byte[] byArray) {
        this.fUserIdentity = userIdentity;
        this.fEncryptedPassword = encryptedObject;
        this.fSalt = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.fSalt, 0, byArray.length);
        this.fEncrypted = true;
    }

    public EncryptedPlainCredentials(UserIdentity userIdentity, Erasable erasable) {
        this.fUserIdentity = userIdentity;
        this.fEncryptedPassword = new EncryptedObject(erasable.get());
        this.fSalt = new byte[0];
        this.fEncrypted = false;
    }

    protected EncryptedPlainCredentials(EncryptedPlainCredentials encryptedPlainCredentials) {
        this.fUserIdentity = encryptedPlainCredentials.fUserIdentity;
        this.fEncryptedPassword = encryptedPlainCredentials.fEncryptedPassword;
        this.fSalt = encryptedPlainCredentials.fSalt;
        this.fEncrypted = encryptedPlainCredentials.fEncrypted;
    }

    @Override
    public UserIdentity getUserIdentity() {
        return this.fUserIdentity;
    }

    @Override
    public PlainCredentials unpack(byte[] byArray, CryptoModule.Decryptor decryptor) throws CredentialCreationException {
        if (!this.fEncrypted) {
            return new PlainCredentials(this.fUserIdentity, new Erasable(this.fEncryptedPassword.get()));
        }
        try {
            Erasable erasable = decryptor.decryptWithSalt(this.fEncryptedPassword, byArray);
            return new PlainCredentials(this.fUserIdentity, erasable);
        }
        catch (CryptoException cryptoException) {
            throw new CredentialCreationException("Could not decrypt credentials", this.fUserIdentity, cryptoException);
        }
    }
}

