/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.testing.view;

import com.mathworks.mwswing.AbstractSortableTable;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.toolbox.distcomp.admincenter.guiutilities.DialogFactory;
import com.mathworks.toolbox.distcomp.admincenter.resources.ResourceStatics;
import com.mathworks.toolbox.distcomp.admincenter.testing.model.NodeData;
import com.mathworks.toolbox.distcomp.admincenter.testing.model.TestResultData;
import com.mathworks.toolbox.distcomp.admincenter.testing.shared.ReturnStatus;
import com.mathworks.toolbox.distcomp.admincenter.testing.view.DetailTableModel;
import com.mathworks.toolbox.distcomp.admincenter.testing.view.LogReport;
import com.mathworks.toolbox.distcomp.admincenter.testing.view.MultilineHeaderRenderer;
import com.mathworks.toolbox.distcomp.admincenter.testing.view.ResultsComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

class DetailTable
extends AbstractSortableTable {
    private int fSortColumn = -1;
    private int fSortDirection = 0;
    private final DialogFactory fDialogFactory;

    public DetailTable(DetailTableModel detailTableModel, DialogFactory dialogFactory) {
        super((TableModel)detailTableModel);
        this.fDialogFactory = dialogFactory;
        this.setCellSelectionEnabled(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    DetailTable.this.showCellLogs(DetailTable.this.rowAtPoint(mouseEvent.getPoint()), DetailTable.this.columnAtPoint(mouseEvent.getPoint()));
                }
            }
        });
        TableCellRenderer tableCellRenderer = new TableCellRenderer(){
            MJLabel renderer = new MJLabel();

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                this.renderer.setHorizontalAlignment(0);
                ResultsComposite resultsComposite = (ResultsComposite)object;
                this.renderer.setIcon(null);
                if (resultsComposite != null) {
                    this.renderer.setIcon(resultsComposite.getStatusIcon());
                }
                Color color = bl ? jTable.getSelectionBackground() : jTable.getBackground();
                this.renderer.setOpaque(true);
                this.renderer.setBackground(color);
                this.renderer.setToolTipText(DetailTable.this.generateTootip(n, n2));
                return this.renderer;
            }
        };
        this.setDefaultRenderer(ResultsComposite.class, tableCellRenderer);
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                ((JComponent)component).setToolTipText(DetailTable.this.generateTootip(n, n2));
                return component;
            }
        };
        this.setDefaultRenderer(NodeData.class, defaultTableCellRenderer);
        this.setTableHeader(new JTableHeader(this.getColumnModel()){

            @Override
            protected TableCellRenderer createDefaultRenderer() {
                return new MultilineHeaderRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                        JComponent jComponent = (JComponent)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                        int n3 = this.getColumnModel().getColumn(n2).getModelIndex();
                        jComponent.setToolTipText(DetailTable.this.generateHeaderTooltip(DetailTableModel.DetailColumn.values()[n3]));
                        return jComponent;
                    }
                };
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                int n = dimension.height;
                TableCellRenderer tableCellRenderer = this.getDefaultRenderer();
                for (int i = 0; i < DetailTable.this.getColumnCount(); ++i) {
                    Component component = tableCellRenderer.getTableCellRendererComponent((JTable)((Object)DetailTable.this), DetailTable.this.getColumnName(i), false, false, 0, i);
                    n = Math.max(n, component.getPreferredSize().height);
                }
                dimension.height = n;
                return dimension;
            }
        });
        this.setHeaderSortingEnabled(false);
        this.setHeaderSortingEnabled(true);
        this.setName("testingDetailTable");
    }

    public void setModel(TableModel tableModel) {
        if (!(tableModel instanceof DetailTableModel)) {
            throw new IllegalArgumentException("TableModel must be instance of DetailTableModel.");
        }
        super.setModel(tableModel);
    }

    public void sortByColumn(int n, int n2) {
        this.fSortColumn = n;
        this.fSortDirection = n2;
        if (n != -1) {
            this.getDetailTableModel().sortBy(this.getColumnModel().getColumn(n).getModelIndex(), n2);
        }
        this.getTableHeader().revalidate();
    }

    public int getSortColumn() {
        return this.fSortColumn;
    }

    public int getSortDirection() {
        return this.fSortDirection;
    }

    private String generateHeaderTooltip(DetailTableModel.DetailColumn detailColumn) {
        return "<html>" + detailColumn.getTooltip() + "</html>";
    }

    private String generateTootip(int n, int n2) {
        int n3 = this.getColumnModel().getColumn(n2).getModelIndex();
        DetailTableModel.DetailColumn detailColumn = DetailTableModel.DetailColumn.values()[n3];
        ResultsComposite resultsComposite = this.getDetailTableModel().getResultsAt(n, detailColumn.ordinal());
        if (resultsComposite == null) {
            return null;
        }
        NodeData nodeData = this.getDetailTableModel().getNode(n);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html><div width=\"250px\"><p>");
        if (detailColumn != DetailTableModel.DetailColumn.NODE) {
            stringBuffer.append(String.format(ResourceStatics.sRes.getString("results.details.tt.cell"), "<b>" + nodeData + "</b>", "<b>" + detailColumn.getShortName() + "</b>"));
        } else {
            stringBuffer.append(String.format(ResourceStatics.sRes.getString("results.details.tt.row"), "<b>" + nodeData + "</b>"));
        }
        stringBuffer.append("</p><br>");
        for (ReturnStatus returnStatus : ReturnStatus.values()) {
            int n4 = resultsComposite.getCount(returnStatus);
            if (n4 <= 0) continue;
            stringBuffer.append("").append(ResourceStatics.sRes.getString("results.summary." + (Object)((Object)returnStatus))).append(": ").append(n4).append("<br>");
        }
        stringBuffer.append("<br>");
        stringBuffer.append(ResourceStatics.sRes.getString("results.details.tt.cell.reminder"));
        stringBuffer.append("</div></html>");
        return stringBuffer.toString();
    }

    private void showCellLogs(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= this.getRowCount() || n2 >= this.getColumnCount()) {
            return;
        }
        ResultsComposite resultsComposite = this.getDetailTableModel().getResultsAt(n, n2);
        if (resultsComposite == null) {
            return;
        }
        TestResultData[] testResultDataArray = resultsComposite.getResults();
        LogReport logReport = new LogReport(testResultDataArray);
        int n3 = this.getColumnModel().getColumn(n2).getModelIndex();
        DetailTableModel.DetailColumn detailColumn = DetailTableModel.DetailColumn.values()[n3];
        NodeData nodeData = this.getDetailTableModel().getNode(n);
        String string = detailColumn == DetailTableModel.DetailColumn.NODE ? String.format(ResourceStatics.sRes.getString("results.details.log.row"), nodeData) : String.format(ResourceStatics.sRes.getString("results.details.log.cell"), nodeData, detailColumn.getShortName());
        this.fDialogFactory.showDialog((Component)((Object)logReport), string);
    }

    private DetailTableModel getDetailTableModel() {
        return (DetailTableModel)this.getModel();
    }
}

