/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.testing.view;

import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.toolbox.distcomp.admincenter.guiutilities.DialogFactory;
import com.mathworks.toolbox.distcomp.admincenter.resources.ResourceStatics;
import com.mathworks.toolbox.distcomp.admincenter.testing.model.TestResultData;
import com.mathworks.toolbox.distcomp.admincenter.testing.model.TestResultDataFilter;
import com.mathworks.toolbox.distcomp.admincenter.testing.model.TestResultsContainer;
import com.mathworks.toolbox.distcomp.admincenter.testing.shared.ReturnStatus;
import com.mathworks.toolbox.distcomp.admincenter.testing.shared.TestCategory;
import com.mathworks.toolbox.distcomp.admincenter.testing.view.DetailTable;
import com.mathworks.toolbox.distcomp.admincenter.testing.view.DetailTableModel;
import com.mathworks.toolbox.distcomp.admincenter.testing.view.LogReport;
import com.mathworks.toolbox.distcomp.admincenter.testing.view.ResultsComposite;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuidePanel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuideRelatedPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;

class DetailReport
extends StyleGuidePanel {
    private final DetailTable fMainTable;
    private final DialogFactory fDialogFactory;

    DetailReport(TestResultsContainer testResultsContainer, DialogFactory dialogFactory) {
        this.fDialogFactory = dialogFactory;
        DetailTableModel detailTableModel = new DetailTableModel(testResultsContainer);
        this.fMainTable = new DetailTable(detailTableModel, dialogFactory);
        this.fMainTable.setRowHeight(24);
        final TestResultData[] testResultDataArray = testResultsContainer.getTestResults(new TestResultDataFilter(){

            @Override
            public boolean include(TestResultData testResultData) {
                return testResultData.getTestCategory() == TestCategory.CLIENT_TEST;
            }
        });
        ResultsComposite resultsComposite = new ResultsComposite();
        resultsComposite.addResults(testResultDataArray);
        MJLabel mJLabel = new MJLabel();
        String string = ResourceStatics.sRes.getString("results.clientResults." + (Object)((Object)resultsComposite.getCompositeReturnStatus()));
        String string2 = resultsComposite.getCompositeReturnStatus() == ReturnStatus.SUCCESS ? string : String.format(ResourceStatics.sRes.getString("results.summary.clientResults"), string.toLowerCase());
        mJLabel.setText(string2);
        mJLabel.setIcon(resultsComposite.getStatusIcon());
        MJButton mJButton = new MJButton();
        mJButton.setText(ResourceStatics.sRes.getString("results.summary.clientResults.info"));
        mJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogReport logReport = new LogReport(testResultDataArray);
                DetailReport.this.fDialogFactory.showDialog((Component)((Object)logReport), ResourceStatics.sRes.getString("results.clientsonlyinfo.title"));
            }
        });
        MJLabel mJLabel2 = new MJLabel(ResourceStatics.sRes.getString("results.summary.clientResults.label"));
        MJLabel mJLabel3 = new MJLabel(ResourceStatics.sRes.getString("results.summary.clusterResults.label"));
        MJScrollPane mJScrollPane = new MJScrollPane((Component)((Object)this.fMainTable));
        StyleGuideRelatedPanel styleGuideRelatedPanel = new StyleGuideRelatedPanel();
        styleGuideRelatedPanel.addLine((JComponent)mJScrollPane, 8);
        StyleGuideRelatedPanel styleGuideRelatedPanel2 = new StyleGuideRelatedPanel();
        styleGuideRelatedPanel2.addLine((JComponent[][])new JComponent[][]{{mJLabel, mJButton, null}}, 0, 2);
        this.addLine((JComponent)mJLabel2);
        this.addLine((JComponent)((Object)styleGuideRelatedPanel2));
        this.addLine((JComponent)mJLabel3);
        this.addLine((JComponent)((Object)styleGuideRelatedPanel), 8);
        mJButton.setName("TestConnectivityDialog.ClientInfoButton");
        mJLabel.setName("TestConnectivityDialog.ClientTestLabel");
    }

    void setTestResults(TestResultsContainer testResultsContainer) {
        this.fMainTable.setModel(new DetailTableModel(testResultsContainer));
    }
}

