/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.testing.infra.test;

import com.mathworks.toolbox.distcomp.admincenter.testing.infra.Node;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.dependency.Dependency;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.dependency.DependencyList;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.PackageInfo;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.Result;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.RunIdentifier;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.RunnableTest;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.SkippedResult;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.SuccessResult;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.TestCommandAdaptor;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.TestCompletionObserver;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.TestInfo;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.util.NotResolvedException;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.util.UnresolvableDependencyException;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.util.UnsetAttributeException;
import com.mathworks.toolbox.distcomp.admincenter.testing.shared.TestCategory;
import com.mathworks.toolbox.distcomp.admincenter.testing.shared.TestingCallback;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import java.util.Date;
import java.util.concurrent.Future;
import java.util.logging.Level;

public abstract class Test<TResult extends Result>
implements TestCompletionObserver<TResult> {
    private DependencyList fDependencyList = null;
    private RunIdentifier fRunID = null;
    private TestInfo fTestInfo = null;
    private TestingCallback fTestingCallback = null;
    private Future fFuture = null;
    private Integer fRunnableTimeout = null;

    public Test(Node node, Node node2, TestCategory testCategory) {
        assert (node != null) : "attempt to set a null node";
        assert (node2 != null) : "attempt to set a null node";
        assert (testCategory != null) : "attempt to set a null category";
        this.create(node, node2, testCategory);
        this.fTestInfo.setPending();
    }

    public Test() {
        this.create(null, null, null);
        this.fTestInfo.setResult(new SuccessResult());
        this.fTestInfo.setFinished();
    }

    public abstract String getDescription();

    public abstract RunnableTest<TResult> createRunnableTest() throws UnsetAttributeException;

    public String getExecutingHostname() {
        return this.fTestInfo.getExecutingNode().getHostname();
    }

    public Future getFuture() {
        return this.fFuture;
    }

    public void setFuture(Future future) {
        this.fFuture = future;
    }

    public void setRunID(RunIdentifier runIdentifier) {
        this.fRunID = runIdentifier;
    }

    public Integer getRunnableTimeout() {
        return this.fRunnableTimeout;
    }

    public void setRunnableTimeout(Integer n) {
        this.fRunnableTimeout = n;
    }

    public TestCategory getTestCategory() {
        return this.fTestInfo.getTestCategory();
    }

    protected TestInfo getTestInfo() {
        return this.fTestInfo;
    }

    public void setTestingCallback(TestingCallback testingCallback) {
        this.fTestingCallback = testingCallback;
    }

    public boolean isLoopbackTest() {
        return this.fTestInfo.getExecutingNode().getHostname().equals(this.fTestInfo.getReceivingNode().getHostname());
    }

    public boolean isSuccessful() {
        Result result = this.fTestInfo.getResult();
        return result == null ? false : result.isSuccessful();
    }

    public boolean isPending() {
        return this.fTestInfo.isPending();
    }

    public boolean isRunning() {
        return this.fTestInfo.isRunning();
    }

    public boolean isFinished() {
        return this.fTestInfo.isFinished();
    }

    public void addDependency(Dependency dependency) {
        if (dependency.getSource() == this) {
            throw new UnresolvableDependencyException("Recursive dependency found. How do you imagine this should work, hm?");
        }
        this.fDependencyList.addDependency(dependency);
    }

    public boolean isReadyToRun() {
        if (!this.fDependencyList.allDependenciesResolved()) {
            return false;
        }
        try {
            this.fDependencyList.updateTestWithDependencies(this);
            this.log(DistcompLevel.FOUR, "updated " + this);
        }
        catch (NotResolvedException notResolvedException) {
            String string = "updateTestWithDependencies caused an error because one of the tests did not produce correct output but still claims to have succeeded.";
            this.log(DistcompLevel.ONE, string + " Exception: " + notResolvedException);
            throw new UnresolvableDependencyException(string, notResolvedException);
        }
        return true;
    }

    public void sendAndRun() {
        this.fTestInfo.setDescription(this.getDescription());
        if (!this.isPending()) {
            this.log(DistcompLevel.FOUR, "marked as finished (thus skipping it): " + this);
            return;
        }
        RunnableTest<TResult> runnableTest = null;
        try {
            runnableTest = this.createRunnableTest();
        }
        catch (UnsetAttributeException unsetAttributeException) {
            String string = "createRunnableTest caused an error because a test had invalid (probably null) input attributes although all dependencies seem to be resolved.";
            this.log(DistcompLevel.ONE, string + " Exception: " + unsetAttributeException);
            throw new UnresolvableDependencyException(string, unsetAttributeException);
        }
        runnableTest.setDescription(this.getDescription());
        runnableTest.setRunID(this.fRunID);
        runnableTest.setTestCategory(this.fTestInfo.getTestCategory());
        if (this.getRunnableTimeout() != null) {
            runnableTest.setTimeout(this.getRunnableTimeout().intValue());
        }
        runnableTest.setCommandSet(this.fTestInfo.getExecutingNode().getCommandSet());
        TestCommandAdaptor<TResult> testCommandAdaptor = new TestCommandAdaptor<TResult>(this.fTestInfo.getExecutingNode(), runnableTest);
        this.log(DistcompLevel.FOUR, "starting " + this);
        this.initializeTest();
        Result result = testCommandAdaptor.call(this);
        this.finalizeTest(result);
    }

    public void skip(String string) {
        if (this.fTestInfo.getResult() != null) {
            return;
        }
        this.log(DistcompLevel.FOUR, "skipping (reason: " + string + ") " + this);
        this.initializeTest();
        SkippedResult skippedResult = new SkippedResult(string);
        this.finalizeTest(skippedResult);
    }

    private void create(Node node, Node node2, TestCategory testCategory) {
        this.fDependencyList = new DependencyList();
        this.fTestInfo = new TestInfo(node, node2, testCategory);
        this.fTestInfo.setDescription(this.getDescription());
    }

    private void initializeTest() {
        this.fTestInfo.setRunning();
        this.fTestInfo.setStartTime(new Date());
    }

    private void finalizeTest(Result result) {
        assert (this.fTestingCallback != null) : "the testing callback function has not been set.";
        this.fTestInfo.setResult(result);
        this.fTestInfo.setStopTime(new Date());
        this.fTestInfo.setFinished();
        try {
            this.log(DistcompLevel.TWO, "GUI callback: " + this.fTestInfo.toString());
            this.fTestingCallback.consumeTestResult(this.fTestInfo);
        }
        catch (Throwable throwable) {
            this.log(DistcompLevel.ONE, "The GUI threw an error while consuming a test result: " + throwable);
            for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                this.log(DistcompLevel.ONE, stackTraceElement.toString());
            }
        }
    }

    protected IllegalArgumentException getIllegalArgumentException(Test test, String string) {
        String string2 = "Illegal input argument in a" + test.getClass().getName() + ".set() method";
        return new IllegalArgumentException(string2, new Exception(string));
    }

    protected void log(Level level, String string) {
        PackageInfo.LOGGER.log(level, "Test: " + string);
    }

    public String toString() {
        return this.fTestInfo.toString();
    }
}

