/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.testing.infra.test;

import com.mathworks.toolbox.distcomp.admincenter.testing.shared.ReturnStatus;
import com.mathworks.toolbox.distcomp.control.MDCSCommandResults;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Vector;

public abstract class Result
implements MDCSCommandResults {
    private Exception fFailure = null;
    private Vector<String> fInfo;
    private String fReason = null;
    private ReturnStatus fStatus = null;
    private Vector<String> fWarning = new Vector();

    public Result() {
        this.fInfo = new Vector();
    }

    ReturnStatus getReturnStatus() {
        return this.fStatus;
    }

    boolean isSuccessful() {
        return this.fStatus == ReturnStatus.SUCCESS || this.fStatus == ReturnStatus.INFO || this.fStatus == ReturnStatus.WARNING;
    }

    boolean isSkipped() {
        return this.fStatus == ReturnStatus.SKIPPED;
    }

    void setSuccess() {
        this.setReturnStatus(ReturnStatus.SUCCESS);
    }

    void addInfo(String string) {
        this.fInfo.addElement(string);
        this.setReturnStatus(ReturnStatus.INFO);
    }

    Collection<String> getInfos() {
        return this.fInfo;
    }

    void addWarning(String string) {
        this.fWarning.addElement(string);
        this.setReturnStatus(ReturnStatus.WARNING);
    }

    Collection<String> getWarnings() {
        return this.fWarning;
    }

    void setFailure(Exception exception) {
        this.fFailure = exception;
        this.setReturnStatus(ReturnStatus.ERROR);
    }

    Exception getException() {
        return this.fFailure;
    }

    void setSkipped(String string) {
        this.fReason = string;
        this.setReturnStatus(ReturnStatus.SKIPPED);
    }

    private void setReturnStatus(ReturnStatus returnStatus) {
        if (this.fStatus == null || returnStatus.ordinal() > this.fStatus.ordinal()) {
            this.fStatus = returnStatus;
        }
    }

    public String toString() {
        switch (this.fStatus) {
            case INFO: {
                try {
                    return this.fInfo.lastElement();
                }
                catch (NoSuchElementException noSuchElementException) {
                    return "";
                }
            }
            case WARNING: {
                try {
                    return this.fWarning.lastElement();
                }
                catch (NoSuchElementException noSuchElementException) {
                    return "";
                }
            }
            case ERROR: {
                String string = this.fFailure.toString();
                Throwable throwable = this.fFailure.getCause();
                if (throwable != null) {
                    string = string + " Cause: " + throwable.toString().replaceAll("\n", " ");
                }
                return string;
            }
            case SKIPPED: {
                return this.fReason;
            }
        }
        return "";
    }
}

