/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.testing.infra.test;

import com.mathworks.toolbox.distcomp.admincenter.TimeOutConstants;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.ResolveIPToHostnameResult;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.RunnableTest;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.util.TestFailureException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;

class ResolveIPToHostname
extends RunnableTest<ResolveIPToHostnameResult> {
    private Collection<InetAddress> fAddressList = null;
    private String fCanonicalHostname = null;
    private String fHostname = null;

    public ResolveIPToHostname(Collection<InetAddress> collection, String string, String string2) {
        super(TimeOutConstants.RESOLVE_IP_TO_HOSTNAME_TIMEOUT_MILLIS);
        this.fAddressList = collection;
        this.fCanonicalHostname = string;
        this.fHostname = string2;
    }

    @Override
    protected ResolveIPToHostnameResult createResult() {
        return new ResolveIPToHostnameResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run() {
        ResolveIPToHostnameResult resolveIPToHostnameResult = this.createResult();
        try {
            String string;
            try {
                string = this.getCommandSet().getHostName(this.fHostname);
                if (!string.equalsIgnoreCase(this.fHostname)) {
                    resolveIPToHostnameResult.addWarning("Input hostname '" + this.fHostname + "' resolves locally " + "to different hostname '" + string + "'.");
                }
            }
            catch (UnknownHostException unknownHostException) {
                throw new TestFailureException("The current machine cannot resolve the hostname '" + this.fHostname + "'.");
            }
            string = this.fCanonicalHostname.toLowerCase();
            String string2 = this.fHostname.toLowerCase();
            if (!string.equals(string2) && string.indexOf(string2) != 0) {
                resolveIPToHostnameResult.addInfo("Hostname (" + string2 + ") and " + "canonical hostname (" + string + ") do not match.");
            }
            InetAddress inetAddress = InetAddress.getByName(this.fHostname);
            boolean bl = false;
            for (InetAddress inetAddress2 : this.fAddressList) {
                if (!inetAddress.equals(inetAddress2)) continue;
                bl = true;
            }
            if (!bl) {
                throw new TestFailureException("No address in list " + this.fAddressList + " matched " + this.fHostname + "'s address " + inetAddress + ".");
            }
            resolveIPToHostnameResult.setSuccess();
        }
        catch (Exception exception) {
            resolveIPToHostnameResult.setFailure(exception);
        }
        finally {
            this.setResult(resolveIPToHostnameResult);
        }
    }
}

