/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.testing.infra.test;

import com.mathworks.toolbox.distcomp.admincenter.TimeOutConstants;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.CleanableTest;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.OpenServerSocketResult;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.RunnableTest;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.util.CleanupFailureException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

class OpenServerSocket
extends RunnableTest<OpenServerSocketResult>
implements CleanableTest {
    static final String END_OF_TRANSMISSION = "/eot";
    private static final int PORT_RANGE = 50;
    private Integer fPort = null;
    private transient Thread fAcceptConnectionThread = null;
    private transient ServerSocket fServerSocket = null;
    private AtomicBoolean fShouldShutdown = null;
    private static AtomicInteger fSocketHandlerCounter = new AtomicInteger(0);

    public OpenServerSocket(Integer n) {
        super(TimeOutConstants.OPEN_SERVERSOCKET_TIMEOUT_MILLIS);
        this.fPort = n;
    }

    @Override
    protected OpenServerSocketResult createResult() {
        return new OpenServerSocketResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void run() {
        this.log("Started the run of the OpenServerSocketTest");
        OpenServerSocketResult openServerSocketResult = this.createResult();
        this.fShouldShutdown = new AtomicBoolean(false);
        try {
            long l = System.currentTimeMillis();
            this.fServerSocket = this.createServerSocketFindPort(this.fPort, 50);
            long l2 = System.currentTimeMillis() - l;
            this.log("It took " + l2 + " milliseconds to create a server socket on port " + this.fServerSocket.getLocalPort());
            int n = this.fServerSocket.getLocalPort();
            if (!this.fPort.equals(n)) {
                openServerSocketResult.addInfo("Opened server socket on port " + n + ".");
                this.log("Opened server socket on port " + n + " instead of port " + this.fPort + ".");
            }
            this.fPort = n;
            openServerSocketResult.setPort(this.fPort);
            this.fAcceptConnectionThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    OpenServerSocket.this.acceptConnections();
                }
            });
            this.fAcceptConnectionThread.start();
            long l3 = System.currentTimeMillis();
            try {
                if (this.fAcceptConnectionThread.isInterrupted()) {
                    this.log("The accept connection has been interrupted before calling join.");
                }
                this.fAcceptConnectionThread.join(TimeOutConstants.OPEN_SERVERSOCKET_RUN_THREAD_WAIT_MILLIS);
            }
            catch (InterruptedException interruptedException) {
                l2 = System.currentTimeMillis() - l3;
                this.warn("Accept Connection thread has been interrupted after " + l2 + " milliseconds due to ", interruptedException);
            }
            if (!this.fAcceptConnectionThread.isAlive()) {
                openServerSocketResult.addWarning("The ServerSocket does not seem to be alive.");
                this.log("The ServerSocket does not seem to be alive.");
            }
            if (this.fServerSocket.isClosed() || !this.isAccepting()) {
                openServerSocketResult.addWarning("The ServerSocket does not seem to accept connections even from loopback.");
                this.log("The ServerSocket does not seem to accept connections even from loopback.");
            }
            this.getCommandSet().addTestToCleanupManager(this, this.getRunID());
            openServerSocketResult.setSuccess();
        }
        catch (Exception exception) {
            this.warn("Run method threw an exception", exception);
            try {
                this.cleanup();
            }
            catch (CleanupFailureException cleanupFailureException) {
                this.warn("Cleanup in run method threw an exception", cleanupFailureException);
            }
            openServerSocketResult.setFailure(exception);
        }
        finally {
            this.setResult(openServerSocketResult);
        }
    }

    @Override
    public void cleanup() throws CleanupFailureException {
        this.log("In cleanup method of OpenServerSocketTest");
        this.fShouldShutdown.set(true);
        if (this.fAcceptConnectionThread != null) {
            try {
                if (this.fAcceptConnectionThread.isInterrupted()) {
                    this.log("The accept connection thread has been interrupted in the cleanup before join.");
                }
                this.fAcceptConnectionThread.join(TimeOutConstants.OPEN_SERVERSOCKET_CLEANUP_THREAD_WAIT_MILLIS);
            }
            catch (InterruptedException interruptedException) {
                this.log("The accept connection thread has been interrupted in the cleanup.");
            }
            if (this.fAcceptConnectionThread.isAlive()) {
                this.log("In cleanup and interrupting the accept connection thread");
                this.fAcceptConnectionThread.interrupt();
            }
        }
        if (this.fServerSocket != null && !this.fServerSocket.isClosed()) {
            this.log("retry ... closing ServerSocket.");
            try {
                this.fServerSocket.close();
            }
            catch (IOException iOException) {
                String string = "Failed to clean up " + this + " because " + iOException.getMessage();
                throw new CleanupFailureException(string, iOException);
            }
        }
    }

    private ServerSocket createServerSocketFindPort(int n, int n2) throws IOException {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            try {
                return this.createServerSocket(i);
            }
            catch (IOException iOException) {
                continue;
            }
        }
        String string = "Could not bind to any port between " + n + " and " + (n3 - 1) + ". Most likely a firewall is blocking " + "these ports, or they are in use by other applications.";
        throw new IOException(string);
    }

    private ServerSocket createServerSocket(int n) throws IOException {
        try {
            ServerSocket serverSocket = this.getCommandSet().createServerSocket(n);
            this.log("created ServerSocket on port " + n + ".");
            return serverSocket;
        }
        catch (IOException iOException) {
            String string = "Could not bind to port " + n + ". " + "Another application may be using this port.";
            IOException iOException2 = new IOException(string);
            iOException2.initCause(iOException);
            throw iOException2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acceptConnections() {
        try {
            this.fServerSocket.setSoTimeout(TimeOutConstants.OPEN_SERVERSOCKET_SERVERSOCKET_TIMEOUT_MILLIS);
            while (!this.fShouldShutdown.get()) {
                try {
                    long l = System.currentTimeMillis();
                    this.log("Waiting for accepting a connection in acceptConnectionThread");
                    Socket socket = this.fServerSocket.accept();
                    long l2 = System.currentTimeMillis() - l;
                    this.log("Done accepting a connection after " + l2 + " milliseconds in acceptConnectionThread.");
                    try {
                        SocketHandler socketHandler = new SocketHandler(socket);
                        socketHandler.setName("SocketHandlerThread" + fSocketHandlerCounter.getAndIncrement());
                        socketHandler.start();
                    }
                    catch (IOException iOException) {
                        try {
                            if (socket != null) {
                                socket.close();
                            }
                        }
                        catch (IOException iOException2) {
                            this.warn("IOException: unable to close Socket.", iOException2);
                        }
                        throw iOException;
                    }
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    this.log("The server socket has reached it's timeout in accept connection thread");
                }
            }
        }
        catch (SocketException socketException) {
            this.warn("SocketException: ", socketException);
        }
        catch (IOException iOException) {
            this.warn("IOException: ", iOException);
        }
        finally {
            try {
                this.fServerSocket.close();
                this.log("The accept connection thread has closed the server socket.");
            }
            catch (IOException iOException) {
                this.warn("IOException: unable to close ServerSocket.", iOException);
            }
        }
    }

    private boolean isAccepting() {
        try {
            InetAddress inetAddress = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
            Socket socket = new Socket(inetAddress, (int)this.fPort);
            socket.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private class SocketHandler
    extends Thread {
        private Socket fSocket = null;
        private BufferedReader fIn = null;
        private PrintWriter fOut = null;

        public SocketHandler(Socket socket) throws IOException {
            this.fSocket = socket;
            try {
                this.fSocket.setSoTimeout(TimeOutConstants.OPEN_SERVERSOCKET_CLIENTSOCKET_TIMEOUT_MILLIS);
                this.fIn = new BufferedReader(new InputStreamReader(this.fSocket.getInputStream()));
                this.fOut = new PrintWriter(new OutputStreamWriter(this.fSocket.getOutputStream()));
            }
            catch (IOException iOException) {
                this.closeAll();
                throw iOException;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean bl = false;
            try {
                while (!bl && !OpenServerSocket.this.fShouldShutdown.get()) {
                    String string;
                    try {
                        string = this.fIn.readLine();
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                        continue;
                    }
                    if (string == null) {
                        throw new IOException(this.getName() + " :Received null message.");
                    }
                    if (string.equalsIgnoreCase(OpenServerSocket.END_OF_TRANSMISSION)) {
                        bl = true;
                        continue;
                    }
                    OpenServerSocket.this.log(this.getName() + " :received string '" + string + "'");
                    this.sendMessage(this.fOut, string);
                }
            }
            catch (Exception exception) {
                if (this.isValidOutputSocket(this.fSocket)) {
                    this.sendMessage(this.fOut, "OpenServerSocketTest threw an exception:  " + exception.toString());
                }
                OpenServerSocket.this.warn("Exception: ", exception);
            }
            finally {
                this.closeAll();
            }
        }

        private void closeAll() {
            try {
                this.fIn.close();
            }
            catch (IOException iOException) {
                OpenServerSocket.this.warn(this.getName() + " :unable to close input stream.", iOException);
            }
            this.fOut.close();
            try {
                this.fSocket.close();
            }
            catch (IOException iOException) {
                OpenServerSocket.this.warn(this.getName() + " :unable to close socket.", iOException);
            }
            OpenServerSocket.this.log("Close all completed in the SocketHandler");
        }

        private void sendMessage(PrintWriter printWriter, String string) {
            printWriter.println(string);
            printWriter.flush();
            OpenServerSocket.this.log(this.getName() + " :sending message '" + string + "' back.");
        }

        private boolean isValidOutputSocket(Socket socket) {
            return socket != null && !socket.isOutputShutdown();
        }
    }
}

