/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.testing.infra.test;

import com.mathworks.toolbox.distcomp.admincenter.TimeOutConstants;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.CheckServicesResult;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.RunnableTest;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.util.TestFailureException;
import com.mathworks.toolbox.distcomp.control.StatusResults;

class CheckServices
extends RunnableTest<CheckServicesResult> {
    private String fHostname = null;
    private Integer fPort = null;

    public CheckServices(String string, Integer n) {
        super(TimeOutConstants.CHECK_SERVICES_TIMEOUT_MILLIS);
        this.fHostname = string;
        this.fPort = n;
    }

    @Override
    protected CheckServicesResult createResult() {
        return new CheckServicesResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run() {
        CheckServicesResult checkServicesResult = this.createResult();
        try {
            int n;
            StatusResults statusResults = this.getCommandSet().getStatusResults(this.fHostname, this.fPort);
            if (statusResults == null) {
                throw new TestFailureException("Could not get status of our service on port " + this.fPort + ". Most likely some other application is using the port.");
            }
            try {
                n = statusResults.getJobManagerNodeInfo().length;
                checkServicesResult.addInfo(n + " jobmanager" + (n != 1 ? "s" : "") + " found.");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                n = statusResults.getWorkerNodeInfo().length;
                checkServicesResult.addInfo(n + " worker" + (n != 1 ? "s" : "") + " found.");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            checkServicesResult.setSuccess();
        }
        catch (Exception exception) {
            checkServicesResult.setFailure(exception);
        }
        finally {
            this.setResult(checkServicesResult);
        }
    }
}

