/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.testing.infra.internal;

import com.mathworks.toolbox.distcomp.admincenter.testing.infra.internal.CommandSet;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.internal.CustomCommand;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.internal.SystemCommandSet;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.CleanableTest;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.RunIdentifier;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.util.CleanupFailureException;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.util.LockingException;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.util.ParsingException;
import com.mathworks.toolbox.distcomp.admincenter.testing.shared.TestCategory;
import com.mathworks.toolbox.distcomp.control.StatusResults;
import com.mathworks.toolbox.distcomp.control.serviceinfo.MDCSServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.ServiceInfo;
import com.mathworks.toolbox.distcomp.control.servicerequest.Host;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerNodeInfo;
import com.mathworks.toolbox.distcomp.worker.WorkerNodeInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public class CustomCommandSet
implements CommandSet,
Serializable {
    private static final String ERROR_MESSAGE = "CustomCommandSet";
    private Vector<CustomCommand> fCommands = new Vector();
    private SystemCommandSet fSystem = new SystemCommandSet();

    public CustomCommandSet(Vector<CustomCommand> vector) {
        this.fCommands = vector;
    }

    @Override
    public String getHostName(String string) throws UnknownHostException {
        CustomCommand customCommand = new CustomCommand("getHostName");
        customCommand.setHostname(string);
        String string2 = this.getResult(customCommand);
        if (string2 == null) {
            return this.fSystem.getHostName(string);
        }
        this.handleUnknownHostException(string2);
        return this.handleString(string2);
    }

    @Override
    public String getCanonicalHostName(String string) throws UnknownHostException {
        CustomCommand customCommand = new CustomCommand("getCanonicalHostName");
        customCommand.setHostname(string);
        String string2 = this.getResult(customCommand);
        if (string2 == null) {
            return this.fSystem.getCanonicalHostName(string);
        }
        this.handleUnknownHostException(string2);
        return this.handleString(string2);
    }

    @Override
    public String getHostAddress(String string) throws UnknownHostException {
        CustomCommand customCommand = new CustomCommand("getHostAddress");
        customCommand.setHostname(string);
        String string2 = this.getResult(customCommand);
        if (string2 == null) {
            return this.fSystem.getHostAddress(string);
        }
        this.handleUnknownHostException(string2);
        return this.handleString(string2);
    }

    @Override
    public Boolean isReachable(String string, int n) throws IOException {
        CustomCommand customCommand = new CustomCommand("isReachable");
        customCommand.setHostname(string);
        String string2 = this.getResult(customCommand);
        if (string2 == null) {
            return this.fSystem.isReachable(string, n);
        }
        this.handleIOException(string2);
        return this.handleBoolean(string2);
    }

    @Override
    public String getLocalHostName() throws UnknownHostException {
        CustomCommand customCommand = new CustomCommand("getLocalHostName");
        String string = this.getResult(customCommand);
        if (string == null) {
            return this.fSystem.getLocalHostName();
        }
        this.handleUnknownHostException(string);
        return this.handleString(string);
    }

    @Override
    public Set<InetAddress> getAddressList() throws SocketException {
        CustomCommand customCommand = new CustomCommand("getAddressList");
        String string = this.getResult(customCommand);
        if (string == null) {
            return this.fSystem.getAddressList();
        }
        this.handleSocketException(string);
        return this.handleSetInetAddress(string);
    }

    @Override
    public Set<InetAddress> getAddressList(String string) throws UnknownHostException {
        CustomCommand customCommand = new CustomCommand("getAddressList");
        customCommand.setHostname(string);
        String string2 = this.getResult(customCommand);
        if (string2 == null) {
            return this.fSystem.getAddressList(string);
        }
        this.handleUnknownHostException(string2);
        return this.handleSetInetAddress(string2);
    }

    @Override
    public Boolean isLoopbackAddress(String string) throws UnknownHostException {
        CustomCommand customCommand = new CustomCommand("isLoopbackAddress");
        customCommand.setHostname(string);
        String string2 = this.getResult(customCommand);
        if (string2 == null) {
            return this.fSystem.isLoopbackAddress(string);
        }
        this.handleUnknownHostException(string2);
        return this.handleBoolean(string2);
    }

    @Override
    public Socket createSocket(String string, int n) throws IOException {
        CustomCommand customCommand = new CustomCommand("createSocket");
        customCommand.setHostname(string);
        customCommand.setPort(n);
        String string2 = this.getResult(customCommand);
        if (string2 == null) {
            return this.fSystem.createSocket(string, n);
        }
        this.handleIOException(string2);
        throw new ParsingException("Invalid result string: " + string2);
    }

    @Override
    public ServerSocket createServerSocket(int n) throws IOException {
        CustomCommand customCommand = new CustomCommand("createServerSocket");
        customCommand.setPort(n);
        String string = this.getResult(customCommand);
        if (string == null) {
            return this.fSystem.createServerSocket(n);
        }
        this.handleIOException(string);
        throw new ParsingException("Invalid result string: " + string);
    }

    @Override
    public String readLine(BufferedReader bufferedReader) throws IOException {
        CustomCommand customCommand = new CustomCommand("readLine");
        String string = this.getResult(customCommand);
        if (string == null) {
            return this.fSystem.readLine(bufferedReader);
        }
        this.handleIOException(string);
        return this.handleString(string);
    }

    @Override
    public void lockDownForTesting(RunIdentifier runIdentifier) throws LockingException {
        CustomCommand customCommand = new CustomCommand("lockDownForTesting");
        String string = this.getResult(customCommand);
        if (string == null) {
            this.fSystem.lockDownForTesting(runIdentifier);
            return;
        }
        this.handleLockingException(string);
        throw new ParsingException("Invalid result string: " + string);
    }

    @Override
    public void releaseLockDownForTesting(RunIdentifier runIdentifier) throws LockingException {
        CustomCommand customCommand = new CustomCommand("releaseLockDownForTesting");
        String string = this.getResult(customCommand);
        if (string == null) {
            this.fSystem.releaseLockDownForTesting(runIdentifier);
            return;
        }
        this.handleLockingException(string);
        throw new ParsingException("Invalid result string: " + string);
    }

    @Override
    public void addTestToCleanupManager(CleanableTest cleanableTest, RunIdentifier runIdentifier) throws LockingException {
        CustomCommand customCommand = new CustomCommand("addTestToCleanupManager");
        String string = this.getResult(customCommand);
        if (string == null) {
            this.fSystem.addTestToCleanupManager(cleanableTest, runIdentifier);
            return;
        }
        this.handleLockingException(string);
        throw new ParsingException("Invalid result string: " + string);
    }

    @Override
    public void cleanupTests(TestCategory testCategory, RunIdentifier runIdentifier) throws CleanupFailureException, LockingException {
        CustomCommand customCommand = new CustomCommand("cleanupTests");
        customCommand.setTestCategory(testCategory);
        String string = this.getResult(customCommand);
        if (string == null) {
            this.fSystem.cleanupTests(testCategory, runIdentifier);
            return;
        }
        this.handleCleanupFailureException(string);
        this.handleLockingException(string);
        throw new ParsingException("Invalid result string: " + string);
    }

    @Override
    public StatusResults getStatusResults(String string, int n) {
        CustomCommand customCommand = new CustomCommand("getStatusResults");
        customCommand.setHostname(string);
        customCommand.setPort(n);
        String string2 = this.getResult(customCommand);
        if (string2 == null) {
            return this.fSystem.getStatusResults(string, n);
        }
        if (this.resultStringIsNull(string2)) {
            return null;
        }
        String[] stringArray = string2.split(" ", 3);
        int n2 = stringArray.length > 0 ? Integer.parseInt(stringArray[0]) : 0;
        int n3 = stringArray.length > 1 ? Integer.parseInt(stringArray[1]) : 0;
        JobManagerNodeInfo[] jobManagerNodeInfoArray = new JobManagerNodeInfo[n2];
        WorkerNodeInfo[] workerNodeInfoArray = new WorkerNodeInfo[n3];
        return (StatusResults)StatusResults.create(jobManagerNodeInfoArray, workerNodeInfoArray, MDCSServiceInfo.createStoppedInfo(new Host("localhost", "localhost")), new Vector<ServiceInfo>(), 0);
    }

    @Override
    public String getServerHostname() {
        CustomCommand customCommand = new CustomCommand("getServerHostname");
        String string = this.getResult(customCommand);
        if (string == null) {
            return this.fSystem.getServerHostname();
        }
        return this.handleString(string);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("custom commands:\n");
        for (CustomCommand customCommand : this.fCommands) {
            stringBuilder.append("  " + customCommand.toString() + "\n");
        }
        return stringBuilder.toString();
    }

    private String getResult(CustomCommand customCommand) {
        for (CustomCommand customCommand2 : this.fCommands) {
            if (!customCommand2.containsArguments(customCommand)) continue;
            return customCommand2.getResult();
        }
        return null;
    }

    private String handleString(String string) {
        return this.resultStringIsNull(string) ? null : string;
    }

    private Boolean handleBoolean(String string) {
        return Boolean.parseBoolean(string);
    }

    private Set<InetAddress> handleSetInetAddress(String string) {
        HashSet<InetAddress> hashSet = new HashSet<InetAddress>();
        for (String string2 : string.split(" ")) {
            try {
                hashSet.add(InetAddress.getByName(string2));
            }
            catch (UnknownHostException unknownHostException) {
                throw new ParsingException("The IP address " + string2 + " is not valid.");
            }
        }
        return hashSet;
    }

    private void handleCleanupFailureException(String string) throws CleanupFailureException {
        if (string.indexOf("throw CleanupFailureException") == 0) {
            throw new CleanupFailureException(ERROR_MESSAGE);
        }
    }

    private void handleLockingException(String string) throws LockingException {
        if (string.indexOf("throw LockingException") == 0) {
            throw new LockingException(ERROR_MESSAGE);
        }
    }

    private void handleIOException(String string) throws IOException {
        if (string.indexOf("throw IOException") == 0) {
            throw new IOException(ERROR_MESSAGE);
        }
    }

    private void handleSocketException(String string) throws SocketException {
        if (string.indexOf("throw SocketException") == 0) {
            throw new SocketException(ERROR_MESSAGE);
        }
    }

    private void handleUnknownHostException(String string) throws UnknownHostException {
        if (string.indexOf("throw UnknownHostException") == 0) {
            throw new UnknownHostException(ERROR_MESSAGE);
        }
    }

    private boolean resultStringIsNull(String string) {
        return string.indexOf("null") == 0;
    }
}

