/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.testing.infra.dependency;

import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.Test;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.util.NotResolvedException;

public abstract class Dependency {
    private Test fSource;

    public Dependency(Test test) {
        this.fSource = test;
    }

    public Test getSource() {
        return this.fSource;
    }

    void updateTest(Test test) throws NotResolvedException {
        if (!this.canResolve()) {
            String string = "Attempt to update " + test.getDescription() + " failed.";
            Exception exception = new Exception("The dependency on " + this.getSource().getDescription() + " was not resolved.");
            throw new NotResolvedException(string, exception);
        }
    }

    abstract boolean canResolve();

    protected final boolean isSourceTestSuccessful() {
        return this.getSource().isSuccessful();
    }
}

