/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.services.view;

import com.jidesoft.comparator.ComparatorContext;
import com.jidesoft.comparator.ObjectComparatorManager;
import com.jidesoft.grid.NestedTableHeader;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.SortableTableModel;
import com.jidesoft.grid.TableColumnGroup;
import com.mathworks.toolbox.distcomp.admincenter.services.model.Hostname;
import com.mathworks.toolbox.distcomp.admincenter.services.model.ServiceTableModel;
import com.mathworks.toolbox.distcomp.admincenter.services.model.StatusModel;
import com.mathworks.toolbox.distcomp.admincenter.services.model.StringList;
import com.mathworks.toolbox.distcomp.admincenter.services.view.HostnameRenderer;
import com.mathworks.toolbox.distcomp.admincenter.services.view.StatusRenderer;
import com.mathworks.toolbox.distcomp.admincenter.services.view.TableTooltipUtil;
import com.mathworks.toolbox.distcomp.control.serviceinfo.ServiceInfo;
import com.mathworks.toolbox.distcomp.util.ResourceBundleUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.TimeZone;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

class ServiceInfoTable<SM extends ServiceTableModel<?, ?>>
extends SortableTable {
    private final SM fServiceTableModel;
    private List<ServiceInfo> fSelectedInfo = new ArrayList<ServiceInfo>();
    private boolean fSelectionAdjusting = false;
    private int fLastTTRow = -1;
    private int fLastTTCol = -1;
    private static final int HORIZ_CELL_MARGIN = 2;
    private static final ResourceBundleUtilities sRes = ResourceBundleUtilities.getInstance(ServiceInfoTable.class);
    private final TableCellRenderer fBlankRenderer;
    private final Map<Class<?>, TableCellRenderer> fOverrideRenderers = new HashMap();
    private static final String UNAVAILABLE_BLANK = "<html>&#8212;</html>";

    ServiceInfoTable(SM SM) {
        super(SM);
        this.fServiceTableModel = SM;
        this.setMultiColumnSortable(false);
        this.setClearSelectionOnTableDataChanges(false);
        this.setPreserveSelectionsAfterSorting(false);
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel(){

            @Override
            protected void fireValueChanged(int n, int n2, boolean bl) {
                if (!bl && !ServiceInfoTable.this.fSelectionAdjusting) {
                    ServiceInfoTable.this.refreshSelectedInfo();
                }
                super.fireValueChanged(n, n2, bl);
            }
        };
        this.setSelectionModel(defaultListSelectionModel);
        this.initColumnGroups();
        this.setOverrideCellRenderer(Date.class, new ISO8601DateRenderer());
        this.setOverrideCellRenderer(StatusModel.class, new StatusRenderer());
        this.setOverrideCellRenderer(Hostname.class, new HostnameRenderer());
        TableColumnModel tableColumnModel = this.getColumnModel();
        this.setIntercellSpacing(new Dimension(2, 0));
        LeftAlignedHeaderRenderer leftAlignedHeaderRenderer = new LeftAlignedHeaderRenderer();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            TableCellRenderer tableCellRenderer = this.getCellRenderer(0, i);
            if (tableCellRenderer instanceof JLabel) {
                ((JLabel)((Object)tableCellRenderer)).setHorizontalAlignment(2);
            }
            tableColumnModel.getColumn(i).setHeaderRenderer(leftAlignedHeaderRenderer);
        }
        this.fBlankRenderer = new DefaultTableCellRenderer();
        ((JComponent)((Object)this.fBlankRenderer)).setToolTipText(sRes.getString("ServiceInfoTable.unavailable.tt", new Object[0]));
        ObjectComparatorManager.registerComparator(Integer.class, new TableValueComparator<Integer>(Integer.class));
        ObjectComparatorManager.registerComparator(StringList.class, new TableValueComparator<StringList>(StringList.class));
        ObjectComparatorManager.registerComparator(StatusModel.class, new TableValueComparator<StatusModel>(StatusModel.class));
        ObjectComparatorManager.registerComparator(Date.class, new TableValueComparator<Date>(Date.class));
        ObjectComparatorManager.registerComparator(String.class, new TableValueComparator<String>(String.class));
        SortableTableModel sortableTableModel = (SortableTableModel)this.getModel();
        sortableTableModel.setColumnComparatorContextProvider(new SortableTableModel.ColumnComparatorContextProvider(){

            public ComparatorContext getColumnComparatorContext(SortableTableModel sortableTableModel, int n) {
                return ComparatorContext.DEFAULT_CONTEXT;
            }
        });
    }

    public void addNotify() {
        super.addNotify();
        this.initColumnWidths();
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        TableCellRenderer tableCellRenderer = this.getOverrideCellRenderer(this.getColumnClass(n2));
        if (tableCellRenderer != null) {
            return tableCellRenderer;
        }
        return super.getCellRenderer(n, n2);
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public void setOverrideCellRenderer(Class<?> clazz, TableCellRenderer tableCellRenderer) {
        assert (clazz != null && !Object.class.equals(clazz)) : "colClass must be non-null and not be the Object class.";
        this.fOverrideRenderers.put(clazz, tableCellRenderer);
    }

    public List<ServiceInfo> getSelectedInfo() {
        return Collections.unmodifiableList(this.fSelectedInfo);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        super.tableChanged(tableModelEvent);
        this.resetSelections();
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        return TableTooltipUtil.getTooltip((JTable)((Object)this), mouseEvent);
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        Point point = super.getToolTipLocation(mouseEvent);
        int n = this.rowAtPoint(mouseEvent.getPoint());
        int n2 = this.columnAtPoint(mouseEvent.getPoint());
        if (n == this.fLastTTRow && n2 == this.fLastTTCol) {
            return point;
        }
        this.fLastTTRow = n;
        this.fLastTTCol = n2;
        return new Point(mouseEvent.getX(), mouseEvent.getY() + 20);
    }

    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Object object = this.getValueAt(n, n2);
        if (((ServiceTableModel)this.fServiceTableModel).isValueUnavailable(object)) {
            boolean bl = this.isCellSelected(n, n2);
            boolean bl2 = this.selectionModel.getLeadSelectionIndex() == n;
            boolean bl3 = this.columnModel.getSelectionModel().getLeadSelectionIndex() == n2;
            boolean bl4 = bl2 && bl3 && this.isFocusOwner();
            return this.fBlankRenderer.getTableCellRendererComponent((JTable)((Object)this), UNAVAILABLE_BLANK, bl, bl4, n, n2);
        }
        return super.prepareRenderer(tableCellRenderer, n, n2);
    }

    private TableCellRenderer getOverrideCellRenderer(Class<?> clazz) {
        for (Class<?> clazz2 = clazz; clazz2 != null && !Object.class.equals(clazz2); clazz2 = clazz2.getSuperclass()) {
            TableCellRenderer tableCellRenderer = this.fOverrideRenderers.get(clazz2);
            if (tableCellRenderer == null) continue;
            return tableCellRenderer;
        }
        return null;
    }

    private void initColumnGroups() {
        this.setNestedTableHeader(true);
        HashMap<Object, TableColumnGroup> hashMap = new HashMap<Object, TableColumnGroup>();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            String string = ((ServiceTableModel)this.fServiceTableModel).getColumnGroup(i);
            if (string == null) continue;
            TableColumnGroup tableColumnGroup = (TableColumnGroup)hashMap.get(string);
            if (tableColumnGroup == null) {
                tableColumnGroup = new TableColumnGroup(string);
                hashMap.put(string, tableColumnGroup);
                tableColumnGroup.setHeaderRenderer((TableCellRenderer)new CentertAlignedHeaderRenderer());
            }
            tableColumnGroup.add((Object)this.getColumnModel().getColumn(i));
        }
        if (this.getTableHeader() instanceof NestedTableHeader) {
            NestedTableHeader nestedTableHeader = (NestedTableHeader)this.getTableHeader();
            for (TableColumnGroup tableColumnGroup : hashMap.values()) {
                nestedTableHeader.addColumnGroup(tableColumnGroup);
            }
        }
    }

    private void initColumnWidths() {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            String string;
            TableColumn tableColumn = this.getColumnModel().getColumn(i);
            Class clazz = ((ServiceTableModel)this.fServiceTableModel).getColumnEnum();
            String string2 = clazz.getSimpleName() + "." + clazz.getEnumConstants()[i] + ".";
            try {
                string = sRes.getString(string2 + "preferred", new Object[0]);
                tableColumn.setPreferredWidth(this.getStringWidth(string));
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            try {
                string = sRes.getString(string2 + "minimum", new Object[0]);
                tableColumn.setMinWidth(this.getStringWidth(string));
                continue;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
    }

    private int getStringWidth(String string) {
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        assert (graphics2D != null) : "Must be called after add.";
        return (int)this.getFont().getStringBounds(string, graphics2D.getFontRenderContext()).getWidth();
    }

    private void refreshSelectedInfo() {
        int[] nArray = this.getSelectedRows();
        ArrayList<ServiceInfo> arrayList = new ArrayList<ServiceInfo>();
        for (int n : nArray) {
            if (n < 0 || n >= this.getRowCount()) continue;
            arrayList.add((ServiceInfo)((ServiceTableModel)this.fServiceTableModel).getServiceInfoAt(this.getActualRowAt(n)));
        }
        this.fSelectedInfo = arrayList;
    }

    private void resetSelections() {
        if (this.fServiceTableModel == null || this.fSelectedInfo == null) {
            return;
        }
        this.fSelectionAdjusting = true;
        this.clearSelection();
        for (int i = 0; i < this.getRowCount(); ++i) {
            int n = this.getActualRowAt(i);
            Object SI = ((ServiceTableModel)this.fServiceTableModel).getServiceInfoAt(n);
            if (!this.fSelectedInfo.contains(SI)) continue;
            this.getSelectionModel().addSelectionInterval(i, i);
            int n2 = this.fSelectedInfo.indexOf(SI);
            this.fSelectedInfo.set(n2, (ServiceInfo)SI);
        }
        this.fSelectionAdjusting = false;
    }

    private static class TableValueComparator<T extends Comparable<T>>
    implements Comparator<Object> {
        private final Class<T> fValueClass;

        TableValueComparator(Class<T> clazz) {
            assert (clazz != null) : "valueClass must not be null.";
            this.fValueClass = clazz;
        }

        @Override
        public int compare(Object object, Object object2) {
            Comparable comparable = null;
            if (object != null && this.fValueClass.isAssignableFrom(object.getClass())) {
                comparable = (Comparable)this.fValueClass.cast(object);
            }
            Comparable comparable2 = null;
            if (object2 != null && this.fValueClass.isAssignableFrom(object2.getClass())) {
                comparable2 = (Comparable)this.fValueClass.cast(object2);
            }
            if (comparable == null) {
                return comparable2 == null ? 0 : -1;
            }
            if (comparable2 == null) {
                return 1;
            }
            return comparable.compareTo(comparable2);
        }
    }

    private static class CentertAlignedHeaderRenderer
    extends DefaultTableCellRenderer {
        CentertAlignedHeaderRenderer() {
            Border border;
            try {
                Border border2 = UIManager.getBorder("TableHeader.cellBorder");
                border = (Border)border2.getClass().newInstance();
            }
            catch (Exception exception) {
                border = UIManager.getBorder("TableHeader.cellBorder");
            }
            this.setBorder(new CompoundBorder(border, new EmptyBorder(0, 2, 0, 2)));
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JTableHeader jTableHeader;
            if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
                this.setForeground(jTableHeader.getForeground());
                this.setBackground(jTableHeader.getBackground());
                this.setFont(jTableHeader.getFont());
            }
            this.setText(object == null ? "" : object.toString());
            return this;
        }
    }

    private class LeftAlignedHeaderRenderer
    extends DefaultTableCellRenderer {
        LeftAlignedHeaderRenderer() {
            Border border;
            try {
                Border border2 = UIManager.getBorder("TableHeader.cellBorder");
                border = (Border)border2.getClass().newInstance();
            }
            catch (Exception exception) {
                border = UIManager.getBorder("TableHeader.cellBorder");
            }
            this.setBorder(new CompoundBorder(border, new EmptyBorder(0, 2, 0, 2)));
            this.setHorizontalAlignment(2);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JTableHeader jTableHeader;
            if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
                this.setForeground(jTableHeader.getForeground());
                this.setBackground(jTableHeader.getBackground());
                this.setFont(jTableHeader.getFont());
            }
            this.setText(object == null ? "" : object.toString());
            if (jTable != null) {
                this.setToolTipText(ServiceInfoTable.this.fServiceTableModel.getColumnTooltip(jTable.convertColumnIndexToModel(n2)));
            }
            return this;
        }
    }

    private static class ISO8601DateRenderer
    extends DefaultTableCellRenderer {
        private static final SimpleDateFormat DISPLAY_FMT = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        private static final MessageFormat TOOLTIP_FMT = new MessageFormat("{0,time} {1,number,+00;-00}:{2,number,00}");
        private static final SimpleDateFormat TIME_FMT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        private ISO8601DateRenderer() {
        }

        @Override
        protected void setValue(Object object) {
            String string = null;
            String string2 = null;
            if (object != null && object instanceof Date) {
                Date date = (Date)object;
                int n = TimeZone.getDefault().getOffset(date.getTime());
                int n2 = n / 60000;
                int n3 = n2 / 60;
                int n4 = Math.abs(n2 % 60);
                string = DISPLAY_FMT.format(date);
                string2 = TOOLTIP_FMT.format(new Object[]{date.getTime(), n3, n4});
            }
            super.setValue(string);
            this.setToolTipText(string2);
        }

        static {
            TOOLTIP_FMT.setFormat(0, TIME_FMT);
        }
    }
}

