/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.services.view;

import com.jidesoft.field.IPTextField;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTextArea;
import com.mathworks.toolbox.distcomp.admincenter.services.view.ServiceDialog;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuideEmptyPanel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuidePanel;
import com.mathworks.toolbox.distcomp.util.ResourceBundleUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

class AddHostsDialog
extends ServiceDialog<String[]> {
    private static final String HELP = "AC_ADD_HOSTS";
    private static final ResourceBundleUtilities sRes = ResourceBundleUtilities.getInstance(AddHostsDialog.class);

    AddHostsDialog(Frame frame) {
        super(frame, sRes.getString("services.dialog.addHosts", new Object[0]), sRes.getString("services.dialog.okay", new Object[0]), HELP, new AddHostsContent());
    }

    public boolean shouldLaunchStartMdceServiceWizard() {
        return ((AddHostsContent)this.getServiceDialogContent()).shouldLaunchStartMdceServiceWizard();
    }

    private static class AddHostsContent
    extends StyleGuidePanel
    implements ServiceDialog.FocusableServiceDialogContent<String[]> {
        private final MJRadioButton fByHostnameRadioButton = new MJRadioButton(AddHostsDialog.access$100().getString("services.dialog.addHosts.byHostname", new Object[0]));
        private final MJRadioButton fByIPRadioButton;
        private final MJTextArea fHostnameArea;
        private MJButton fOkayButton;
        private final JCheckBox fStartMdceServiceCheckbox;
        private static final String COMP_NAME_HOST_RADIO = "hostRadio";
        private static final String COMP_NAME_IP_RADIO = "ipRadio";
        private static final String COMP_NAME_HOST_TEXT = "hostText";
        private static final String[] NULL_REPLY = new String[0];
        private IPTextField fStartIPTextField;
        private IPTextField fEndIPTextField;

        private AddHostsContent() {
            this.fByHostnameRadioButton.setSelected(true);
            this.fByIPRadioButton = new MJRadioButton(sRes.getString("services.dialog.addHosts.byIP", new Object[0]));
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AddHostsContent.this.validateComponents();
                }
            };
            this.fByHostnameRadioButton.addActionListener(actionListener);
            this.fByIPRadioButton.addActionListener(actionListener);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add((AbstractButton)this.fByHostnameRadioButton);
            buttonGroup.add((AbstractButton)this.fByIPRadioButton);
            this.fHostnameArea = new MJTextArea(10, 20){

                public Dimension getPreferredScrollableViewportSize() {
                    return this.getPreferredSize();
                }
            };
            this.fHostnameArea.setDocument((Document)new PlainDocument(){

                @Override
                public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                    super.insertString(n, this.filter(string), attributeSet);
                    AddHostsContent.this.validateOkayButton();
                }

                @Override
                public void remove(int n, int n2) throws BadLocationException {
                    super.remove(n, n2);
                    AddHostsContent.this.validateOkayButton();
                }

                private String filter(String string) {
                    return string.replaceAll("[,;\\s]+", "\n");
                }
            });
            MJScrollPane mJScrollPane = new MJScrollPane((Component)this.fHostnameArea);
            StyleGuidePanel styleGuidePanel = new StyleGuidePanel(){

                @Override
                protected int getTopInset() {
                    return 0;
                }

                @Override
                protected int getLeftInset() {
                    return super.getLeftInset() * 2;
                }
            };
            styleGuidePanel.addLine((JComponent)mJScrollPane);
            StyleGuidePanel styleGuidePanel2 = new StyleGuidePanel(){

                @Override
                protected int getTopInset() {
                    return 0;
                }

                @Override
                protected int getLeftInset() {
                    return super.getLeftInset() * 2;
                }
            };
            this.fStartIPTextField = new IPTextField();
            this.fEndIPTextField = new IPTextField();
            final JTextField[] jTextFieldArray = this.fEndIPTextField.getTextFields();
            for (int i = 0; i <= 2; ++i) {
                jTextFieldArray[i].setEditable(false);
            }
            jTextFieldArray[3].getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    AddHostsContent.this.validateOkayButton();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    AddHostsContent.this.validateOkayButton();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    AddHostsContent.this.validateOkayButton();
                }
            });
            final JTextField[] jTextFieldArray2 = this.fStartIPTextField.getTextFields();
            for (int i = 0; i <= 2; ++i) {
                final int n = i;
                jTextFieldArray2[i].getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void insertUpdate(DocumentEvent documentEvent) {
                        AddHostsContent.this.validateOkayButton();
                        jTextFieldArray[n].setText(jTextFieldArray2[n].getText());
                    }

                    @Override
                    public void removeUpdate(DocumentEvent documentEvent) {
                        AddHostsContent.this.validateOkayButton();
                        jTextFieldArray[n].setText(jTextFieldArray2[n].getText());
                    }

                    @Override
                    public void changedUpdate(DocumentEvent documentEvent) {
                        AddHostsContent.this.validateOkayButton();
                        jTextFieldArray[n].setText(jTextFieldArray2[n].getText());
                    }
                });
            }
            styleGuidePanel2.addLine((JComponent[][])new JComponent[][]{{this.fStartIPTextField, new MJLabel(" to "), this.fEndIPTextField, new StyleGuideEmptyPanel()}}, 0, 3);
            MJLabel mJLabel = new MJLabel(sRes.getString("services.dialog.addHosts.note", new Object[0]));
            this.fStartMdceServiceCheckbox = new MJCheckBox(sRes.getString("services.dialog.addHosts.startmdceservicescheckbox", new Object[0]));
            this.fStartMdceServiceCheckbox.setSelected(true);
            this.addLine((JComponent)this.fByHostnameRadioButton);
            this.addLine((JComponent)((Object)styleGuidePanel), 8);
            this.addLine((JComponent)this.fByIPRadioButton);
            this.addLine((JComponent)((Object)styleGuidePanel2));
            this.addLine((JComponent)mJLabel);
            this.addLine(this.fStartMdceServiceCheckbox);
            this.fByHostnameRadioButton.setName(COMP_NAME_HOST_RADIO);
            this.fByIPRadioButton.setName(COMP_NAME_IP_RADIO);
            this.fHostnameArea.setName(COMP_NAME_HOST_TEXT);
            this.fStartMdceServiceCheckbox.setName("AddHostsDialog.StartMdceServicesCheckbox");
        }

        @Override
        public JComponent getComponent() {
            return this;
        }

        @Override
        public String[] getValue() {
            if (this.fByHostnameRadioButton.isSelected()) {
                return this.getUniqueListOfHostnames();
            }
            if (!this.fStartIPTextField.isValueValid() || !this.fEndIPTextField.isValueValid()) {
                return NULL_REPLY;
            }
            int[] nArray = this.fStartIPTextField.getValue();
            int[] nArray2 = this.fEndIPTextField.getValue();
            String string = nArray[0] + "." + nArray[1] + "." + nArray[2];
            int n = nArray[3];
            int n2 = nArray2[3];
            String[] stringArray = new String[n2 - n + 1];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = string + "." + (n + i);
            }
            return stringArray;
        }

        private String[] getUniqueListOfHostnames() {
            String[] stringArray;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (String string : stringArray = this.fHostnameArea.getText().split("\n")) {
                hashMap.put(string.toLowerCase(), string);
            }
            return hashMap.values().toArray(new String[hashMap.values().size()]);
        }

        @Override
        public void registerOkayButton(MJButton mJButton) {
            this.fOkayButton = mJButton;
            this.validateOkayButton();
        }

        public void addNotify() {
            super.addNotify();
            this.validateComponents();
        }

        public boolean shouldLaunchStartMdceServiceWizard() {
            return this.fStartMdceServiceCheckbox.isSelected();
        }

        private void validateComponents() {
            boolean bl = this.fByHostnameRadioButton.isSelected();
            this.fHostnameArea.setEnabled(bl);
            this.fStartIPTextField.setEnabled(!bl);
            this.fEndIPTextField.setEnabled(!bl);
            if (bl) {
                this.fHostnameArea.requestFocusInWindow();
            } else {
                this.fStartIPTextField.requestFocusInWindow();
            }
            this.validateOkayButton();
        }

        private void validateOkayButton() {
            if (this.fOkayButton == null) {
                return;
            }
            if (this.fByHostnameRadioButton.isSelected()) {
                this.fOkayButton.setEnabled(this.fHostnameArea.getText().trim().length() > 0);
            } else if (!this.fStartIPTextField.isValueValid() || !this.fEndIPTextField.isValueValid()) {
                this.fOkayButton.setEnabled(false);
            } else {
                int[] nArray;
                int n;
                int[] nArray2 = this.fStartIPTextField.getValue();
                int n2 = nArray2[3];
                this.fOkayButton.setEnabled(n2 <= (n = (nArray = this.fEndIPTextField.getValue())[3]));
            }
        }

        @Override
        public Component getFocusTarget() {
            return this.fHostnameArea;
        }
    }
}

