/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.services.model;

import com.mathworks.toolbox.distcomp.admincenter.services.model.ClientMonitor;
import com.mathworks.toolbox.distcomp.admincenter.services.model.PackageInfo;
import com.mathworks.toolbox.distcomp.admincenter.services.model.ServiceRequestException;
import com.mathworks.toolbox.distcomp.admincenter.services.model.UpdateProgressListener;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;

public class UpdateTimer {
    public static final int NEVER = 0;
    private final ClientMonitor fMonitor;
    private int fFreqSeconds = 0;
    private Timer fTimer;
    private Date fLastUpdated = null;
    private TimerTask fUpdateTask;
    private final PropertyChangeSupport fChangeSupport = new PropertyChangeSupport(this);
    private static final String FREQUENCY = "FREQUENCY";
    private final Integer[] fAvailableFreqSeconds;

    public UpdateTimer(ClientMonitor clientMonitor, Integer[] integerArray) {
        this.fMonitor = clientMonitor;
        this.fAvailableFreqSeconds = integerArray;
        this.fTimer = new Timer();
        this.fMonitor.addUpdateProgressListener(new UpdateProgressListener(){

            @Override
            public void updateStarted(boolean bl) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateFinished(boolean bl) {
                UpdateTimer updateTimer = UpdateTimer.this;
                synchronized (updateTimer) {
                    UpdateTimer.this.fLastUpdated = bl ? null : new Date();
                    UpdateTimer.this.scheduleUpdate();
                }
            }

            @Override
            public void updateFinishing() {
            }
        });
    }

    public synchronized int getFreqSeconds() {
        return this.fFreqSeconds;
    }

    public synchronized void setFreqSeconds(int n) {
        int n2;
        if (n == this.fFreqSeconds) {
            return;
        }
        if (n <= 0) {
            n = 0;
        } else if (this.fAvailableFreqSeconds != null && this.fAvailableFreqSeconds.length > 0) {
            n2 = Short.MAX_VALUE;
            Integer n3 = null;
            Integer[] integerArray = this.fAvailableFreqSeconds;
            int n4 = integerArray.length;
            for (int i = 0; i < n4; ++i) {
                int n5;
                int n6 = integerArray[i];
                if (n6 == 0 || (n5 = Math.abs(n6 - n)) >= n2) continue;
                n2 = n5;
                n3 = n6;
            }
            if (n3 != null) {
                n = n3;
            }
        }
        n2 = this.fFreqSeconds;
        this.fFreqSeconds = n;
        this.scheduleUpdate();
        this.fireFrequencyChange(n2, this.fFreqSeconds);
    }

    public synchronized void scheduleTask(final Runnable runnable) {
        if (!this.isScedulable()) {
            throw new IllegalStateException("Cannot schedule a task with a disposed UpdateTimer.");
        }
        this.fTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                runnable.run();
            }
        }, 0L);
    }

    public synchronized void dispose() {
        if (!this.isScedulable()) {
            return;
        }
        if (this.fUpdateTask != null) {
            this.fUpdateTask.cancel();
        }
        this.fTimer.cancel();
        this.fTimer = null;
    }

    public void addFrequencyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fChangeSupport.addPropertyChangeListener(FREQUENCY, propertyChangeListener);
    }

    public void removeFrequencyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fChangeSupport.removePropertyChangeListener(FREQUENCY, propertyChangeListener);
    }

    private void fireFrequencyChange(final int n, final int n2) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                UpdateTimer.this.fChangeSupport.firePropertyChange(UpdateTimer.FREQUENCY, n, n2);
            }
        };
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
        }
    }

    private synchronized boolean isScedulable() {
        return this.fTimer != null;
    }

    private synchronized void scheduleUpdate() {
        if (!this.isScedulable()) {
            return;
        }
        if (this.fUpdateTask != null) {
            this.fUpdateTask.cancel();
        }
        if (this.fFreqSeconds == 0) {
            return;
        }
        Date date = this.fLastUpdated == null ? new Date() : new Date(this.fLastUpdated.getTime() + (long)(1000 * this.fFreqSeconds));
        this.fUpdateTask = new TimerTask(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (!UpdateTimer.this.fMonitor.isUpdating()) {
                                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Starting a scheduled update...");
                                UpdateTimer.this.fMonitor.startUpdate(false);
                            }
                        }
                        catch (ServiceRequestException serviceRequestException) {
                            PackageInfo.LOGGER.log(DistcompLevel.THREE, "Problem updating", serviceRequestException);
                        }
                    }
                });
            }
        };
        this.fTimer.schedule(this.fUpdateTask, date);
    }
}

