/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.services.model;

import com.mathworks.toolbox.distcomp.admincenter.services.infra.JobRunner;
import com.mathworks.toolbox.distcomp.admincenter.services.model.WorkerStatus;
import com.mathworks.toolbox.distcomp.control.CommandListener;
import com.mathworks.toolbox.distcomp.control.serviceinfo.JobManagerServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.MDCSServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.ServiceStatus;
import com.mathworks.toolbox.distcomp.control.serviceinfo.WorkerConnectionStatus;
import com.mathworks.toolbox.distcomp.control.serviceinfo.WorkerServiceInfo;
import com.mathworks.toolbox.distcomp.util.FormattableException;
import com.mathworks.toolbox.distcomp.util.Ping;
import com.mathworks.toolbox.distcomp.util.ResourceBundleUtilities;
import com.mathworks.toolbox.distcomp.util.Version;
import java.net.UnknownHostException;

public class StatusModel
implements Comparable<StatusModel> {
    private final Level fLevel;
    private final ResourceBundleUtilities.ResourceBundleMessenger fStatusMessenger;
    private final ResourceBundleUtilities.ResourceBundleMessenger fTooltipMessenger;
    private static final ResourceBundleUtilities sRes = ResourceBundleUtilities.getInstance(StatusModel.class);

    private StatusModel(Level level, String string, String string2) {
        this(level, new StatusResourceMessenger(string, new Object[0]), new StatusResourceMessenger(string2, new Object[0]));
    }

    private StatusModel(Level level, ResourceBundleUtilities.ResourceBundleMessenger resourceBundleMessenger, ResourceBundleUtilities.ResourceBundleMessenger resourceBundleMessenger2) {
        assert (level != null && resourceBundleMessenger != null && resourceBundleMessenger2 != null) : "level and keys must be non-null.";
        this.fLevel = level;
        this.fStatusMessenger = resourceBundleMessenger;
        this.fTooltipMessenger = resourceBundleMessenger2;
    }

    public static StatusModel getJMServiceStatusModel(JobManagerServiceInfo jobManagerServiceInfo) {
        ServiceStatus serviceStatus = jobManagerServiceInfo.getStatus();
        Level level = serviceStatus == ServiceStatus.RUNNING ? Level.GOOD : Level.BAD;
        String string = "services.model.servicestatus." + (Object)((Object)serviceStatus);
        String string2 = "services.model.servicestatus.jm.tt." + (Object)((Object)serviceStatus);
        return new StatusModel(level, string, string2);
    }

    public static StatusModel getMDCSServiceStatusModel(MDCSServiceInfo mDCSServiceInfo) {
        StatusModel statusModel;
        ServiceStatus serviceStatus = mDCSServiceInfo.getStatus();
        Level level = serviceStatus == ServiceStatus.RUNNING ? Level.GOOD : Level.BAD;
        String string = "services.model.servicestatus." + (Object)((Object)serviceStatus);
        String string2 = "services.model.servicestatus.mdcs.tt." + (Object)((Object)serviceStatus);
        Throwable throwable = mDCSServiceInfo.getException();
        if (serviceStatus == ServiceStatus.UNKNOWN && throwable != null && throwable instanceof JobRunner.MDCSTimeoutException) {
            StatusResourceMessenger statusResourceMessenger = new StatusResourceMessenger("services.model.servicestatus.mdcs.tt.timedout", mDCSServiceInfo.getHostName());
            StatusResourceMessenger statusResourceMessenger2 = new StatusResourceMessenger(string, new Object[0]);
            statusModel = new StatusModel(level, statusResourceMessenger2, statusResourceMessenger);
        } else if (serviceStatus == ServiceStatus.UNSUPPORTED_VERSION) {
            StatusResourceMessenger statusResourceMessenger = new StatusResourceMessenger(string2, mDCSServiceInfo.getVersion(), Version.VERSION_STRING);
            StatusResourceMessenger statusResourceMessenger3 = new StatusResourceMessenger(string, new Object[0]);
            statusModel = new StatusModel(level, statusResourceMessenger3, statusResourceMessenger);
        } else {
            statusModel = new StatusModel(level, string, string2);
        }
        return statusModel;
    }

    public static StatusModel getWorkerConnectionStatusModel(WorkerServiceInfo workerServiceInfo) {
        WorkerConnectionStatus workerConnectionStatus = workerServiceInfo.getWorkerConnectionStatus();
        if (workerConnectionStatus == null) {
            return null;
        }
        Level level = workerConnectionStatus == WorkerConnectionStatus.CONNECTED ? Level.GOOD : Level.BAD;
        String string = "services.model.workerconnection." + (Object)((Object)workerConnectionStatus);
        String string2 = "services.model.workerconnection.tt." + (Object)((Object)workerConnectionStatus);
        return new StatusModel(level, string, string2);
    }

    public static StatusModel getWorkerStatusModel(WorkerServiceInfo workerServiceInfo) {
        WorkerStatus workerStatus = WorkerStatus.getWorkerStatus(workerServiceInfo);
        Level level = workerStatus == WorkerStatus.BUSY || workerStatus == WorkerStatus.IDLE ? Level.GOOD : Level.BAD;
        String string = "services.model.workerstatus." + (Object)((Object)workerStatus);
        String string2 = "services.model.workerstatus.tt." + (Object)((Object)workerStatus);
        return new StatusModel(level, string, string2);
    }

    public static StatusModel getHostReachableStatusModel(MDCSServiceInfo mDCSServiceInfo) {
        boolean bl = mDCSServiceInfo.isHostResolvable();
        Level level = bl ? Level.GOOD : Level.BAD;
        String string = "services.model.reachable." + bl;
        String string2 = "services.model.reachable.tt." + bl;
        if (!bl) {
            Throwable throwable = mDCSServiceInfo.getException();
            if (throwable instanceof UnknownHostException) {
                string = "services.model.reachable.resolvable";
                string2 = "services.model.reachable.tt.resolvable";
            } else if (throwable instanceof Ping.AddressUnreachableException) {
                string = "services.model.reachable.unreachable";
                string2 = "services.model.reachable.tt.unreachable";
            }
        }
        return new StatusModel(level, string, string2);
    }

    public Level getLevel() {
        return this.fLevel;
    }

    public String getText() {
        return sRes.getString(this.fStatusMessenger);
    }

    public String getToolTip() {
        return sRes.getString(this.fTooltipMessenger);
    }

    @Override
    public int compareTo(StatusModel statusModel) {
        int n = this.fLevel.compareTo(statusModel.fLevel);
        if (n == 0) {
            return this.getText().compareTo(statusModel.getText());
        }
        return n;
    }

    public String toString() {
        return this.getText();
    }

    private static Object getRemoteMessageParam(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        if (!(throwable instanceof FormattableException)) {
            return throwable.getMessage();
        }
        FormattableException formattableException = (FormattableException)throwable;
        if (CommandListener.ErrorKey.INVALID_CLASS_DETAIL == formattableException.getResourceKey()) {
            return new StatusResourceMessenger("INVALID_CLASS_DETAIL_expanded", formattableException.getParams()[0], Version.VERSION_STRING);
        }
        return throwable;
    }

    private static class StatusResourceMessenger
    implements ResourceBundleUtilities.ResourceBundleMessenger {
        private final Object fKey;
        private final Object[] fParams;

        public StatusResourceMessenger(Object object, Object ... objectArray) {
            assert (object != null) : "key must be non-null.";
            this.fKey = object;
            this.fParams = objectArray;
        }

        @Override
        public Object getResourceKey() {
            return this.fKey;
        }

        @Override
        public Object[] getParams() {
            return this.fParams;
        }

        @Override
        public String getDefaultMessage() {
            return null;
        }
    }

    public static enum Level {
        BAD,
        WARNING,
        GOOD,
        DISABLED;

    }
}

