/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.services.model;

import com.mathworks.toolbox.distcomp.admincenter.services.model.ServiceTableModelColumn;
import com.mathworks.toolbox.distcomp.admincenter.services.model.StatusModel;
import com.mathworks.toolbox.distcomp.control.serviceinfo.ServiceInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public abstract class ServiceTableModel<SI extends ServiceInfo, C extends ServiceTableModelColumn<C>>
extends AbstractTableModel {
    private final HashMap<ServiceInfoHashKey, SI> fInfoMap = new HashMap();
    private final Class<C> fColumnEnum = this.initColumnEnum();
    private static final Object UNAVAILABLE = new Object();

    public ServiceTableModel() {
        assert (this.fColumnEnum.isEnum()) : "getColumnEnum implementation must return an Enum class.";
    }

    public void updateInfo(List<SI> list) {
        this.fInfoMap.clear();
        for (ServiceInfo serviceInfo : list) {
            this.fInfoMap.put(new ServiceInfoHashKey(serviceInfo), serviceInfo);
        }
        this.fireTableDataChanged();
    }

    public SI getServiceInfoAt(int n) {
        ServiceInfoHashKey serviceInfoHashKey = this.fInfoMap.keySet().toArray(new ServiceInfoHashKey[0])[n];
        return (SI)((ServiceInfo)this.fInfoMap.get(serviceInfoHashKey));
    }

    public boolean isValueUnavailable(Object object) {
        return UNAVAILABLE == object;
    }

    @Override
    public int getRowCount() {
        return this.fInfoMap.size();
    }

    @Override
    public int getColumnCount() {
        return ((ServiceTableModelColumn[])this.getColumnEnum().getEnumConstants()).length;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        SI SI = this.getServiceInfoAt(n);
        ServiceTableModelColumn serviceTableModelColumn = ((ServiceTableModelColumn[])this.getColumnEnum().getEnumConstants())[n2];
        Object object = this.getValue(SI, serviceTableModelColumn);
        Object c = serviceTableModelColumn.getMajorStatusColumn();
        if (c != null && c != serviceTableModelColumn) {
            boolean bl;
            boolean bl2 = bl = ((StatusModel)this.getValue(SI, c)).getLevel() == StatusModel.Level.GOOD;
            if (!bl) {
                boolean bl3;
                boolean bl4 = bl3 = object == null || object instanceof Integer && (Integer)object == 0 || "".equals(object.toString());
                if (bl3) {
                    return UNAVAILABLE;
                }
            }
        }
        return object;
    }

    public Class getColumnClass(int n) {
        return ((ServiceTableModelColumn[])this.getColumnEnum().getEnumConstants())[n].getColumnClass();
    }

    @Override
    public String getColumnName(int n) {
        return ((ServiceTableModelColumn[])this.getColumnEnum().getEnumConstants())[n].getColumnName();
    }

    public String getColumnGroup(int n) {
        return ((ServiceTableModelColumn[])this.getColumnEnum().getEnumConstants())[n].getGroup();
    }

    public String getColumnTooltip(int n) {
        return ((ServiceTableModelColumn[])this.getColumnEnum().getEnumConstants())[n].getTooltip();
    }

    public List<SI> getInfoList() {
        return new ArrayList<SI>(this.fInfoMap.values());
    }

    public Class<C> getColumnEnum() {
        return this.fColumnEnum;
    }

    protected abstract Class<C> initColumnEnum();

    protected abstract Object getValue(SI var1, C var2);

    private static class ServiceInfoHashKey {
        private static final Object NULL_TOKEN = new Object();
        private final Object fHostname;
        private final Object fServiceName;

        public ServiceInfoHashKey(ServiceInfo serviceInfo) {
            assert (serviceInfo != null) : "service info may not be null.";
            assert (serviceInfo.getHostName() != null) : "Hostname may not be null.";
            this.fHostname = serviceInfo.getHostName();
            this.fServiceName = serviceInfo.getServiceName() != null ? serviceInfo.getServiceName() : NULL_TOKEN;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof ServiceInfoHashKey)) {
                return false;
            }
            ServiceInfoHashKey serviceInfoHashKey = (ServiceInfoHashKey)object;
            return this.fHostname.equals(serviceInfoHashKey.fHostname) && this.fServiceName.equals(serviceInfoHashKey.fServiceName);
        }

        public int hashCode() {
            return this.fHostname.hashCode() + this.fServiceName.hashCode();
        }
    }
}

