/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.services.model;

import com.mathworks.toolbox.distcomp.admincenter.services.model.JobManagerDetailProperty;
import com.mathworks.toolbox.distcomp.admincenter.services.model.ServiceDetailModel;
import com.mathworks.toolbox.distcomp.admincenter.services.model.StatusModel;
import com.mathworks.toolbox.distcomp.control.serviceinfo.JobManagerServiceInfo;

public class JobManagerDetailModel
extends ServiceDetailModel<JobManagerServiceInfo> {
    protected JobManagerDetailModel() {
        super(JobManagerDetailProperty.class);
    }

    @Override
    public Object getValue(JobManagerServiceInfo jobManagerServiceInfo, ServiceDetailModel.Property<JobManagerServiceInfo> property) {
        switch ((JobManagerDetailProperty)property) {
            case HOST: {
                return this.getBestHostname(jobManagerServiceInfo);
            }
            case NAME: {
                return jobManagerServiceInfo.getServiceName();
            }
            case STATUS: {
                return StatusModel.getJMServiceStatusModel(jobManagerServiceInfo);
            }
        }
        switch (jobManagerServiceInfo.getStatus()) {
            case RUNNING: {
                switch ((JobManagerDetailProperty)property) {
                    case DATABASE_SIZE: {
                        return jobManagerServiceInfo.getDatabaseSize();
                    }
                    case NUMBER_WORKERS: {
                        return jobManagerServiceInfo.getWorkerNames().size();
                    }
                    case PORT: {
                        return jobManagerServiceInfo.getPort();
                    }
                    case LOOKUP_URLS_IN_CONFIG: {
                        return this.getLookupURLsInConfiguration(jobManagerServiceInfo);
                    }
                    case LOOKUP_URLS: {
                        return jobManagerServiceInfo.getLookupURLs();
                    }
                    case START_TIME: {
                        return jobManagerServiceInfo.getStartTime();
                    }
                    case VM_HEAP_SIZE: {
                        return jobManagerServiceInfo.getVMHeapSize();
                    }
                    case WORKER_LEASE_TIMEOUT: {
                        return jobManagerServiceInfo.getWorkerLeaseTimeout();
                    }
                    case WORKER_NAMES: {
                        return jobManagerServiceInfo.getWorkerNames();
                    }
                }
                return null;
            }
            case STOPPED: 
            case UNKNOWN: {
                return null;
            }
        }
        return null;
    }
}

