/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.services.model;

import com.mathworks.toolbox.distcomp.admincenter.services.model.HostDetailProperty;
import com.mathworks.toolbox.distcomp.admincenter.services.model.ServiceDetailModel;
import com.mathworks.toolbox.distcomp.admincenter.services.model.StatusModel;
import com.mathworks.toolbox.distcomp.control.serviceinfo.MDCSServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.NoValidMDCSHostnameException;

public class HostDetailModel
extends ServiceDetailModel<MDCSServiceInfo> {
    protected HostDetailModel() {
        super(HostDetailProperty.class);
    }

    @Override
    public Object getValue(MDCSServiceInfo mDCSServiceInfo, ServiceDetailModel.Property<MDCSServiceInfo> property) {
        if (mDCSServiceInfo == null) {
            return null;
        }
        switch ((HostDetailProperty)property) {
            case HOSTNAME: {
                return mDCSServiceInfo.getHostName();
            }
            case STATUS: {
                return StatusModel.getMDCSServiceStatusModel(mDCSServiceInfo);
            }
        }
        switch (mDCSServiceInfo.getStatus()) {
            case RUNNING: {
                switch ((HostDetailProperty)property) {
                    case ADDRESSES: {
                        return mDCSServiceInfo.getHostAddresses();
                    }
                    case JOB_MANAGERS: {
                        return mDCSServiceInfo.getJobManagerNames();
                    }
                    case MDCS_HOSTNAME: {
                        try {
                            return mDCSServiceInfo.getMDCSHostName();
                        }
                        catch (NoValidMDCSHostnameException noValidMDCSHostnameException) {
                            return null;
                        }
                    }
                    case NUMBER_JM: {
                        return mDCSServiceInfo.getJobManagerNames().size();
                    }
                    case NUMBER_LOOKUP: {
                        return mDCSServiceInfo.getHasLookup() != false ? 1 : 0;
                    }
                    case NUMBER_WORKERS: {
                        return mDCSServiceInfo.getWorkerNames().size();
                    }
                    case WORKERS: {
                        return mDCSServiceInfo.getWorkerNames();
                    }
                    case SECURITY_LEVEL: {
                        return mDCSServiceInfo.getSecurityLevel();
                    }
                    case MATLABROOT: {
                        return mDCSServiceInfo.getMatlabRoot();
                    }
                    case PLATFORM: {
                        return mDCSServiceInfo.getSystemArchitecture().toString();
                    }
                    case MDCE_DEFFILE: {
                        return mDCSServiceInfo.getMdceDefFile();
                    }
                    case VERSION: {
                        return mDCSServiceInfo.getVersion();
                    }
                }
                return null;
            }
            case UNSUPPORTED_VERSION: {
                switch ((HostDetailProperty)property) {
                    case VERSION: {
                        return mDCSServiceInfo.getVersion();
                    }
                }
                return null;
            }
            case STOPPED: 
            case UNKNOWN: {
                return null;
            }
        }
        return null;
    }
}

