/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.services.infra;

import com.mathworks.toolbox.distcomp.admincenter.TimeOutConstants;
import com.mathworks.toolbox.distcomp.admincenter.services.infra.Closure;
import com.mathworks.toolbox.distcomp.admincenter.services.infra.InvalidRequestException;
import com.mathworks.toolbox.distcomp.admincenter.services.infra.JobRunner;
import com.mathworks.toolbox.distcomp.admincenter.services.infra.ServiceUpdate;
import com.mathworks.toolbox.distcomp.admincenter.services.infra.ServiceUpdateObserver;
import com.mathworks.toolbox.distcomp.control.ControlSender;
import com.mathworks.toolbox.distcomp.control.MDCSParameter;
import com.mathworks.toolbox.distcomp.control.PortConfig;
import com.mathworks.toolbox.distcomp.control.servicerequest.ControlServiceRequest;
import com.mathworks.toolbox.distcomp.control.servicerequest.Host;
import com.mathworks.toolbox.distcomp.control.servicerequest.JobManagerServiceRequest;
import com.mathworks.toolbox.distcomp.control.servicerequest.LookupServiceRequest;
import com.mathworks.toolbox.distcomp.control.servicerequest.Request;
import com.mathworks.toolbox.distcomp.control.servicerequest.RequestResponse;
import com.mathworks.toolbox.distcomp.control.servicerequest.ServiceAction;
import com.mathworks.toolbox.distcomp.control.servicerequest.ServiceRequest;
import com.mathworks.toolbox.distcomp.control.servicerequest.ServiceRequestResponse;
import com.mathworks.toolbox.distcomp.util.Ping;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class ServiceManager {
    private static final String CONN_LIMIT_VARNAME = "ADMINCENTER_CONNECTION_LIMIT";
    private int fBasePort;
    private List<ClosureUpdateRequest> fClosureUpdateRequests;
    private ExecutorService fExecutor;
    private int fRemoteCommandPort;
    private AtomicBoolean fRunning;

    public ServiceManager(int n) {
        this.fBasePort = n;
        this.fClosureUpdateRequests = new LinkedList<ClosureUpdateRequest>();
        this.fExecutor = ServiceManager.createExecutor();
        this.fRemoteCommandPort = PortConfig.getRemoteCommandPort(Integer.toString(n));
        this.fRunning = new AtomicBoolean(false);
    }

    private static ExecutorService createExecutor() {
        int n = Ping.getNumberOfMaximumConcurrentRequests();
        String string = System.getenv(CONN_LIMIT_VARNAME);
        if (string != null) {
            try {
                n = Math.max(1, Integer.valueOf(string));
                System.out.println("Limiting concurrent connections to " + n);
            }
            catch (Exception exception) {
                System.out.println("Warning: the environment variable ADMINCENTER_CONNECTION_LIMIT must contain\na positive integer (found '" + string + "').");
            }
        }
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(n, n, TimeOutConstants.SERVICE_MANAGER_THREAD_KEEP_ALIVE_MILLIS, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        return threadPoolExecutor;
    }

    public ServiceManager() {
        this(27350);
    }

    public void dispose() {
        this.fExecutor.shutdownNow();
    }

    public int getBasePort() {
        return this.fBasePort;
    }

    public Collection<ServiceRequestResponse> submitRequests(Collection<ServiceRequest> collection) {
        LinkedList<ServiceRequestResponse> linkedList = new LinkedList<ServiceRequestResponse>();
        linkedList.addAll(ServiceManager.performSanityChecks(collection));
        LinkedList<ServiceRequest> linkedList2 = new LinkedList<ServiceRequest>();
        LinkedList<ServiceRequest> linkedList3 = new LinkedList<ServiceRequest>();
        ServiceManager.addLookupRequestsIfNeeded(collection, linkedList2, linkedList3);
        this.addRemoteCommandPortIfNeeded(linkedList2);
        this.addRemoteCommandPortIfNeeded(collection);
        this.addRemoteCommandPortIfNeeded(linkedList3);
        linkedList.addAll(this.runRequests(linkedList2));
        linkedList.addAll(this.runRequests(collection));
        linkedList.addAll(this.runRequests(linkedList3));
        return linkedList;
    }

    private void addRemoteCommandPortIfNeeded(Collection<ServiceRequest> collection) {
        for (ServiceRequest serviceRequest : collection) {
            if (!(serviceRequest instanceof ControlServiceRequest)) continue;
            serviceRequest.addParameterValue(MDCSParameter.REMOTE_COMMAND_PORT, this.fRemoteCommandPort);
        }
    }

    private static Collection<ServiceRequestResponse> performSanityChecks(Collection<ServiceRequest> collection) {
        LinkedList<ServiceRequestResponse> linkedList = new LinkedList<ServiceRequestResponse>();
        HashMap<Host, ServiceAction> hashMap = new HashMap<Host, ServiceAction>();
        Iterator<ServiceRequest> iterator = collection.iterator();
        while (iterator.hasNext()) {
            ServiceRequest serviceRequest = iterator.next();
            Host host = serviceRequest.getHost();
            ServiceAction serviceAction = serviceRequest.getAction();
            if (hashMap.containsKey(host)) {
                if (hashMap.get(host) == serviceAction) continue;
                InvalidRequestException invalidRequestException = new InvalidRequestException("Only one type of service action allowed per submission (got " + (Object)((Object)serviceAction) + " and " + hashMap.get(host) + ")");
                linkedList.add(serviceRequest.failedToExecute(invalidRequestException));
                iterator.remove();
                continue;
            }
            hashMap.put(host, serviceAction);
        }
        return linkedList;
    }

    private static void addLookupRequestsIfNeeded(Collection<ServiceRequest> collection, List<ServiceRequest> list, List<ServiceRequest> list2) {
        HashMap<Host, LookupServiceRequest> hashMap = new HashMap<Host, LookupServiceRequest>();
        for (ServiceRequest serviceRequest : collection) {
            Host host = serviceRequest.getHost();
            if (!(serviceRequest instanceof JobManagerServiceRequest) || hashMap.containsKey(host)) continue;
            hashMap.put(host, new LookupServiceRequest(serviceRequest));
        }
        for (ServiceRequest serviceRequest : hashMap.values()) {
            if (serviceRequest.getAction() == ServiceAction.STOP || serviceRequest.getAction() == ServiceAction.DESTROY) {
                list2.add(serviceRequest);
                continue;
            }
            list.add(serviceRequest);
        }
    }

    private <R extends RequestResponse> Collection<R> runRequests(Collection<? extends Request<R>> collection) {
        JobRunner<R> jobRunner = new JobRunner<R>(this.fExecutor);
        for (Request<R> request : collection) {
            jobRunner.addNewTask(request, request.failedToExecute(null));
        }
        try {
            jobRunner.waitForCompletion(TimeOutConstants.SERVICE_MANAGER_TASK_TIMEOUT_SECS);
        }
        catch (JobRunner.MDCSTimeoutException mDCSTimeoutException) {
            jobRunner.cancelAllTasks(mDCSTimeoutException);
        }
        return jobRunner.getResults();
    }

    public synchronized Date requestUpdate(Collection<Host> collection, ServiceUpdateObserver serviceUpdateObserver) {
        ClosureUpdateRequest closureUpdateRequest = new ClosureUpdateRequest(collection, serviceUpdateObserver);
        this.fClosureUpdateRequests.add(closureUpdateRequest);
        this.initiateNextComputation();
        return closureUpdateRequest.getStartTime();
    }

    private void initiateNextComputation() {
        if (this.fClosureUpdateRequests.isEmpty()) {
            return;
        }
        if (!this.fRunning.compareAndSet(false, true)) {
            return;
        }
        ClosureUpdateRequest closureUpdateRequest = this.fClosureUpdateRequests.get(0);
        for (ClosureUpdateRequest closureUpdateRequest2 : this.fClosureUpdateRequests) {
            if (!closureUpdateRequest.isSameOrOlderThan(closureUpdateRequest2)) continue;
            closureUpdateRequest = closureUpdateRequest2;
        }
        final ClosureUpdateRequest closureUpdateRequest3 = closureUpdateRequest;
        new Thread(new Runnable(){

            @Override
            public void run() {
                ServiceManager.this.computeClosure(closureUpdateRequest3);
            }
        }).start();
    }

    private void computeClosure(ClosureUpdateRequest closureUpdateRequest) {
        Closure closure = new Closure(this.fExecutor, this.fRemoteCommandPort);
        ServiceUpdate serviceUpdate = closure.compute(closureUpdateRequest.getHosts());
        Iterator<ClosureUpdateRequest> iterator = this.fClosureUpdateRequests.iterator();
        while (iterator.hasNext()) {
            ClosureUpdateRequest closureUpdateRequest2 = iterator.next();
            if (!closureUpdateRequest2.isSameOrOlderThan(closureUpdateRequest)) continue;
            closureUpdateRequest2.notifyObserver(serviceUpdate);
            iterator.remove();
        }
        this.fRunning.set(false);
        this.initiateNextComputation();
    }

    static {
        ControlSender.registerProtocol();
    }

    private class ClosureUpdateRequest {
        private Set<Host> fHosts = new HashSet<Host>();
        private ServiceUpdateObserver fObserver;
        private Date fStartTime;

        ClosureUpdateRequest(Collection<Host> collection, ServiceUpdateObserver serviceUpdateObserver) {
            if (collection != null) {
                this.fHosts.addAll(collection);
            }
            this.fObserver = serviceUpdateObserver;
            this.fStartTime = new Date(System.currentTimeMillis());
        }

        public Date getStartTime() {
            return this.fStartTime;
        }

        public Set<Host> getHosts() {
            return Collections.unmodifiableSet(this.fHosts);
        }

        public void addNode(Host host) {
            this.fHosts.add(host);
        }

        public void notifyObserver(ServiceUpdate serviceUpdate) {
            if (this.fObserver != null) {
                this.fObserver.updateCompleted(serviceUpdate);
            }
        }

        public boolean isSameOrOlderThan(ClosureUpdateRequest closureUpdateRequest) {
            assert (closureUpdateRequest != null);
            return closureUpdateRequest.getHosts().containsAll(this.getHosts()) && (this.getStartTime().before(closureUpdateRequest.getStartTime()) || this.getStartTime().equals(closureUpdateRequest.getStartTime()));
        }

        public String toString() {
            return this.fStartTime + " | " + this.fHosts;
        }
    }
}

