/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter;

import com.mathworks.services.Prefs;
import com.mathworks.toolbox.distcomp.admincenter.PackageInfo;
import com.mathworks.toolbox.distcomp.admincenter.SessionImporter;
import com.mathworks.toolbox.distcomp.admincenter.services.action.SystemErrorHandler;
import com.mathworks.toolbox.distcomp.admincenter.testing.model.ClusterData;
import com.mathworks.toolbox.distcomp.control.serviceinfo.ServiceInfo;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.util.Version;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class PersistenceManager {
    private Map<Object, Object> fPrefCache;

    public SessionImporter getSessionRetriever(final SystemErrorHandler systemErrorHandler) {
        return new AbstractSessionImporter(){

            @Override
            protected Session loadSession() {
                return PersistenceManager.this.retrieveSession(systemErrorHandler);
            }

            @Override
            public void handleException(Exception exception) {
                systemErrorHandler.handleError(exception);
            }
        };
    }

    public SessionImporter getFileImporter(final File file, final SystemErrorHandler systemErrorHandler) {
        return new AbstractSessionImporter(){

            @Override
            protected Session loadSession() throws Exception {
                return PersistenceManager.this.importSession(file);
            }

            @Override
            public void handleException(Exception exception) {
                systemErrorHandler.handleError(exception);
            }
        };
    }

    public void saveSession(int n, Collection<ServiceInfo> collection, ClusterData clusterData, SystemErrorHandler systemErrorHandler) {
        try {
            this.saveSession(new Session(n, collection, clusterData));
        }
        catch (Exception exception) {
            systemErrorHandler.handleError(exception);
        }
    }

    public void exportSession(int n, Collection<ServiceInfo> collection, ClusterData clusterData, File file, SystemErrorHandler systemErrorHandler) {
        try {
            this.exportSession(new Session(n, collection, clusterData), file);
        }
        catch (PersistenceException persistenceException) {
            systemErrorHandler.handleError(persistenceException);
        }
    }

    public synchronized Object getPref(String string) throws PersistenceException {
        if (this.fPrefCache == null) {
            File file = this.getPrefsFile();
            if (file.exists()) {
                ObjectInputStream objectInputStream = null;
                try {
                    objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
                    Object object = objectInputStream.readObject();
                    if (object instanceof Map) {
                        Map map = (Map)object;
                        this.fPrefCache = new HashMap<Object, Object>(map);
                    }
                }
                catch (Exception exception) {
                    throw new PersistenceException(exception);
                }
                finally {
                    if (objectInputStream != null) {
                        try {
                            objectInputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            if (this.fPrefCache == null) {
                this.fPrefCache = new HashMap<Object, Object>();
            }
        }
        return this.fPrefCache.get(string);
    }

    public synchronized void savePref(String string, Object object) throws PersistenceException {
        Object object2 = this.getPref(string);
        if (object2 != null && object2.equals(object) || object2 == null && object == null) {
            return;
        }
        this.fPrefCache.put(string, object);
        File file = this.getPrefsFile();
        ObjectOutputStream objectOutputStream = null;
        try {
            File file2 = File.createTempFile(file.getName(), null, file.getParentFile());
            objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
            objectOutputStream.writeObject(this.fPrefCache);
            objectOutputStream.close();
            if (file.exists()) {
                file.delete();
            }
            if (!file2.renameTo(file)) {
                throw new PersistenceException("Problem renaming temporary session file.");
            }
        }
        catch (IOException iOException) {
            throw new PersistenceException(iOException);
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private synchronized Session retrieveSession(SystemErrorHandler systemErrorHandler) {
        try {
            return this.importSession(this.getSessionFile());
        }
        catch (Exception exception) {
            systemErrorHandler.handleError(exception);
            return this.createEmptySession();
        }
    }

    private synchronized void saveSession(Session session) throws PersistenceException {
        this.exportSession(session, this.getSessionFile());
    }

    private synchronized void exportSession(Session session, File file) throws PersistenceException {
        ObjectOutputStream objectOutputStream = null;
        try {
            File file2 = File.createTempFile(file.getName(), null, file.getParentFile());
            objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
            objectOutputStream.writeObject(Version.VERSION_STRING);
            objectOutputStream.writeObject(session);
            objectOutputStream.close();
            if (file.exists()) {
                file.delete();
            }
            if (!file2.renameTo(file)) {
                throw new PersistenceException("Problem renaming temporary session file.");
            }
        }
        catch (IOException iOException) {
            throw new PersistenceException(iOException);
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private synchronized Session importSession(File file) throws Exception {
        if (file.exists()) {
            ObjectInputStream objectInputStream = null;
            try {
                Object object;
                objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
                try {
                    object = (String)objectInputStream.readObject();
                    if (!this.versionCompatible((String)object)) {
                        throw new VersionException((String)object);
                    }
                }
                catch (ClassCastException classCastException) {
                    throw new VersionException(classCastException, null);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new VersionException(classNotFoundException, null);
                }
                object = (Session)objectInputStream.readObject();
                return object;
            }
            catch (InvalidClassException invalidClassException) {
                throw new VersionException(invalidClassException, null);
            }
            finally {
                if (objectInputStream != null) {
                    try {
                        objectInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "Creating empty session.");
        return this.createEmptySession();
    }

    private boolean versionCompatible(String string) {
        return Version.VERSION_STRING.equals(string);
    }

    private File getSessionFile() throws PersistenceException {
        return new File(this.getOrCreateSessionDir(), "session.mdcs");
    }

    private File getPrefsFile() throws PersistenceException {
        return new File(this.getOrCreateSessionDir(), "prefs");
    }

    private File getOrCreateSessionDir() throws PersistenceException {
        File file = new File(Prefs.getPropertyDirectory());
        if (!file.exists()) {
            throw new PersistenceException("The Matlab prefs dir \"" + file + "\" does not exist.");
        }
        File file2 = new File(file, "admincenter");
        if (!file2.exists() && !file2.mkdir()) {
            throw new PersistenceException("Could not create directory \"" + file2 + "\".");
        }
        return file2;
    }

    private Session createEmptySession() {
        return new Session(27350, new ArrayList<ServiceInfo>(), new ClusterData());
    }

    private static abstract class AbstractSessionImporter
    implements SessionImporter {
        private Session fSession = null;

        private AbstractSessionImporter() {
        }

        @Override
        public ClusterData getTestData() throws Exception {
            return this.getSession().getTestData();
        }

        @Override
        public int getBaseport() throws Exception {
            return this.getSession().getBaseport();
        }

        @Override
        public Collection<ServiceInfo> getServiceInfo() throws Exception {
            return this.getSession().getInfoList();
        }

        private synchronized Session getSession() throws Exception {
            if (this.fSession == null) {
                this.fSession = this.loadSession();
            }
            return this.fSession;
        }

        protected abstract Session loadSession() throws Exception;
    }

    private static class Session
    implements Serializable {
        private final int fBaseport;
        private final Collection<ServiceInfo> fInfoList;
        private final ClusterData fTestData;

        Session(int n, Collection<ServiceInfo> collection, ClusterData clusterData) {
            this.fBaseport = n;
            this.fInfoList = collection;
            this.fTestData = clusterData;
        }

        public int getBaseport() {
            return this.fBaseport;
        }

        public Collection<ServiceInfo> getInfoList() {
            return this.fInfoList;
        }

        public ClusterData getTestData() {
            return this.fTestData;
        }
    }

    public static class VersionException
    extends PersistenceException {
        private final String fVersion;

        public VersionException(String string) {
            this.fVersion = string;
        }

        public VersionException(Throwable throwable, String string) {
            super(throwable);
            this.fVersion = string;
        }

        public String getVersion() {
            return this.fVersion;
        }
    }

    public static class PersistenceException
    extends Exception {
        public PersistenceException() {
        }

        public PersistenceException(Throwable throwable) {
            super(throwable);
        }

        public PersistenceException(String string) {
            super(string);
        }

        public PersistenceException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

