/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter;

import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.toolbox.distcomp.admincenter.TestDataAccessor;
import com.mathworks.toolbox.distcomp.admincenter.guiutilities.ACHelpButtonFactory;
import com.mathworks.toolbox.distcomp.admincenter.resources.ResourceStatics;
import com.mathworks.toolbox.distcomp.admincenter.services.action.DefaultSystemErrorHandler;
import com.mathworks.toolbox.distcomp.admincenter.services.model.ClientMonitor;
import com.mathworks.toolbox.distcomp.admincenter.services.model.ServiceRequestException;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuidePanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;

public class NewSessionAction
extends MJAbstractAction {
    private static final String HELP = "AC_NEW_SESSION";
    private static final Dimension DEFAULT_DIALOG_SIZE = new Dimension(450, 250);
    private final ClientMonitor fMonitor;
    private final TestDataAccessor fTestDataAccessor;
    private boolean fCancelled;

    public NewSessionAction(ClientMonitor clientMonitor, TestDataAccessor testDataAccessor) {
        super(ResourceStatics.sRes.getString("file.newsession.action"));
        this.fMonitor = clientMonitor;
        this.fTestDataAccessor = testDataAccessor;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.fCancelled = true;
        final MJDialog mJDialog = new MJDialog(NewSessionAction.getFrame((ActionEvent)actionEvent), ResourceStatics.sRes.getString("file.newsession.title"), true);
        mJDialog.setDefaultCloseOperation(2);
        MJLabel mJLabel = new MJLabel("<html>" + ResourceStatics.sRes.getString("file.newsession.summary") + "<br><br>" + ResourceStatics.sRes.getString("file.newsession.note") + "<br><br>" + ResourceStatics.sRes.getString("file.newsession.question") + "<br><br>" + "</html>");
        JButton jButton = ACHelpButtonFactory.createHelpButton(HELP, "NewSessionDialog.HelpButton");
        MJButton mJButton = new MJButton(ResourceStatics.sRes.getString("services.dialog.cancel"));
        mJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                mJDialog.dispose();
            }
        });
        MJButton mJButton2 = new MJButton(ResourceStatics.sRes.getString("services.dialog.proceed"));
        mJButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewSessionAction.this.fCancelled = false;
                mJDialog.dispose();
            }
        });
        mJDialog.getRootPane().setDefaultButton((JButton)mJButton2);
        mJDialog.setFocusTarget((Component)mJButton2);
        StyleGuidePanel styleGuidePanel = new StyleGuidePanel();
        styleGuidePanel.addLine((JComponent)mJLabel, 8);
        styleGuidePanel.addLine((JComponent[][])new JComponent[][]{{null, mJButton2, mJButton, jButton}}, 0, 0);
        mJDialog.setContentPane((Container)((Object)styleGuidePanel));
        mJDialog.pack();
        mJDialog.setSize(DEFAULT_DIALOG_SIZE);
        mJDialog.setResizable(false);
        mJDialog.setLocationRelativeTo((Component)NewSessionAction.getFrame((ActionEvent)actionEvent));
        mJDialog.show();
        mJDialog.setName("NewSessionDialog");
        mJButton2.setName("NewSessionDialog.ProceedButton");
        mJButton.setName("NewSessionDialog.CancelButton");
        jButton.setName("NewSessionDialog.HelpButton");
        if (!this.fCancelled) {
            try {
                this.fMonitor.clearInfo();
                this.fTestDataAccessor.resetTestData();
            }
            catch (ServiceRequestException serviceRequestException) {
                new DefaultSystemErrorHandler().handleError(serviceRequestException);
            }
        }
    }
}

