/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter;

import com.jidesoft.swing.JideSplitPane;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJStartup;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolbox.distcomp.admincenter.MacAppListenerImpl;
import com.mathworks.toolbox.distcomp.admincenter.PackageInfo;
import com.mathworks.toolbox.distcomp.admincenter.PersistenceManager;
import com.mathworks.toolbox.distcomp.admincenter.SessionImporter;
import com.mathworks.toolbox.distcomp.admincenter.StatusBar;
import com.mathworks.toolbox.distcomp.admincenter.TestDataAccessor;
import com.mathworks.toolbox.distcomp.admincenter.TestDataViewer;
import com.mathworks.toolbox.distcomp.admincenter.TestResultsDialog;
import com.mathworks.toolbox.distcomp.admincenter.ToolkitMenuBar;
import com.mathworks.toolbox.distcomp.admincenter.services.action.DefaultSystemErrorHandler;
import com.mathworks.toolbox.distcomp.admincenter.services.action.GlasspaneBusyHandler;
import com.mathworks.toolbox.distcomp.admincenter.services.action.SystemErrorHandler;
import com.mathworks.toolbox.distcomp.admincenter.services.model.ClientMonitor;
import com.mathworks.toolbox.distcomp.admincenter.services.model.ServiceRequestException;
import com.mathworks.toolbox.distcomp.admincenter.services.model.UpdateProgressListener;
import com.mathworks.toolbox.distcomp.admincenter.services.model.UpdateTimer;
import com.mathworks.toolbox.distcomp.admincenter.services.view.HostsModulePane;
import com.mathworks.toolbox.distcomp.admincenter.services.view.JobManagerModulePane;
import com.mathworks.toolbox.distcomp.admincenter.services.view.ModuleGroup;
import com.mathworks.toolbox.distcomp.admincenter.services.view.ModulePane;
import com.mathworks.toolbox.distcomp.admincenter.services.view.WorkerModulePane;
import com.mathworks.toolbox.distcomp.admincenter.testing.model.ClusterData;
import com.mathworks.toolbox.distcomp.control.servicerequest.Host;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuideEmptyPanel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuidePanel;
import com.mathworks.toolbox.distcomp.util.ResourceBundleUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuBar;

public class AdminCenter {
    private ClusterData fTestData;
    private ClientMonitor fClientMonitor;
    private TestDataAccessor fTestDataAccessor;
    private UpdateTimer fUpdateTimer;
    private PersistenceManager fPersistenceManager;
    private static final int DEFAULT_UPDATE_FREQ = 120;
    private final ToolkitFrame fFrame = new ToolkitFrame();
    private static final ResourceBundleUtilities sRes = ResourceBundleUtilities.getInstance(AdminCenter.class);
    private static final Dimension DEFAULT_FRAME_SIZE = new Dimension(900, 700);
    private static final int INTRO_UI_WIDTH = 600;
    private static final int INTRO_UI_HEIGHT = 300;

    public static void main(String[] stringArray) {
        MJStartup.init();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AdminCenter adminCenter = new AdminCenter();
                adminCenter.initData();
            }
        });
    }

    private AdminCenter() {
    }

    private void initData() {
        this.fPersistenceManager = new PersistenceManager();
        SystemErrorHandler systemErrorHandler = this.createSessionErrorHandler(true);
        final SystemErrorHandler systemErrorHandler2 = this.createSessionErrorHandler(false);
        SessionImporter sessionImporter = this.fPersistenceManager.getSessionRetriever(systemErrorHandler);
        try {
            this.fClientMonitor = new ClientMonitor();
        }
        catch (ServiceRequestException serviceRequestException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Problem creating ClientMonitor", serviceRequestException);
        }
        try {
            this.fTestData = sessionImporter.getTestData();
        }
        catch (Exception exception) {
            sessionImporter.handleException(exception);
            this.fTestData = new ClusterData();
        }
        this.fClientMonitor.importData(sessionImporter, true);
        this.fTestDataAccessor = new TestDataAccessor(){
            private TestDataViewer fViewer;
            private boolean fTestDataUpdated = false;

            @Override
            public ClusterData getTestData() {
                if (this.fTestDataUpdated) {
                    return AdminCenter.this.fTestData.clone();
                }
                HashSet<String> hashSet = new HashSet<String>();
                for (Host host : AdminCenter.this.fClientMonitor.getHostTableModel().getHosts()) {
                    hashSet.add(host.getHostname());
                }
                return new ClusterData(hashSet, AdminCenter.this.fClientMonitor.getBaseport());
            }

            @Override
            public void setTestData(ClusterData clusterData) {
                this.updateTestData(clusterData, true);
            }

            @Override
            public void resetTestData() {
                this.updateTestData(new ClusterData(), false);
            }

            @Override
            public void setTestDataViewer(TestDataViewer testDataViewer) {
                this.fViewer = testDataViewer;
            }

            private void updateTestData(ClusterData clusterData, boolean bl) {
                AdminCenter.this.fTestData = clusterData;
                this.fTestDataUpdated = bl;
                AdminCenter.this.fPersistenceManager.saveSession(AdminCenter.this.fClientMonitor.getBaseport(), AdminCenter.this.fClientMonitor.getServiceInfo(), AdminCenter.this.fTestData, systemErrorHandler2);
                if (this.fViewer != null) {
                    this.fViewer.testDataChanged();
                }
            }
        };
        this.fClientMonitor.addHostNameListener(new ClientMonitor.HostNameListener(){

            @Override
            public void addedHosts(Collection<String> collection) {
                AdminCenter.this.fTestDataAccessor.resetTestData();
            }

            @Override
            public void removedHosts(Collection<String> collection) {
                AdminCenter.this.fTestDataAccessor.resetTestData();
            }
        });
        this.fClientMonitor.addBasePortListener(new ClientMonitor.BasePortListener(){

            @Override
            public void basePortChanged(int n) {
                AdminCenter.this.fTestDataAccessor.resetTestData();
            }
        });
        this.fClientMonitor.addUpdateProgressListener(new UpdateProgressListener(){

            @Override
            public void updateStarted(boolean bl) {
            }

            @Override
            public void updateFinished(boolean bl) {
                AdminCenter.this.fPersistenceManager.saveSession(AdminCenter.this.fClientMonitor.getBaseport(), AdminCenter.this.fClientMonitor.getServiceInfo(), AdminCenter.this.fTestData, systemErrorHandler2);
            }

            @Override
            public void updateFinishing() {
            }
        });
        this.initGUI();
    }

    private SystemErrorHandler createSessionErrorHandler(final boolean bl) {
        return new DefaultSystemErrorHandler(){

            @Override
            public void handleError(Exception exception) {
                PersistenceManager.VersionException versionException;
                String string;
                super.handleError(exception);
                String string2 = bl ? "load" : "save";
                String string3 = sRes.getString("dialog.error.session_" + string2 + ".title", new Object[0]);
                String string4 = exception instanceof PersistenceManager.VersionException && bl ? ((string = (versionException = (PersistenceManager.VersionException)exception).getVersion()).length() != 0 ? MessageFormat.format(sRes.getString("dialog.error.session_load.knownversionmismatch", new Object[0]), string) : sRes.getString("dialog.error.session_load.unknownversionmismatch", new Object[0])) : sRes.getString("dialog.error.session_" + string2 + ".message", new Object[0]);
                MJOptionPane.showMessageDialog((Component)((Object)AdminCenter.this.fFrame), (Object)string4, (String)string3, (int)2);
            }
        };
    }

    private void initGUI() {
        assert (EventQueue.isDispatchThread()) : "Must be on dispatch thread";
        this.fFrame.setDefaultCloseOperation(2);
        this.fFrame.setName("adminCenterMain");
        if (this.fFrame.isStandAlone()) {
            MacAppListenerImpl.installMacAppListener(this.fFrame);
        }
        Integer n = null;
        try {
            n = (Integer)this.fPersistenceManager.getPref("UPDATE_FREQ");
        }
        catch (PersistenceManager.PersistenceException persistenceException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Could not get pref", persistenceException);
        }
        if (n == null) {
            n = 120;
        }
        this.fUpdateTimer = new UpdateTimer(this.fClientMonitor, StatusBar.TIMES){

            @Override
            public void setFreqSeconds(int n) {
                super.setFreqSeconds(n);
                try {
                    AdminCenter.this.fPersistenceManager.savePref("UPDATE_FREQ", n);
                }
                catch (PersistenceManager.PersistenceException persistenceException) {
                    PackageInfo.LOGGER.log(DistcompLevel.ONE, "Could not save pref", persistenceException);
                }
            }
        };
        this.fUpdateTimer.setFreqSeconds(n);
        TestResultsDialog testResultsDialog = new TestResultsDialog(this.fFrame, this.fTestDataAccessor, this.fUpdateTimer);
        ModuleGroup moduleGroup = new ModuleGroup();
        HostsModulePane hostsModulePane = new HostsModulePane(this.fClientMonitor, testResultsDialog);
        moduleGroup.addModule(hostsModulePane);
        JobManagerModulePane jobManagerModulePane = new JobManagerModulePane(this.fClientMonitor);
        moduleGroup.addModule(jobManagerModulePane);
        WorkerModulePane workerModulePane = new WorkerModulePane(this.fClientMonitor);
        moduleGroup.addModule(workerModulePane);
        JideSplitPane jideSplitPane = new JideSplitPane(0);
        jideSplitPane.setContinuousLayout(true);
        jideSplitPane.setShowGripper(true);
        jideSplitPane.addPane((Component)((Object)hostsModulePane));
        jideSplitPane.addPane((Component)((Object)jobManagerModulePane));
        jideSplitPane.addPane((Component)((Object)workerModulePane));
        this.fFrame.setJMenuBar((JMenuBar)((Object)new ToolkitMenuBar(this.fClientMonitor, this.fTestDataAccessor, new ModulePane[]{hostsModulePane, jobManagerModulePane, workerModulePane}, this.fPersistenceManager, this.fUpdateTimer)));
        this.fFrame.setTitle(sRes.getString("frame.title", new Object[0]));
        this.fFrame.setSize(DEFAULT_FRAME_SIZE);
        this.fFrame.initLocation();
        final GlasspaneBusyHandler glasspaneBusyHandler = new GlasspaneBusyHandler();
        this.fClientMonitor.addUpdateProgressListener(new UpdateProgressListener(){

            @Override
            public void updateStarted(boolean bl) {
                if (bl) {
                    glasspaneBusyHandler.showBusy(true, AdminCenter.this.fFrame);
                }
            }

            @Override
            public void updateFinished(boolean bl) {
                glasspaneBusyHandler.showBusy(false, AdminCenter.this.fFrame);
            }

            @Override
            public void updateFinishing() {
            }
        });
        StatusBar statusBar = new StatusBar(this.fUpdateTimer, this.fClientMonitor);
        StyleGuideEmptyPanel styleGuideEmptyPanel = new StyleGuideEmptyPanel();
        styleGuideEmptyPanel.addLine((JComponent)jideSplitPane, 8);
        styleGuideEmptyPanel.addLine((JComponent)((Object)statusBar));
        this.fFrame.setContentPane((Container)((Object)styleGuideEmptyPanel));
        this.fFrame.setVisible(true);
        this.maybeShowIntroDialog(hostsModulePane);
    }

    private void maybeShowIntroDialog(HostsModulePane hostsModulePane) {
        if (!this.fClientMonitor.getHostTableModel().getHosts().isEmpty()) {
            return;
        }
        final MJDialog mJDialog = new MJDialog((Frame)((Object)this.fFrame), true);
        mJDialog.setDefaultCloseOperation(2);
        mJDialog.setName("introDialog");
        final Action action = hostsModulePane.getAddHostsAction();
        String string = (String)action.getValue("Name");
        mJDialog.setTitle(sRes.getString("intro.dialog.title", new Object[0]));
        MJLabel mJLabel = new MJLabel();
        String string2 = MJUtilities.exciseMnemonic((String)sRes.getString("menu.file.name", new Object[0]));
        String string3 = MJUtilities.exciseMnemonic((String)sRes.getString("menu.file.import", new Object[0]));
        mJLabel.setText(sRes.getString("intro.dialog.content", string, hostsModulePane.getTitle(), string2, string3));
        MJButton mJButton = new MJButton((Action)new AbstractAction(string){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                mJDialog.dispose();
                action.actionPerformed(actionEvent);
            }
        });
        mJButton.setName("addButton");
        MJButton mJButton2 = new MJButton((Action)new AbstractAction(sRes.getString("services.dialog.close", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                mJDialog.dispose();
            }
        });
        mJButton2.setName("closeButton");
        StyleGuidePanel styleGuidePanel = new StyleGuidePanel();
        styleGuidePanel.addLine((JComponent)mJLabel);
        styleGuidePanel.addLine((JComponent)((Object)new StyleGuideEmptyPanel()), 8);
        styleGuidePanel.addLine((JComponent[][])new JComponent[][]{{null, mJButton, mJButton2}}, 0, 0);
        mJDialog.setContentPane((Container)((Object)styleGuidePanel));
        mJDialog.getRootPane().setDefaultButton((JButton)mJButton);
        mJDialog.setSize(600, 300);
        mJDialog.setResizable(false);
        mJDialog.setLocationRelativeTo((Component)((Object)this.fFrame));
        mJDialog.setVisible(true);
    }

    private void exit() {
        this.fUpdateTimer.dispose();
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "AdminCenter Frame Disposed.");
        if (this.fFrame.isStandAlone()) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "AdminCenter Application Exiting.");
            System.exit(0);
        }
    }

    private class ToolkitFrame
    extends MJFrame {
        private ToolkitFrame() {
        }

        public void dispose() {
            super.dispose();
            AdminCenter.this.exit();
        }

        private boolean isStandAlone() {
            return !Matlab.isMatlabAvailable();
        }

        public void initLocation() {
            if (this.isStandAlone()) {
                int n = (Toolkit.getDefaultToolkit().getScreenSize().width - this.getSize().width) / 2;
                int n2 = (Toolkit.getDefaultToolkit().getScreenSize().height - this.getSize().height) / 2;
                this.setLocation(n, n2);
            } else {
                this.setLocationRelativeTo(Frame.getFrames()[0]);
            }
        }
    }
}

