/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.testmeas.guiutil;

import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;

public class RangeTextField
extends JTextField
implements ActionListener,
FocusListener {
    private static final long serialVersionUID = 1L;
    public static final int INTEGER = 0;
    public static final int DOUBLE = 1;
    private static final String[] MODESTR = new String[]{"an integer", "a double"};
    private int mode = 0;
    private String lastValidValue = "";
    private double minValue = 0.0;
    private double maxValue = 0.0;
    private String errorMessage = "";
    private String propertyName = "";
    private boolean okToBeEmpty = true;
    private boolean okToError = true;

    public RangeTextField(String string, double d, double d2) {
        this(string, d, d2, "");
    }

    public RangeTextField(String string, double d, double d2, String string2) {
        this.propertyName = string;
        this.minValue = d;
        this.maxValue = d2;
        this.lastValidValue = string2;
        this.setText(this.lastValidValue);
        this.addActionListener(this);
        this.addFocusListener(this);
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setMax(double d) {
        this.maxValue = d;
    }

    public double getMax() {
        return this.maxValue;
    }

    public void setMin(double d) {
        this.minValue = d;
    }

    public double getMin() {
        return this.minValue;
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public int getMode() {
        return this.mode;
    }

    public void setPropertyName(String string) {
        this.propertyName = string;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setOKToBeEmpty(boolean bl) {
        this.okToBeEmpty = bl;
    }

    public boolean isOKToBeEmpty() {
        return this.okToBeEmpty;
    }

    public void setOKToError(boolean bl) {
        this.okToError = bl;
    }

    public boolean isOKToError() {
        return this.okToError;
    }

    public void error() {
        if (this.errorMessage.equals("")) {
            this.errorMessage = "The " + this.propertyName + " must be " + MODESTR[this.mode] + " ranging from " + this.formatValue(this.minValue) + " to " + this.formatValue(this.maxValue) + ".";
        }
        TMStringUtil.error("Invalid Value", this.errorMessage);
    }

    private String formatValue(double d) {
        switch (this.mode) {
            case 0: {
                return "" + (int)d;
            }
            case 1: {
                return "" + d;
            }
        }
        return "";
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.verifyValue();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.verifyValue();
    }

    public void verifyValue() {
        if (!this.isValidValue() && this.isOKToError()) {
            this.error();
        }
    }

    public boolean isValidValue() {
        if (this.getText().equals("")) {
            if (this.okToBeEmpty) {
                this.lastValidValue = "";
                return true;
            }
            this.setTextToLastValidValue();
            return false;
        }
        switch (this.mode) {
            case 0: {
                return this.verifyIntegerValue();
            }
            case 1: {
                return this.verifyDoubleValue();
            }
        }
        return false;
    }

    private boolean verifyIntegerValue() {
        String string = this.getText();
        if (TMStringUtil.isinteger(string)) {
            int n = TMStringUtil.str2int(string);
            if ((double)n >= this.minValue && (double)n <= this.maxValue) {
                this.lastValidValue = string;
                return true;
            }
            this.setTextToLastValidValue();
            return false;
        }
        this.setTextToLastValidValue();
        return false;
    }

    private boolean verifyDoubleValue() {
        String string = this.getText();
        if (TMStringUtil.isdouble(string)) {
            double d = TMStringUtil.str2double(string);
            if (d >= this.minValue && d <= this.maxValue) {
                this.lastValidValue = string;
                return true;
            }
            this.setTextToLastValidValue();
            return false;
        }
        this.setTextToLastValidValue();
        return false;
    }

    private void setTextToLastValidValue() {
        this.removeActionListener(this);
        this.setText(this.lastValidValue);
        this.addActionListener(this);
    }
}

