/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.testmeas.browser;

import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.toolbox.testmeas.browser.Browser;
import com.mathworks.toolbox.testmeas.browser.BrowserClient;
import com.mathworks.toolbox.testmeas.browser.BrowserConfigFileReader;
import com.mathworks.toolbox.testmeas.browser.BrowserConfigFileWriter;
import com.mathworks.toolbox.testmeas.browser.BrowserListener;
import com.mathworks.toolbox.testmeas.browser.BrowserTreeNode;
import com.mathworks.toolbox.testmeas.browser.TreeViewListener;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class BaseBrowserClient
implements BrowserClient {
    public Vector<TreeViewListener> treeViewListeners;
    public Vector<BrowserListener> browserListeners;
    public MJFrame frame;
    public Browser browser;

    @Override
    public void init() {
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void save(BrowserConfigFileWriter browserConfigFileWriter, Element element) {
    }

    @Override
    public void load(BrowserConfigFileReader browserConfigFileReader, Node node) {
    }

    @Override
    public void refresh() {
    }

    @Override
    public void addToolbarButtons(MJToolBar mJToolBar) {
    }

    @Override
    public JMenu[] getMenus() {
        return null;
    }

    @Override
    public JMenu[] getMenus(BrowserTreeNode browserTreeNode, BrowserTreeNode browserTreeNode2, BrowserTreeNode[] browserTreeNodeArray) {
        return null;
    }

    @Override
    public JMenuItem getHelpMenuItem() {
        return null;
    }

    @Override
    public JMenuItem getAboutMenuItem() {
        return null;
    }

    @Override
    public void helpMenuActionPerformed(String string) {
    }

    @Override
    public void menuSelected(String string, JMenu jMenu, BrowserTreeNode browserTreeNode) {
    }

    public MJFrame getBrowserFrame() {
        if (this.frame == null && this.browser != null) {
            this.frame = (MJFrame)SwingUtilities.windowForComponent(this.browser);
        }
        return this.frame;
    }

    @Override
    public void setBrowser(Browser browser) {
        this.browser = browser;
        if (browser != null) {
            this.frame = (MJFrame)SwingUtilities.windowForComponent(this.browser);
        }
    }

    @Override
    public String getToolTipString(BrowserTreeNode browserTreeNode) {
        return browserTreeNode.getToolTip();
    }

    @Override
    public ImageIcon getNodeIcon(BrowserTreeNode browserTreeNode) {
        return browserTreeNode.getIcon();
    }

    @Override
    public void cleanupNode(BrowserTreeNode browserTreeNode, BrowserTreeNode browserTreeNode2, BrowserTreeNode[] browserTreeNodeArray) {
    }

    @Override
    public boolean defineRightClickMenuItems(BrowserTreeNode browserTreeNode, JPopupMenu jPopupMenu) {
        return false;
    }

    @Override
    public void doubleClickOnNode(BrowserTreeNode browserTreeNode) {
    }

    @Override
    public void reClickOnNode(BrowserTreeNode browserTreeNode) {
    }

    @Override
    public void addTreeViewListener(TreeViewListener treeViewListener) {
        if (this.treeViewListeners == null) {
            this.treeViewListeners = new Vector();
        }
        if (!this.treeViewListeners.contains(treeViewListener)) {
            this.treeViewListeners.addElement(treeViewListener);
        }
    }

    @Override
    public void removeTreeViewListener(TreeViewListener treeViewListener) {
        if (this.treeViewListeners == null) {
            return;
        }
        this.treeViewListeners.removeElement(treeViewListener);
        treeViewListener = null;
    }

    @Override
    public void postNodeAddedEvent(String string, String[] stringArray, BrowserTreeNode browserTreeNode, int n, boolean bl) {
        if (this.treeViewListeners == null) {
            return;
        }
        for (int i = 0; i < this.treeViewListeners.size(); ++i) {
            TreeViewListener treeViewListener = this.treeViewListeners.elementAt(i);
            treeViewListener.addNode(string, stringArray, browserTreeNode, n, bl);
        }
    }

    @Override
    public void postNodeAddedEvent(String string, String[] stringArray, BrowserTreeNode browserTreeNode, int n, boolean bl, int n2) {
        if (this.treeViewListeners == null) {
            return;
        }
        for (int i = 0; i < this.treeViewListeners.size(); ++i) {
            TreeViewListener treeViewListener = this.treeViewListeners.elementAt(i);
            treeViewListener.addNode(string, stringArray, browserTreeNode, n, bl, n2);
        }
    }

    @Override
    public void postNodeAddedEvent(BrowserTreeNode browserTreeNode, BrowserTreeNode browserTreeNode2, boolean bl, int n) {
        if (this.treeViewListeners == null) {
            return;
        }
        for (int i = 0; i < this.treeViewListeners.size(); ++i) {
            TreeViewListener treeViewListener = this.treeViewListeners.elementAt(i);
            treeViewListener.addNode(browserTreeNode, browserTreeNode2, bl, n);
        }
    }

    public void postNodeEditingEvent(BrowserTreeNode browserTreeNode) {
        if (this.treeViewListeners == null) {
            return;
        }
        for (int i = 0; i < this.treeViewListeners.size(); ++i) {
            TreeViewListener treeViewListener = this.treeViewListeners.elementAt(i);
            treeViewListener.editingNode(browserTreeNode);
        }
    }

    @Override
    public void postNodeRemovedEvent(String string, String[] stringArray, int n) {
        if (this.treeViewListeners == null) {
            return;
        }
        for (int i = 0; i < this.treeViewListeners.size(); ++i) {
            TreeViewListener treeViewListener = this.treeViewListeners.elementAt(i);
            treeViewListener.removeNode(string, stringArray, n);
        }
    }

    @Override
    public void postNodeRemovedEvent(BrowserTreeNode browserTreeNode, BrowserTreeNode browserTreeNode2) {
        if (this.treeViewListeners == null) {
            return;
        }
        for (int i = 0; i < this.treeViewListeners.size(); ++i) {
            TreeViewListener treeViewListener = this.treeViewListeners.elementAt(i);
            treeViewListener.removeNode(browserTreeNode, browserTreeNode2);
        }
    }

    @Override
    public void postNodeRemovedEvent(String[] stringArray, Object object, int n) {
        if (this.treeViewListeners == null) {
            return;
        }
        for (int i = 0; i < this.treeViewListeners.size(); ++i) {
            TreeViewListener treeViewListener = this.treeViewListeners.elementAt(i);
            treeViewListener.removeNode(stringArray, object, n);
        }
    }

    @Override
    public void postNodeRemovedEvent(BrowserTreeNode browserTreeNode) {
        if (this.treeViewListeners == null) {
            return;
        }
        for (int i = 0; i < this.treeViewListeners.size(); ++i) {
            TreeViewListener treeViewListener = this.treeViewListeners.elementAt(i);
            treeViewListener.removeNode(browserTreeNode);
        }
    }

    @Override
    public void postNodeUpdatedEvent(BrowserTreeNode browserTreeNode) {
        if (this.treeViewListeners == null) {
            return;
        }
        for (int i = 0; i < this.treeViewListeners.size(); ++i) {
            TreeViewListener treeViewListener = this.treeViewListeners.elementAt(i);
            treeViewListener.updateNode(browserTreeNode);
        }
    }

    @Override
    public void postNodeExpandEvent(BrowserTreeNode browserTreeNode) {
        if (this.treeViewListeners == null) {
            return;
        }
        for (int i = 0; i < this.treeViewListeners.size(); ++i) {
            TreeViewListener treeViewListener = this.treeViewListeners.elementAt(i);
            treeViewListener.expandNode(browserTreeNode);
        }
    }

    @Override
    public void postNodeSelectedEvent(BrowserTreeNode browserTreeNode) {
        if (this.treeViewListeners == null) {
            return;
        }
        for (int i = 0; i < this.treeViewListeners.size(); ++i) {
            TreeViewListener treeViewListener = this.treeViewListeners.elementAt(i);
            treeViewListener.selectNode(browserTreeNode);
        }
    }

    @Override
    public void addBrowserListener(BrowserListener browserListener) {
        if (this.browserListeners == null) {
            this.browserListeners = new Vector();
        }
        if (!this.browserListeners.contains(browserListener)) {
            this.browserListeners.addElement(browserListener);
        }
    }

    @Override
    public void removeBrowserListener(BrowserListener browserListener) {
        if (this.browserListeners == null) {
            return;
        }
        this.browserListeners.removeElement(browserListener);
        browserListener = null;
    }

    @Override
    public void postStatusBarUpdateEvent(String string) {
        if (this.browserListeners == null) {
            return;
        }
        for (int i = 0; i < this.browserListeners.size(); ++i) {
            BrowserListener browserListener = this.browserListeners.elementAt(i);
            browserListener.postStatusBarMessage(string);
        }
    }

    @Override
    public void postBlockEventsEvent(boolean bl) {
        if (this.browserListeners == null) {
            return;
        }
        for (int i = 0; i < this.browserListeners.size(); ++i) {
            BrowserListener browserListener = this.browserListeners.elementAt(i);
            browserListener.blockEvents(bl);
        }
    }

    public MJButton createToolbarButton(ImageIcon imageIcon, String string) {
        MJButton mJButton = new MJButton((Icon)imageIcon);
        mJButton.setToolTipText(string);
        mJButton.setFlyOverAppearance(true);
        mJButton.setFocusTraversable(false);
        mJButton.setPreferredSize(new Dimension(30, 22));
        mJButton.setMinimumSize(new Dimension(30, 22));
        mJButton.setMaximumSize(new Dimension(30, 22));
        mJButton.setName(string + " Toolbar button");
        return mJButton;
    }
}

