/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.prefs;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.prefs.ColorItem;
import com.mathworks.mlwidgets.prefs.SyntaxHighlightingColorPanel;
import com.mathworks.mlwidgets.prefs.SyntaxPreviewPane;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.services.ColorPrefs;
import com.mathworks.widgets.DropdownButton;
import com.mathworks.widgets.STPPrefsManager;
import com.mathworks.widgets.SyntaxTextPane;
import com.mathworks.widgets.color.ColorPicker;
import com.mathworks.widgets.prefs.PrefsEditorPanelV1;
import com.mathworks.widgets.prefs.PrefsHelp;
import com.mathworks.widgets.prefs.PrefsNode;
import com.mathworks.widgets.text.MWEditorUI;
import com.mathworks.widgets.text.mcode.codepad.CodepadOptions;
import com.mathworks.widgets.text.mcode.variables.VariableHighlightActions;
import com.mathworks.widgets.text.mcode.variables.VariableHighlightPrefs;
import com.mathworks.widgets.text.mcode.variables.VariableHighlightingLayer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.ArrayUtils;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.SettingsAdapter;

public class ProgrammingToolsColorPrefsPanel
extends MJPanel
implements PrefsEditorPanelV1 {
    public static final String PANEL_NAME = "CodeToolsColorPreferencesPanel";
    public static final String PREVIEW_PANE_NAME = "PreviewPane";
    public static final String RESTORE_DEFAULTS_BUTTON_NAME = "RestoreDefaultsButton";
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com.mathworks.mlwidgets.prefs.resources.RES_Prefs");
    private final SyntaxPreviewPane fPreviewPane;
    private final SyntaxHighlightingColorPanel fCodeAnalyzerOptions;
    private final SyntaxHighlightingColorPanel fVariableHighlighting;
    private final SyntaxHighlightingColorPanel fCellOptions;
    private MJCheckBox fAutoFix;
    private MJCheckBox fAutoHighlight;
    private MJCheckBox fNestedVarHighlight;
    private MJCheckBox fShowDividers;
    private MJCheckBox fCellHighlight;
    private JTextComponent fVariableExplain;

    public ProgrammingToolsColorPrefsPanel(Dimension dimension) {
        this.setName(PANEL_NAME);
        this.setSize(dimension);
        this.fPreviewPane = ProgrammingToolsColorPrefsPanel.createPreviewPane();
        this.fCodeAnalyzerOptions = this.createCodeAnalyzerOptions();
        this.fVariableHighlighting = this.createVariableHighlightOptions();
        this.fCellOptions = this.createCellOptions();
        this.layoutPanel();
    }

    private static SyntaxPreviewPane createPreviewPane() {
        final SyntaxPreviewPane syntaxPreviewPane = new SyntaxPreviewPane(PREVIEW_PANE_NAME, BUNDLE.getString("gpcp.acc.MSample"));
        String string = "function testfunction(input)\npersistent multfactor;\nmultfactor = multfactor + 1;\n\n%% section title\na_var = nestedfunction(multfactor)\nunused_var = a_var;\n\tfunction out = nestedfunction(factor)\n\t\tout = input * factor;\n\tend\nend";
        syntaxPreviewPane.setText(string);
        final int n = string.indexOf("a_var") + 1;
        syntaxPreviewPane.setCaretPosition(n);
        syntaxPreviewPane.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                if (caretEvent.getDot() != n) {
                    syntaxPreviewPane.setCaretPosition(n);
                }
            }
        });
        STPPrefsManager sTPPrefsManager = STPPrefsManager.getInstance();
        EditorKit editorKit = syntaxPreviewPane.getEditorKit();
        SettingsAdapter.setColoring((Object)sTPPrefsManager, editorKit.getClass(), (String)"highlight-lines", (Object)new Coloring(null, null, CodepadOptions.getHighlightingColor()));
        ProgrammingToolsColorPrefsPanel.highlightCell(syntaxPreviewPane, CodepadOptions.isCodepadHighlightingOn());
        syntaxPreviewPane.setBoldLines(new int[]{4});
        ProgrammingToolsColorPrefsPanel.drawDividers(syntaxPreviewPane, CodepadOptions.isCodeDividersOn());
        syntaxPreviewPane.setValue(editorKit, ColorPrefs.MatlabColor.WARNING.getKey(), ColorPrefs.MatlabColor.WARNING.getPreferredColor());
        syntaxPreviewPane.setValue(editorKit, ColorPrefs.MatlabColor.MLINT_AUTOFIX_BACKGROUND.getKey(), ColorPrefs.MatlabColor.MLINT_AUTOFIX_BACKGROUND.getPreferredColor());
        syntaxPreviewPane.setValue(editorKit, "ColorsUseMLintAutoFixBackground", ColorPrefs.isMLintAutoFixBackgroundEnabled());
        syntaxPreviewPane.setValue(editorKit, "Editor.VariableHighlighting.Color", VariableHighlightPrefs.getPreferredHighlightColor());
        syntaxPreviewPane.setValue(editorKit, "Editor.VariableHighlighting.Automatic", VariableHighlightPrefs.isAutoHighlighting());
        syntaxPreviewPane.setValue(editorKit, "Editor.NonlocalVariableHighlighting.TextColor", VariableHighlightPrefs.getPreferredNonlocalVariableTextColor());
        syntaxPreviewPane.setValue(editorKit, "Editor.NonlocalVariableHighlighting", VariableHighlightPrefs.isNonlocalVariableHighlightingEnabled());
        ((VariableHighlightingLayer)((MWEditorUI)syntaxPreviewPane.getEditorUI()).getLayer("Variable Highlighting Layer")).setAlwaysHighlight(true);
        return syntaxPreviewPane;
    }

    private static void drawDividers(SyntaxTextPane syntaxTextPane, boolean bl) {
        int[] nArray;
        if (bl) {
            int[] nArray2 = new int[3];
            nArray2[0] = 1;
            nArray2[1] = 4;
            nArray = nArray2;
            nArray2[2] = 10;
        } else {
            nArray = ArrayUtils.EMPTY_INT_ARRAY;
        }
        syntaxTextPane.setDrawAboveLines(nArray);
    }

    private static void highlightCell(SyntaxTextPane syntaxTextPane, boolean bl) {
        int[] nArray;
        if (bl) {
            int[] nArray2 = new int[6];
            nArray2[0] = 4;
            nArray2[1] = 5;
            nArray2[2] = 6;
            nArray2[3] = 7;
            nArray2[4] = 8;
            nArray = nArray2;
            nArray2[5] = 9;
        } else {
            nArray = ArrayUtils.EMPTY_INT_ARRAY;
        }
        syntaxTextPane.setHighlightedLines(nArray);
    }

    private SyntaxHighlightingColorPanel createCodeAnalyzerOptions() {
        SyntaxHighlightingColorPanel syntaxHighlightingColorPanel = new SyntaxHighlightingColorPanel(BUNDLE.getString("colors.codetools.codeAnalyzerTitle"));
        this.addLabelItem(syntaxHighlightingColorPanel, BUNDLE.getString("colors.codetools.warning"), ColorPrefs.MatlabColor.WARNING.getKey(), ColorPrefs.MatlabColor.WARNING.getPreferredColor());
        this.fAutoFix = this.addCheckBoxItem(syntaxHighlightingColorPanel, BUNDLE.getString("colors.codetools.mlintAutoFixBackground"), "ColorsMLintAutoFixBackground", ColorPrefs.getColorPref((String)"ColorsMLintAutoFixBackground"), "ColorsUseMLintAutoFixBackground", ColorPrefs.isMLintAutoFixBackgroundEnabled());
        return syntaxHighlightingColorPanel;
    }

    private MJCheckBox addCheckBoxItem(SyntaxHighlightingColorPanel syntaxHighlightingColorPanel, String string, String string2, Color color, String string3, boolean bl) {
        return this.addCheckBoxItem(syntaxHighlightingColorPanel, string, string2, color, string3, bl, true);
    }

    private MJCheckBox addCheckBoxItem(SyntaxHighlightingColorPanel syntaxHighlightingColorPanel, String string, String string2, Color color, String string3, boolean bl, boolean bl2) {
        ColorItem<MJCheckBox> colorItem = syntaxHighlightingColorPanel.addCheckBoxColorItem(string, string2, color, new ColorPickerActionListener(string2), bl2);
        MJCheckBox mJCheckBox = colorItem.getComponent();
        mJCheckBox.setSelected(bl);
        mJCheckBox.addActionListener((ActionListener)new CheckBoxActionListener(string3));
        return mJCheckBox;
    }

    private void addLabelItem(SyntaxHighlightingColorPanel syntaxHighlightingColorPanel, String string, String string2, Color color) {
        syntaxHighlightingColorPanel.addLabelItem(string, string2, color, new ColorPickerActionListener(string2));
    }

    private SyntaxHighlightingColorPanel createVariableHighlightOptions() {
        SyntaxHighlightingColorPanel syntaxHighlightingColorPanel = new SyntaxHighlightingColorPanel(BUNDLE.getString("colors.codetools.variableHighlightTitle"));
        this.fAutoHighlight = this.addCheckBoxItem(syntaxHighlightingColorPanel, BUNDLE.getString("colors.codetools.highlightVariable"), "Editor.VariableHighlighting.Color", VariableHighlightPrefs.getPreferredHighlightColor(), "Editor.VariableHighlighting.Automatic", VariableHighlightPrefs.isAutoHighlighting(), false);
        this.fAutoHighlight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProgrammingToolsColorPrefsPanel.this.setVariableHighlightLabel();
            }
        });
        this.fNestedVarHighlight = this.addCheckBoxItem(syntaxHighlightingColorPanel, BUNDLE.getString("colors.codetools.nonlocalVar"), "Editor.NonlocalVariableHighlighting.TextColor", VariableHighlightPrefs.getPreferredNonlocalVariableTextColor(), "Editor.NonlocalVariableHighlighting", VariableHighlightPrefs.isNonlocalVariableHighlightingEnabled());
        this.fVariableExplain = syntaxHighlightingColorPanel.addLabel(" ");
        this.setVariableHighlightLabel();
        return syntaxHighlightingColorPanel;
    }

    private void setVariableHighlightLabel() {
        this.fVariableExplain.setText(this.fAutoHighlight.isSelected() || VariableHighlightActions.getHighlightKeystroke().isEmpty() ? " " : MessageFormat.format(BUNDLE.getString("colors.codetools.variableExplanation"), VariableHighlightActions.getHighlightKeystroke()));
    }

    private SyntaxHighlightingColorPanel createCellOptions() {
        SyntaxHighlightingColorPanel syntaxHighlightingColorPanel = new SyntaxHighlightingColorPanel(BUNDLE.getString("colors.codetools.CodepadDisplay"));
        ColorItem<MJCheckBox> colorItem = syntaxHighlightingColorPanel.addCheckBoxColorItem(BUNDLE.getString("colors.codetools.CodepadShowHighlighting"), "Editorhighlight-lines", CodepadOptions.getHighlightingColor(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColorPicker colorPicker = (ColorPicker)actionEvent.getSource();
                Color color = (Color)colorPicker.getValue();
                SettingsAdapter.setColoring((Object)STPPrefsManager.getInstance(), ProgrammingToolsColorPrefsPanel.this.fPreviewPane.getEditorKit().getClass(), (String)"highlight-lines", (Object)new Coloring(null, null, color));
            }
        });
        this.fCellHighlight = colorItem.getComponent();
        this.fCellHighlight.setSelected(CodepadOptions.isCodepadHighlightingOn());
        this.fCellHighlight.addActionListener((ActionListener)new CheckBoxActionListener("EditorCodepadHighVisible"));
        this.fCellHighlight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProgrammingToolsColorPrefsPanel.highlightCell(ProgrammingToolsColorPrefsPanel.this.fPreviewPane, ProgrammingToolsColorPrefsPanel.this.fCellHighlight.isSelected());
            }
        });
        this.fShowDividers = syntaxHighlightingColorPanel.addCheckBox(BUNDLE.getString("colors.codetools.CodepadShowCellDividers"), "EditorCodeBlockDividers");
        this.fShowDividers.addActionListener((ActionListener)new CheckBoxActionListener("EditorCodeBlockDividers"));
        this.fShowDividers.setSelected(CodepadOptions.isCodeDividersOn());
        this.fShowDividers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProgrammingToolsColorPrefsPanel.drawDividers(ProgrammingToolsColorPrefsPanel.this.fPreviewPane, ProgrammingToolsColorPrefsPanel.this.fShowDividers.isSelected());
            }
        });
        return syntaxHighlightingColorPanel;
    }

    public void layoutPanel() {
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("f:p:grow", "p,p,p,p,p");
        this.setLayout((LayoutManager)formLayout);
        this.add((Component)((Object)this.fCodeAnalyzerOptions), cellConstraints.xy(1, 1));
        this.add((Component)((Object)this.fVariableHighlighting), cellConstraints.xy(1, 2));
        this.add((Component)((Object)this.fCellOptions), cellConstraints.xy(1, 3));
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel.add((Component)((Object)this.fPreviewPane), (Object)"Center");
        mJPanel.setBorder((Border)BorderFactory.createTitledBorder(BUNDLE.getString("gpcp.sample")));
        mJPanel.add(this.fPreviewPane.getDisplayComponent());
        this.add((Component)mJPanel, cellConstraints.xy(1, 4));
        this.add(this.createRestoreDefaultsPanel(), cellConstraints.xy(1, 5));
    }

    private Component createRestoreDefaultsPanel() {
        MJButton mJButton = new MJButton(BUNDLE.getString("colors.codetools.restoreDefaults"));
        mJButton.setName(RESTORE_DEFAULTS_BUTTON_NAME);
        mJButton.addActionListener((ActionListener)new RestoreDefaultsActionListener());
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel.add(Box.createHorizontalGlue(), (Object)"Center");
        mJPanel.add((Component)mJButton, (Object)"East");
        return mJPanel;
    }

    public void commitChanges(PrefsNode prefsNode) {
        ColorPrefs.setColorPref((String)this.fCodeAnalyzerOptions.getPrefsKey(0), (Color)this.fCodeAnalyzerOptions.getColor(0));
        ColorPrefs.notifyColorListeners((String)"Colors_M_");
        ColorPrefs.setMLintAutoFixBackgroundEnabled((boolean)this.fAutoFix.isSelected());
        ColorPrefs.setColorPref((String)this.fCodeAnalyzerOptions.getPrefsKey(1), (Color)this.fCodeAnalyzerOptions.getColor(1));
        ColorPrefs.notifyColorListeners((String)"ColorsMLintAutoFixBackground");
        ColorPrefs.setColorPref((String)this.fVariableHighlighting.getPrefsKey(0), (Color)this.fVariableHighlighting.getColor(0));
        VariableHighlightPrefs.setAutoHighlighting((boolean)this.fAutoHighlight.isSelected());
        ColorPrefs.setColorPref((String)this.fVariableHighlighting.getPrefsKey(1), (Color)this.fVariableHighlighting.getColor(1));
        VariableHighlightPrefs.setNonlocalVariableHighlightingEnabled((boolean)this.fNestedVarHighlight.isSelected());
        CodepadOptions.setCodepadDisplayOptions((boolean)this.fCellHighlight.isSelected(), (Color)this.fCellOptions.getColor(0), (boolean)this.fShowDividers.isSelected());
    }

    public boolean validateChanges(PrefsNode prefsNode) {
        return true;
    }

    public void cancelChanges(PrefsNode prefsNode) {
    }

    public boolean canDetectPendingEdits(PrefsNode prefsNode) {
        return false;
    }

    public boolean hasPendingEdits(PrefsNode prefsNode) {
        assert (false) : "should not be called because canDetectPendingEdits is false";
        return true;
    }

    public JComponent getComponent(PrefsNode prefsNode) {
        return this;
    }

    public PrefsHelp getHelp() {
        return new PrefsHelp(MLHelpServices.getMapfileName((String)"matlab", (String)"matlab_env"), "matlab_env_colors_tools_prefs");
    }

    public void doHelp() {
        PrefsHelp prefsHelp = this.getHelp();
        MLHelpServices.displayTopic((String)prefsHelp.getHelpMapPath(), (String)prefsHelp.getHelpTopicKey());
    }

    public void dispose() {
        this.fPreviewPane.cleanup();
    }

    private class CheckBoxActionListener
    extends PreviewListener {
        private CheckBoxActionListener(String string) {
            super(string);
        }

        @Override
        protected Object getValue(Object object) {
            return ((AbstractButton)object).isSelected();
        }
    }

    private class ColorPickerActionListener
    extends PreviewListener {
        private ColorPickerActionListener(String string) {
            super(string);
        }

        @Override
        protected Object getValue(Object object) {
            return ((DropdownButton)object).getValue();
        }
    }

    private abstract class PreviewListener
    implements ActionListener {
        private final String iPrefKey;

        protected PreviewListener(String string) {
            this.iPrefKey = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ProgrammingToolsColorPrefsPanel.this.fPreviewPane.setValue(ProgrammingToolsColorPrefsPanel.this.fPreviewPane.getEditorKit(), this.iPrefKey, this.getValue(actionEvent.getSource()));
            ProgrammingToolsColorPrefsPanel.this.repaint();
        }

        protected abstract Object getValue(Object var1);
    }

    private class RestoreDefaultsActionListener
    implements ActionListener {
        private RestoreDefaultsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ProgrammingToolsColorPrefsPanel.this.fCodeAnalyzerOptions.setColor(0, ColorPrefs.MatlabColor.WARNING.getDefaultColor());
            ProgrammingToolsColorPrefsPanel.this.fCodeAnalyzerOptions.setColor(1, ColorPrefs.MatlabColor.MLINT_AUTOFIX_BACKGROUND.getDefaultColor());
            this.restoreCheckBox((JCheckBox)ProgrammingToolsColorPrefsPanel.this.fAutoFix, ColorPrefs.getDefaultMLintAutoFixBackgroundEnabled());
            ProgrammingToolsColorPrefsPanel.this.fVariableHighlighting.setColor(0, VariableHighlightPrefs.DEFAULT_VAR_HIGHLIGHT_COLOR);
            this.restoreCheckBox((JCheckBox)ProgrammingToolsColorPrefsPanel.this.fAutoHighlight, true);
            ProgrammingToolsColorPrefsPanel.this.fVariableHighlighting.setColor(1, VariableHighlightPrefs.NONLOCAL_VAR_TEXT_COLOR_DEFAULT);
            this.restoreCheckBox((JCheckBox)ProgrammingToolsColorPrefsPanel.this.fNestedVarHighlight, true);
            ProgrammingToolsColorPrefsPanel.this.fCellOptions.setColor(0, CodepadOptions.getDefaultHighlightingColor());
            this.restoreCheckBox((JCheckBox)ProgrammingToolsColorPrefsPanel.this.fCellHighlight, true);
            this.restoreCheckBox((JCheckBox)ProgrammingToolsColorPrefsPanel.this.fShowDividers, true);
        }

        private void restoreCheckBox(JCheckBox jCheckBox, boolean bl) {
            if (jCheckBox.isSelected() ^ bl) {
                jCheckBox.doClick();
            }
        }
    }
}

