/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.prefs;

import com.mathworks.jmi.AWTUtilities;
import com.mathworks.mlservices.MLPrefsDialog;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mlwidgets.prefs.PrefsDialogRegistrar;
import com.mathworks.mlwidgets.prefs.PrefsPanelWrapper;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.util.Log;
import com.mathworks.util.ReturnRunnable;
import com.mathworks.widgets.desk.Desktop;
import com.mathworks.widgets.prefs.DefaultPrefsPanelFactory;
import com.mathworks.widgets.prefs.GenericPrefsDialog;
import com.mathworks.widgets.prefs.PrefsEditorPanelFactory;
import com.mathworks.widgets.prefs.PrefsEditorPanelV1;
import com.mathworks.widgets.prefs.PrefsModel;
import com.mathworks.widgets.prefs.PrefsNode;
import com.mathworks.widgets.prefs.PrefsUtils;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComponent;

public class PrefsDialog
implements MLPrefsDialog {
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.mlwidgets.prefs.resources.RES_Prefs");
    private PrefsModel fModel;
    private PrefsDialogFrame fFrame;
    private final Set<String> fRegistered = new TreeSet<String>();
    private static PrefsDialog sPrefsDialog;
    private static PrefsNode sLastArea;

    private void initialize() {
        boolean bl = false;
        if (this.fModel == null) {
            this.fModel = new PrefsModel();
            bl = true;
        }
        if (this.fFrame == null) {
            Desktop desktop = MatlabDesktopServices.getDesktop();
            this.fFrame = desktop != null ? new PrefsDialogFrame((MJFrame)desktop.getMainFrame()) : new PrefsDialogFrame();
            this.fFrame.getWindow().addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent windowEvent) {
                    sLastArea = PrefsDialog.this.fFrame.getNavigator().getSelectedNode();
                    PrefsDialog.this.fFrame = null;
                }
            });
        }
        if (bl) {
            PrefsDialogRegistrar.preRegisterPanels(this);
        }
    }

    public void showPrefsDialog() {
        this.showPrefsDialog(sLastArea);
    }

    public void showPrefsDialog(String string) {
        this.doShowPrefsDialog(string);
    }

    public void showLastPrefsDialog(String string) {
        ToFrontRunnable toFrontRunnable = new ToFrontRunnable();
        if (EventQueue.isDispatchThread()) {
            toFrontRunnable.run();
        } else {
            try {
                AWTUtilities.invokeAndWait((Runnable)toFrontRunnable);
            }
            catch (Throwable throwable) {
                Log.logThrowable((Throwable)throwable);
            }
        }
        if (!toFrontRunnable.iBroughtToFront) {
            if (sLastArea != null) {
                this.showPrefsDialog(sLastArea);
            } else {
                this.showPrefsDialog(string);
            }
        }
    }

    private void showPrefsDialog(final PrefsNode prefsNode) {
        this.showPrefsDialog(new NodeFinder(){

            @Override
            public PrefsNode findNode() {
                return prefsNode;
            }
        });
    }

    private void doShowPrefsDialog(final String string) {
        this.showPrefsDialog(new NodeFinder(){

            @Override
            public PrefsNode findNode() {
                PrefsNode prefsNode = PrefsDialog.this.findNode(string);
                if (prefsNode == null) {
                    prefsNode = PrefsDialog.this.findNode(sRes.getString("area.general"));
                }
                return prefsNode;
            }
        });
    }

    private void showPrefsDialog(final NodeFinder nodeFinder) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                PrefsDialog.this.initialize();
                PrefsDialog.this.fFrame.getWindow().setVisible(true);
                PrefsDialog.this.fFrame.getWindow().toFront();
                PrefsNode prefsNode = nodeFinder.findNode();
                if (prefsNode != null) {
                    PrefsDialog.this.fFrame.getNavigator().show(prefsNode);
                }
            }
        };
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            try {
                AWTUtilities.invokeAndWait((Runnable)runnable);
            }
            catch (Throwable throwable) {
                Log.logThrowable((Throwable)throwable);
            }
        }
    }

    private PrefsNode findNode(String string) {
        assert (this.fModel != null) : "model cannot be null -- initialize not called";
        if (string == null) {
            return null;
        }
        return PrefsUtils.findByDelimitedPath((PrefsModel)this.fModel, (String)string, (String)".");
    }

    private PrefsNode findParent(String string) {
        assert (this.fModel != null) : "model cannot be null -- initialize not called";
        return PrefsUtils.findParentByDelimitedPath((PrefsModel)this.fModel, (String)string, (String)".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPanel(String string, String string2) throws ClassNotFoundException {
        this.initialize();
        Set<String> set = this.fRegistered;
        synchronized (set) {
            String string3;
            DefaultPrefsPanelFactory defaultPrefsPanelFactory;
            boolean bl;
            Class<?> clazz;
            if (this.fRegistered.contains(string)) {
                return;
            }
            Constructor<?> constructor = null;
            try {
                clazz = Class.forName(string2);
                bl = PrefsEditorPanelV1.class.isAssignableFrom(clazz);
                if (bl) {
                    constructor = clazz.getConstructor(Dimension.class);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalArgumentException(string2 + " must have a constructor taking a Dimension");
            }
            if (bl) {
                defaultPrefsPanelFactory = new DefaultPrefsPanelFactory(clazz, constructor, new Object[]{this.fFrame.getContainer().getClientSize()});
            } else {
                try {
                    defaultPrefsPanelFactory = new DefaultPrefsPanelFactory(PrefsPanelWrapper.class, PrefsPanelWrapper.class.getConstructor(String.class, ReturnRunnable.class), new Object[]{string2, new ReturnRunnable<Dimension>(){

                        public Dimension run() {
                            return PrefsDialog.this.fFrame.getContainer().getClientSize();
                        }
                    }});
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new IllegalStateException();
                }
            }
            PrefsNode prefsNode = this.fModel.getRoot();
            String string4 = string;
            int n = string.indexOf(".");
            if (n >= 0) {
                string3 = string.substring(0, n);
                string4 = string.substring(n + 1);
                prefsNode = this.findNode(string3);
            }
            string3 = new PrefsNode(prefsNode, string4, null, (PrefsEditorPanelFactory)defaultPrefsPanelFactory);
            prefsNode.addChild((PrefsNode)string3);
            this.fRegistered.add(string);
        }
        this.fFrame.refresh();
    }

    public void unregisterPanel(String string, String string2) {
        PrefsNode prefsNode = this.findNode(string);
        if (prefsNode != null) {
            PrefsNode prefsNode2 = this.findParent(string);
            prefsNode2.removeChild(prefsNode);
        }
    }

    static MLPrefsDialog getMLPrefsDialog() {
        if (sPrefsDialog == null) {
            sPrefsDialog = new PrefsDialog();
        }
        return sPrefsDialog;
    }

    private class PrefsDialogFrame
    extends GenericPrefsDialog {
        PrefsDialogFrame() {
            this(null);
        }

        PrefsDialogFrame(MJFrame mJFrame) {
            super(GenericPrefsDialog.Type.FRAME, sRes.getString("dialog.title"), PrefsDialog.this.fModel, mJFrame);
            this.getWindow().setName("PreferencesWindow");
            this.getTree().getAccessibleContext().setAccessibleName(sRes.getString("prefsdialog.acc.tree"));
            this.getTree().setName("Preference Panel Tree");
        }

        public JComponent getTree() {
            return this.getNavigator().getComponent();
        }
    }

    private static interface NodeFinder {
        public PrefsNode findNode();
    }

    private class ToFrontRunnable
    implements Runnable {
        boolean iBroughtToFront;

        private ToFrontRunnable() {
        }

        @Override
        public void run() {
            if (PrefsDialog.this.fFrame != null && PrefsDialog.this.fFrame.getWindow().isVisible()) {
                PrefsDialog.this.fFrame.getWindow().toFront();
                this.iBroughtToFront = true;
            }
        }
    }
}

