/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.prefs;

import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.util.productinfo.ProductInfoUtils;
import com.mathworks.mwswing.DefaultSortableTable;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJMultilineLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTable;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.table.AccessibleTextProvider;
import com.mathworks.mwswing.table.ListColorUtils;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class ConfirmationDialogPrefsPanel
extends MJPanel {
    public static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com.mathworks.mlwidgets.prefs.resources.RES_Prefs");
    private static final int COLUMN_MARGIN = 20;
    private static ConfirmationDialogPrefsPanel sPrefsPanel = null;
    private static final List<DialogItem> sDialogItems = new Vector<DialogItem>();
    private static MyPrefsListener sPrefsListener;
    private static boolean sSaving;
    private final MyTableModel fModel;
    private final DefaultSortableTable fTable;

    private ConfirmationDialogPrefsPanel(Dimension dimension) {
        this.setPreferredSize(dimension);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.setName("ConfirmationDialogPrefsPanel");
        MJMultilineLabel mJMultilineLabel = new MJMultilineLabel(BUNDLE.getString("label.helpfulinfo"), true);
        mJMultilineLabel.setBorder((Border)new EmptyBorder(0, 4, 4, 0));
        mJMultilineLabel.setMaxWidth(dimension.width);
        mJMultilineLabel.setName("desc label");
        mJMultilineLabel.getAccessibleContext().setAccessibleName(BUNDLE.getString("label.helpfulinfo"));
        this.fModel = new MyTableModel(sDialogItems);
        this.fTable = new DefaultSortableTable((TableModel)this.fModel);
        this.fTable.setRowSelectionAllowed(true);
        this.fTable.setColumnSelectionAllowed(false);
        this.fTable.setCellViewerEnabled(true);
        this.fTable.sortByColumn(2, 0);
        TableCellRenderer tableCellRenderer = this.fTable.getTableHeader().getDefaultRenderer();
        ConfirmationDialogPrefsPanel.setColumnSize(this.fTable.getColumnModel().getColumn(0), this.fTable, tableCellRenderer, 40);
        ConfirmationDialogPrefsPanel.setColumnSize(this.fTable.getColumnModel().getColumn(1), this.fTable, tableCellRenderer, 350);
        ConfirmationDialogPrefsPanel.setColumnSize(this.fTable.getColumnModel().getColumn(2), this.fTable, tableCellRenderer, 150);
        ListColorUtils.setupForList((JTable)this.fTable);
        ListColorUtils.installListRenderer((JTable)this.fTable);
        this.fTable.getColumnModel().getColumn(0).setCellRenderer(new CheckBoxRenderer());
        this.fTable.getColumnModel().getColumn(0).setCellEditor(new CheckBoxEditor());
        this.fTable.setAccessibleTextProvider(this.createAccessibilityTextProvider());
        this.fTable.setShowGrid(false);
        this.fTable.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "toggle");
        this.fTable.getActionMap().put("toggle", (Action)((Object)new ToggleAction()));
        MJScrollPane mJScrollPane = new MJScrollPane((Component)this.fTable);
        mJScrollPane.setHorizontalScrollBarPolicy(30);
        mJScrollPane.getViewport().setBackground(this.fTable.getBackground());
        this.fTable.setName("warning table");
        this.fTable.getAccessibleContext().setAccessibleName(BUNDLE.getString("table.acc.desc"));
        this.fTable.getTableHeader().setToolTipText(BUNDLE.getString("table.headertooltip"));
        MJPanel mJPanel = new MJPanel();
        MJButton mJButton = new MJButton((Action)((Object)new ClearAllAction()));
        mJButton.setName("clear button");
        mJButton.getAccessibleContext().setAccessibleName(MJUtilities.exciseAmpersand((String)BUNDLE.getString("button.clear")));
        MJButton mJButton2 = new MJButton((Action)((Object)new SelectAllAction()));
        mJButton2.setName("select button");
        mJButton2.getAccessibleContext().setAccessibleName(MJUtilities.exciseAmpersand((String)BUNDLE.getString("button.select")));
        mJPanel.add((Component)mJButton2);
        mJPanel.add((Component)mJButton);
        this.fTable.setRowSelectionInterval(0, 0);
        this.setOpaque(true);
        this.add((Component)mJMultilineLabel, "North");
        this.add((Component)mJScrollPane, "Center");
        this.add((Component)mJPanel, "South");
        if (sPrefsListener == null) {
            this.initPrefs();
        }
    }

    private AccessibleTextProvider createAccessibilityTextProvider() {
        return new AccessibleTextProvider(){

            public String getAccessibleText(int n, int n2) {
                String string = (String)ConfirmationDialogPrefsPanel.this.fTable.getValueAt(n, 1);
                String string2 = (String)ConfirmationDialogPrefsPanel.this.fTable.getValueAt(n, 2);
                boolean bl = (Boolean)ConfirmationDialogPrefsPanel.this.fTable.getValueAt(n, 0);
                return string + " in category " + string2 + " is " + (bl ? "checked" : "not checked");
            }
        };
    }

    private static void setColumnSize(TableColumn tableColumn, DefaultSortableTable defaultSortableTable, TableCellRenderer tableCellRenderer, int n) {
        Component component = tableCellRenderer.getTableCellRendererComponent((JTable)defaultSortableTable, tableColumn.getHeaderValue(), false, false, -1, -1);
        int n2 = component.getPreferredSize().width + 20;
        tableColumn.setPreferredWidth(n2 < n ? n : n2);
        tableColumn.setWidth(tableColumn.getPreferredWidth());
    }

    private static void getDataFromProducts() {
        Vector<String> vector = ProductInfoUtils.getDialogPanelRegistrants();
        for (String string : vector) {
            Object object = ConfirmationDialogPrefsPanel.callClassMethod(string, "getDialogItems");
            if (!(object instanceof DialogItem[])) continue;
            sDialogItems.addAll(Arrays.asList((DialogItem[])object));
        }
    }

    private static Object callClassMethod(String string, String string2) {
        Object object;
        block2: {
            object = null;
            try {
                Class<?> clazz = Class.forName(string);
                Method method = clazz.getMethod(string2, new Class[0]);
                object = method.invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)exception);
            }
        }
        return object;
    }

    static ConfirmationDialogPrefsPanel getPanel() {
        return sPrefsPanel;
    }

    public static void commitPrefsChanges(boolean bl) {
        sSaving = true;
        if (bl && sPrefsPanel != null) {
            for (DialogItem dialogItem : sDialogItems) {
                dialogItem.saveState();
            }
        }
        sSaving = false;
    }

    public static MJPanel createPrefsPanel(Dimension dimension) {
        if (sPrefsPanel != null) {
            sPrefsPanel = null;
        } else {
            ConfirmationDialogPrefsPanel.getDataFromProducts();
        }
        ConfirmationDialogPrefsPanel.updateStateOfItems();
        sPrefsPanel = new ConfirmationDialogPrefsPanel(dimension);
        return sPrefsPanel;
    }

    private static void updateStateOfItems() {
        for (DialogItem dialogItem : sDialogItems) {
            dialogItem.setState(dialogItem.getStateFromPrefs());
        }
    }

    public static void addDialogItem(String string, String string2, String string3, boolean bl) {
        sDialogItems.add(new DialogItem(string2, string3, string, bl));
    }

    public static void removeItem(String string) {
        for (int i = 0; i < sDialogItems.size(); ++i) {
            if (!sDialogItems.get(i).getPrefKey().equals(string)) continue;
            sDialogItems.remove(i);
            return;
        }
    }

    public static void addDialogItems(DialogItem[] dialogItemArray) {
        sDialogItems.addAll(Arrays.asList(dialogItemArray));
    }

    public static String[] getHelpInfo() {
        return new String[]{MLHelpServices.getMapfileName((String)"matlab", (String)"matlab_env"), "matlab_env_confdialog_prefs"};
    }

    private static JCheckBox formatCheckboxCell(JTable jTable, boolean bl, int n, Object object, JCheckBox jCheckBox) {
        jCheckBox.setForeground(ListColorUtils.getListForegroundColor((JTable)jTable, (boolean)bl, (boolean)jTable.hasFocus()));
        jCheckBox.setBackground(ListColorUtils.getListAlternatingBackgroundColor((JTable)jTable, (int)n, (boolean)bl, (boolean)jTable.hasFocus()));
        jCheckBox.setSelected(object != null && (Boolean)object != false);
        return jCheckBox;
    }

    private void initPrefs() {
        sPrefsListener = new MyPrefsListener();
        for (DialogItem dialogItem : sDialogItems) {
            Prefs.addListener((PrefListener)sPrefsListener, (String)dialogItem.getPrefKey());
        }
    }

    public static List<DialogItem> getDialogItems() {
        return Collections.unmodifiableList(sDialogItems);
    }

    public static int getNumItems() {
        return sDialogItems.size();
    }

    public static MJTable getTable() {
        return ConfirmationDialogPrefsPanel.sPrefsPanel.fTable;
    }

    public static TableModel getModel() {
        return ConfirmationDialogPrefsPanel.sPrefsPanel.fModel;
    }

    static {
        sSaving = false;
    }

    private class MyPrefsListener
    implements PrefListener {
        private MyPrefsListener() {
        }

        public void prefChanged(PrefEvent prefEvent) {
            if (!sSaving) {
                ConfirmationDialogPrefsPanel.updateStateOfItems();
                ConfirmationDialogPrefsPanel.this.repaint();
            }
        }
    }

    private static class MyTableModel
    extends AbstractTableModel {
        private List<DialogItem> fData;

        MyTableModel(List<DialogItem> list) {
            this.fData = list;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.fData.size();
        }

        @Override
        public String getColumnName(int n) {
            return BUNDLE.getString("table.column" + (n + 1));
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.fData.get(n).getBooleanState();
            }
            if (n2 == 1) {
                return this.fData.get(n).getDescription();
            }
            return this.fData.get(n).getComponentName();
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                this.fData.get(n).setState(object);
            }
            this.fireTableCellUpdated(n, n2);
        }
    }

    private static class CheckBoxEditor
    extends DefaultCellEditor {
        CheckBoxEditor() {
            super(new JCheckBox());
            ((AbstractButton)this.getComponent()).setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            return ConfirmationDialogPrefsPanel.formatCheckboxCell(jTable, bl, n, object, (JCheckBox)this.getComponent());
        }
    }

    private static class CheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        CheckBoxRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return ConfirmationDialogPrefsPanel.formatCheckboxCell(jTable, bl, n, object, this);
        }
    }

    private class ToggleAction
    extends MJAbstractAction {
        private ToggleAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = ConfirmationDialogPrefsPanel.this.fTable.getSelectedRow();
            if (n == -1) {
                return;
            }
            ConfirmationDialogPrefsPanel.this.fTable.setValueAt((Object)((Boolean)ConfirmationDialogPrefsPanel.this.fTable.getValueAt(n, 0) == false ? 1 : 0), n, 0);
            ConfirmationDialogPrefsPanel.this.fTable.setRowSelectionInterval(n, n);
        }
    }

    private class SelectAllAction
    extends MJAbstractAction {
        SelectAllAction() {
            super(BUNDLE.getString("button.select"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            for (int i = 0; i < ConfirmationDialogPrefsPanel.this.fModel.getRowCount(); ++i) {
                ConfirmationDialogPrefsPanel.this.fModel.setValueAt(true, i, 0);
            }
        }
    }

    private class ClearAllAction
    extends MJAbstractAction {
        ClearAllAction() {
            super(BUNDLE.getString("button.clear"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            for (int i = 0; i < ConfirmationDialogPrefsPanel.this.fModel.getRowCount(); ++i) {
                ConfirmationDialogPrefsPanel.this.fModel.setValueAt(false, i, 0);
            }
        }
    }

    public static class DialogItem {
        private final String iDesc;
        private final String iPrefKey;
        private final String iComp;
        private boolean iState;

        public DialogItem(String string, String string2, String string3, boolean bl) {
            this.iDesc = string;
            this.iPrefKey = string2;
            this.iComp = string3;
            this.iState = bl;
            if (!Prefs.exists((String)this.iPrefKey)) {
                this.saveState();
            }
            this.iState = this.getStateFromPrefs();
        }

        public String getDescription() {
            return this.iDesc;
        }

        public String getPrefKey() {
            return this.iPrefKey;
        }

        public String getComponentName() {
            return this.iComp;
        }

        private void saveState() {
            Prefs.setBooleanPref((String)this.iPrefKey, (boolean)this.iState);
        }

        void setState(Object object) {
            if (object instanceof Boolean) {
                this.iState = (Boolean)object;
            }
        }

        void setState(boolean bl) {
            this.iState = bl;
        }

        public boolean getStateFromPrefs() {
            return Prefs.getBooleanPref((String)this.iPrefKey, (boolean)this.iState);
        }

        public Boolean getBooleanState() {
            return this.iState;
        }
    }
}

