/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.inspector.celleditors.color;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import com.mathworks.mlwidgets.inspector.Resources;
import com.mathworks.mlwidgets.inspector.guiutils.ColorSpec;
import com.mathworks.mlwidgets.inspector.guiutils.InvalidInput;
import com.mathworks.util.Pair;
import com.mathworks.util.StyledColor;
import java.awt.Color;
import java.text.NumberFormat;
import org.apache.commons.lang.StringUtils;

public class MLColorConverter
implements ObjectConverter {
    private final boolean allowDefaultColor;
    private volatile NumberFormat formatter = NumberFormat.getNumberInstance();
    private static final String invalidColorStr = Resources.getBundle().getString("color.converter.invalidcolor");

    public MLColorConverter(boolean bl) {
        this.allowDefaultColor = bl;
        this.formatter.setMaximumFractionDigits(3);
        this.formatter.setMinimumFractionDigits(3);
        this.formatter.setMinimumIntegerDigits(1);
        this.formatter.setGroupingUsed(false);
    }

    public void setFormatter(NumberFormat numberFormat) {
        if (numberFormat == null) {
            throw new IllegalArgumentException("Argument formatter must not be null");
        }
        this.formatter = numberFormat;
    }

    public Object fromString(String string, ConverterContext converterContext) {
        StyledColor styledColor;
        boolean bl;
        String string2 = StringUtils.stripToNull((String)string);
        boolean bl2 = bl = converterContext != null && converterContext.getUserObject() instanceof StyledColor;
        if (string2 == null) {
            if (bl) {
                StyledColor styledColor2 = (StyledColor)converterContext.getUserObject();
                if (styledColor2.isStyleAllowed("none")) {
                    return new StyledColor("none", styledColor2.getAllowedStyles());
                }
                return new StyledColor(0.0, 0.0, 0.0, styledColor2.getAllowedStyles());
            }
            if (this.allowDefaultColor) {
                return null;
            }
            return new InvalidInput(this, string, invalidColorStr);
        }
        string2 = string2.toLowerCase();
        if (bl && (styledColor = (StyledColor)converterContext.getUserObject()).isStyleAllowed(string2)) {
            StyledColor styledColor3 = new StyledColor(styledColor.getFullStyleName(string2), styledColor.getAllowedStyles());
            return styledColor3;
        }
        if (StringUtils.contains((String)string2, (String)"none")) {
            if (!this.allowDefaultColor) {
                return new InvalidInput(this, string, invalidColorStr);
            }
            return null;
        }
        if (StringUtils.contains((String)string2, (String)((String)ColorHelper.customColor1.getFirst()))) {
            return ColorHelper.customColor1.getSecond();
        }
        boolean bl3 = true;
        if (StringUtils.contains((String)string2, (String)"rgb")) {
            bl3 = false;
            string2 = StringUtils.remove((String)string2, (String)"rgb");
        }
        boolean bl4 = false;
        boolean bl5 = false;
        if (StringUtils.contains((String)string2, (String)"dark")) {
            bl4 = true;
            string2 = StringUtils.remove((String)string2, (String)"dark");
            string2 = StringUtils.remove((String)string2, (String)"bright");
        } else if (StringUtils.contains((String)string2, (String)"bright")) {
            bl5 = true;
            string2 = StringUtils.remove((String)string2, (String)"bright");
            string2 = StringUtils.remove((String)string2, (String)"dark");
        }
        String[] stringArray = StringUtils.split((String)string2, (String)" ,;[]()=");
        if (stringArray == null || stringArray.length == 0) {
            return new InvalidInput(this, string, "");
        }
        Color color = null;
        try {
            color = ColorSpec.toColor(stringArray[0]);
            color = this.modifyColor(color, bl4, bl5);
            if (bl) {
                color = this.toStyledColor(color, converterContext);
            }
            return color;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            int n;
            float[] fArray = new float[3];
            int n2 = Math.min(stringArray.length, 3);
            try {
                for (n = 0; n < n2; ++n) {
                    String string3 = stringArray[n];
                    fArray[n] = Float.parseFloat(string3);
                    if (!(fArray[n] > 1.0f)) continue;
                    bl3 = false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                InvalidInput invalidInput = new InvalidInput(this, string, numberFormatException.getMessage());
                return invalidInput;
            }
            if (!bl3) {
                for (n = 0; n < fArray.length; ++n) {
                    fArray[n] = fArray[n] / 255.0f;
                }
            }
            try {
                color = new Color(fArray[0], fArray[1], fArray[2]);
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                return new InvalidInput(this, string, invalidColorStr);
            }
            color = this.modifyColor(color, bl4, bl5);
            if (bl) {
                color = this.toStyledColor(color, converterContext);
            }
            return color;
        }
    }

    private StyledColor toStyledColor(Color color, ConverterContext converterContext) {
        float[] fArray = color.getRGBColorComponents(null);
        StyledColor styledColor = new StyledColor((double)fArray[0], (double)fArray[1], (double)fArray[2], ((StyledColor)converterContext.getUserObject()).getAllowedStyles());
        return styledColor;
    }

    private Color modifyColor(Color color, boolean bl, boolean bl2) {
        Color color2 = color;
        if (bl) {
            color2 = color.darker();
        } else if (bl2) {
            color2 = color.brighter();
        }
        return color2;
    }

    public String toString(Object object, ConverterContext converterContext) {
        Object object2;
        if (object == null) {
            if (this.allowDefaultColor) {
                return "none";
            }
            return "";
        }
        if (object instanceof InvalidInput) {
            return ((InvalidInput)object).getInput().toString();
        }
        assert (object instanceof Color) : object;
        boolean bl = object instanceof StyledColor;
        if (bl && (object2 = (StyledColor)object).isStyle()) {
            return object2.getStyleName();
        }
        object2 = (Color)object;
        float[] fArray = ((Color)object2).getRGBColorComponents(null);
        assert (fArray != null && fArray.length == 3);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("  [");
        stringBuilder.append(this.formatter.format(fArray[0])).append(",  ").append(this.formatter.format(fArray[1])).append(",  ").append(this.formatter.format(fArray[2]));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public boolean supportFromString(String string, ConverterContext converterContext) {
        return true;
    }

    public boolean supportToString(Object object, ConverterContext converterContext) {
        assert (object == null || object instanceof Color) : object.getClass().getName();
        return true;
    }

    private static final class ColorHelper {
        private static final char[] data = new char[]{'s', 'f', 'h', 'u', 'i', 'c', 't', 'k'};
        static final Pair<String, Color> customColor1 = new Pair((Object)new String(new char[]{data[0], data[2], data[4], data[6]}), (Object)new Color(0.376f, 0.184f, 0.047f));

        private ColorHelper() {
        }
    }
}

