/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.mlwidgets.importtool.AbstractFileTableModel;
import com.mathworks.mlwidgets.importtool.DateParsingRule;
import com.mathworks.mlwidgets.importtool.ImportClient;
import com.mathworks.mlwidgets.importtool.NonNumericReplacementRule;
import com.mathworks.mlwidgets.importtool.ParseRule;
import com.mathworks.mlwidgets.importtool.SpreadsheetDataSection;
import com.mathworks.mlwidgets.importtool.TextImportUIState;
import com.mathworks.mlwidgets.importtool.TextSpreadsheetDataSection;
import com.mathworks.mlwidgets.importtool.TextscanTextParser;
import com.mathworks.mlwidgets.importtool.WorksheetRule;
import com.mathworks.util.Log;
import com.mathworks.util.Pair;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;

public class TextFileTableModel
extends AbstractFileTableModel {
    private File fFile;
    private volatile TextscanTextParser fTextParser;
    private TextscanTextParser.ColumnMetaData fColumnMetaData;
    public static final int[] NONWINDOWED_TEXTSIZE = new int[]{2000, 100};

    public void setFixedWidth(boolean bl) {
        this.fTextParser.setFixedWidth(bl);
        if (this.fColumnMetaData != null) {
            this.fColumnMetaData.setValid(false);
        }
        this.fTemporaryBlockCache = null;
        this.fBlockCache.clear();
        this.fTableStructureInitialized = false;
    }

    void cleanup() {
        if (this.fTextParser != null) {
            this.fTextParser.cleanup();
        }
    }

    @Override
    protected void rebuild(final int n, final int n2) {
        this.fTableStructureInitialized = false;
        if (this.fColumnMetaData != null) {
            this.fColumnMetaData.setValid(false);
        }
        MatlabWorker<double[]> matlabWorker = new MatlabWorker<double[]>(){

            public double[] runOnMatlabThread() {
                return TextFileTableModel.getSheetDimensions(TextFileTableModel.this.getTextParser());
            }

            public void runOnAWTEventDispatchThread(double[] dArray) {
                if (dArray == null) {
                    return;
                }
                if (dArray.length != 4) {
                    return;
                }
                int[] nArray = new int[]{(int)(dArray[1] + dArray[0]) - 1, (int)(dArray[3] + dArray[2]) - 1};
                int[] nArray2 = new int[]{(int)dArray[0] - 1, (int)dArray[2] - 1};
                if (TextFileTableModel.this.fDimensions[0] != nArray[0] || TextFileTableModel.this.fDimensions[1] != nArray[1] || TextFileTableModel.this.fStartCell[0] != nArray2[0] || TextFileTableModel.this.fStartCell[1] != nArray2[1]) {
                    TextFileTableModel.this.fDimensions[0] = 0;
                    TextFileTableModel.this.fDimensions[1] = 0;
                    TextFileTableModel.this.fStartCell[0] = 0;
                    TextFileTableModel.this.fStartCell[1] = 0;
                    TextFileTableModel.this.fTableStructureInitialized = false;
                    TextFileTableModel.this.fTemporaryBlockCache = null;
                } else {
                    TextFileTableModel.this.fTemporaryBlockCache = TextFileTableModel.this.getClosestSpreadsheetDataSection(n, n2);
                }
                TextFileTableModel.this.fCurrentMatlabBlock = null;
                TextFileTableModel.this.fBlockCache.clear();
                Point point = TextFileTableModel.this.getPointForIndices(n < 0 ? 0 : n, n2 < 0 ? 0 : n2);
                TextFileTableModel.this.requestValueFromMatlab(point.x + 1, point.y + 1, point.x + TextFileTableModel.this.ROWBLOCKSIZE, point.y + TextFileTableModel.this.COLUMNBLOCKSIZE);
            }
        };
        matlabWorker.start();
    }

    @Override
    Object[] importData(String[] stringArray, String[] stringArray2, String string, String[][] stringArray3, int n) throws Exception {
        return (Object[])Matlab.mtFeval((String)"ImportData", (Object[])new Object[]{this.fTextParser.fTextFileImporterMCOS, stringArray, stringArray2, string, stringArray3, n, this.fColumnMetaData.getParseRules(this.fTargetType).toArray(new ParseRule[1]), this.fRules.toArray()}, (int)2);
    }

    @Override
    Integer getTopHeaderRow() {
        if (this.fColumnMetaData == null) {
            return -1;
        }
        return this.fColumnMetaData.getHeaderRow();
    }

    @Override
    void setHeaderRow(final int n) {
        if (this.fColumnMetaData == null) {
            return;
        }
        int n2 = this.fColumnMetaData.getHeaderRow();
        this.fColumnMetaData.setHeaderRow(n);
        if (n2 != n && Matlab.isMatlabAvailable()) {
            MatlabWorker<Object> matlabWorker = new MatlabWorker<Object>(){

                public Object runOnMatlabThread() {
                    TextFileTableModel.this.fColumnMetaData.updateDefaultColumnVariableNames(TextFileTableModel.this.fTextParser, n);
                    return null;
                }

                public void runOnAWTEventDispatchThread(Object object) {
                    TextFileTableModel.this.fireTableChanged(new TableModelEvent(TextFileTableModel.this));
                }
            };
            matlabWorker.start();
        }
    }

    protected List<ParseRule> getColumnParseRules() {
        if (this.fColumnMetaData == null) {
            return null;
        }
        List<ParseRule> list = this.fColumnMetaData.getParseRules(this.fTargetType);
        for (int i = list.size(); i < this.getColumnCount(); ++i) {
            list.add(list.get(list.size() - 1));
        }
        return list;
    }

    protected List<DateParsingRule[]> getDateParsingRules() {
        if (this.fColumnMetaData == null) {
            return null;
        }
        List<DateParsingRule[]> list = this.fColumnMetaData.getDefaultDateParseRules();
        for (int i = list.size(); i < this.getColumnCount(); ++i) {
            list.add(list.get(list.size() - 1));
        }
        return list;
    }

    void setColumnParseRules(List<ParseRule> list) {
        this.fColumnMetaData.setParseRules(list);
    }

    File getFile() {
        return this.fFile;
    }

    public boolean canRead() {
        return this.fTextParser.canRead();
    }

    public TextFileTableModel(File file, List<WorksheetRule> list) {
        this.fFile = file;
        MatlabWorker<Object> matlabWorker = new MatlabWorker<Object>(){

            public TextscanTextParser runOnMatlabThread() {
                TextFileTableModel.this.fTextParser = new TextscanTextParser(TextFileTableModel.this.fFile, true);
                return null;
            }

            public void runOnAWTEventDispatchThread(Object object) {
                TextFileTableModel.this.requestValueFromMatlab(1, 1, TextFileTableModel.this.ROWBLOCKSIZE, TextFileTableModel.this.COLUMNBLOCKSIZE);
            }
        };
        matlabWorker.start();
        if (list == null) {
            list = new ArrayList<WorksheetRule>();
        }
        this.fRules = list;
        this.fBlockCache = new LinkedHashMap<Point, SpreadsheetDataSection>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Point, SpreadsheetDataSection> entry) {
                return this.size() > 10;
            }
        };
    }

    void setDelimiters(List<String> list) {
        this.fTextParser.setDelimiters(list);
        if (this.fColumnMetaData != null) {
            this.fColumnMetaData.setValid(false);
        }
        this.fTemporaryBlockCache = null;
        this.fBlockCache.clear();
        this.fTableStructureInitialized = false;
    }

    List<String> getDelimiters() {
        if (this.fTextParser == null) {
            return null;
        }
        return this.fTextParser.getDelimiters();
    }

    boolean isFixedWidth() {
        if (this.fTextParser == null) {
            return false;
        }
        return this.fTextParser.isFixedWidth();
    }

    int getEmptyRowCount() {
        if (this.fTextParser == null) {
            return 0;
        }
        return this.fTextParser.getEmptyRowCount();
    }

    boolean isMultipleDelimsAsOne() {
        if (this.fTextParser == null) {
            return false;
        }
        return this.fTextParser.isMultipleDelimsAsOne();
    }

    List<Integer> getFixedWidthColumnPositions() {
        if (this.fTextParser == null) {
            return null;
        }
        return this.fTextParser.getFixedWidthColumnPositions();
    }

    void setFixedWidthColumnPositions(List<Integer> list) {
        if (this.fTextParser == null) {
            return;
        }
        this.fTextParser.setFixedWidthColumnPositions(list);
        this.rebuild(0, 0);
    }

    void setDecimalSeparator(final String string) {
        MatlabWorker<Object> matlabWorker = new MatlabWorker<Object>(){

            public Object runOnMatlabThread() {
                TextFileTableModel.this.fTextParser.setDecimalSeparator(string);
                return null;
            }

            public void runOnAWTEventDispatchThread(Object object) {
                if (TextFileTableModel.this.fColumnMetaData != null) {
                    TextFileTableModel.this.fColumnMetaData.setValid(false);
                }
                TextFileTableModel.this.rebuild(0, 0);
            }
        };
        matlabWorker.start();
    }

    void setMultipleDelimsAsOne(final boolean bl) {
        MatlabWorker<Object> matlabWorker = new MatlabWorker<Object>(){

            public Object runOnMatlabThread() {
                TextFileTableModel.this.fTextParser.setMultipleDelimsAsOne(bl);
                return null;
            }

            public void runOnAWTEventDispatchThread(Object object) {
                if (TextFileTableModel.this.fColumnMetaData != null) {
                    TextFileTableModel.this.fColumnMetaData.setValid(false);
                }
                TextFileTableModel.this.rebuild(0, 0);
            }
        };
        matlabWorker.start();
    }

    protected TextFileTableModel() {
    }

    protected TextFileTableModel(SpreadsheetDataSection spreadsheetDataSection) {
        this.setDataSection(spreadsheetDataSection);
    }

    protected void setDataSection(SpreadsheetDataSection spreadsheetDataSection) {
        this.fBlockCache = new LinkedHashMap<Point, SpreadsheetDataSection>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Point, SpreadsheetDataSection> entry) {
                return this.size() > 10;
            }
        };
        this.fBlockCache.put(new Point(0, 0), spreadsheetDataSection);
    }

    protected void setTextParser(TextscanTextParser textscanTextParser) {
        this.fTextParser = textscanTextParser;
    }

    @Override
    boolean isUntreatedAt(int n, int n2) {
        if ((this.fTargetType == ImportClient.TargetType.COLUMNVECTORS || this.fTargetType == ImportClient.TargetType.CELLARRAY || this.fTargetType == ImportClient.TargetType.DATASET) && this.fColumnMetaData != null && n2 < this.fColumnMetaData.getParseRules(this.fTargetType).size() && this.fColumnMetaData.getParseRules(this.fTargetType).get(n2) == null) {
            return false;
        }
        return super.isUntreatedAt(n, n2);
    }

    public TextscanTextParser getTextParser() {
        return this.fTextParser;
    }

    public void addColumnSplitter(int n) {
        assert (!Matlab.isMatlabAvailable() || NativeMatlab.nativeIsMatlabThread());
        this.fTextParser.addFixedWidthColumnPosition(n);
        this.rebuild(0, 0);
    }

    public void deleteColumnSplitter(int n) {
        assert (!Matlab.isMatlabAvailable() || NativeMatlab.nativeIsMatlabThread());
        this.fTextParser.removeFixedWidthColumnPosition(n);
        this.rebuild(0, 0);
    }

    public void moveColumnSplitter(int n, int n2) {
        this.fTextParser.removeFixedWidthColumnPosition(n);
        this.fTextParser.addFixedWidthColumnPosition(n2);
    }

    public boolean columnSplitterExists(int n) {
        return false;
    }

    public int[] getCharacterCounts() {
        if (this.fColumnMetaData == null) {
            return null;
        }
        return this.fColumnMetaData.getColumnCharacterPositions();
    }

    @Override
    public String[] getDefaultColumnVarNames(int n) {
        if (this.fColumnMetaData == null) {
            return null;
        }
        if (this.fColumnMetaData.getHeaderRow() != n) {
            this.fColumnMetaData.updateDefaultColumnVariableNames(this.fTextParser, n);
        }
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(this.fColumnMetaData.getDefaultColumnVariableNames()));
        for (int i = arrayList.size(); i < this.getColumnCount(); ++i) {
            arrayList.add((String)arrayList.get(arrayList.size() - 1));
        }
        return arrayList.toArray(new String[1]);
    }

    public boolean useFastPath(String[][] stringArray) {
        return this.fTextParser.useFastPath(stringArray, this.getColumnParseRules(), this.getWorksheetRules());
    }

    public String getTextscanFormat(int[] nArray) {
        return this.fTextParser.getTextscanFormat(nArray, this.getColumnParseRules());
    }

    public String getSlowPathTextscanFormat(int[] nArray) {
        return this.fTextParser.getSlowPathTextscanFormat(nArray);
    }

    public String getDecimalSeparator() {
        return this.fTextParser.getDecimalSeparator();
    }

    private static double[] getSheetDimensions(TextscanTextParser textscanTextParser) {
        return new double[]{1.0, textscanTextParser.getRowCount(), 1.0, textscanTextParser.getColumnCount()};
    }

    @Override
    Object getParsedValueAt(int n, int n2) {
        SpreadsheetDataSection spreadsheetDataSection = this.getValueDataSection(n, n2);
        if (spreadsheetDataSection instanceof TextSpreadsheetDataSection) {
            return ((TextSpreadsheetDataSection)spreadsheetDataSection).getParsedValueAt(n, n2);
        }
        return null;
    }

    @Override
    protected List<WorksheetRule> getDefaultWorksheetRuleList() {
        ArrayList<WorksheetRule> arrayList = new ArrayList<WorksheetRule>();
        arrayList.add(new NonNumericReplacementRule());
        return arrayList;
    }

    @Override
    protected void makeCallToMatlab(final AbstractFileTableModel.MatlabUpdateRequest matlabUpdateRequest) {
        this.fMatlabBusy = true;
        this.setQueuedItem(null);
        if (Matlab.isMatlabAvailable()) {
            Matlab.whenMatlabIdle((Runnable)new Runnable(){

                @Override
                public void run() {
                    Object object;
                    double[] dArray = TextFileTableModel.getSheetDimensions(TextFileTableModel.this.getTextParser());
                    Pair pair = null;
                    if (dArray == null || dArray.length < 4 || (int)dArray[1] == 0 || (int)dArray[3] == 0) {
                        TextFileTableModel.this.setInitialSelection(0, 0, 0, 0);
                        TextFileTableModel.this.setSheetDimensions(0, 0, 0, 0);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                TextFileTableModel.this.matlabCallback(null);
                            }
                        });
                        return;
                    }
                    if ((int)dArray[1] != TextFileTableModel.this.fDimensions[0]) {
                        object = TextFileTableModel.this.fTextParser.getDefaultSelectionStartCell();
                        TextFileTableModel.this.setInitialSelection(object[0], object[1], (int)dArray[1] - 1, (int)dArray[3] - 1);
                        TextFileTableModel.this.setSheetDimensions((int)dArray[1], (int)dArray[3], 0, 0);
                        TextFileTableModel.this.fTableStructureInitialized = false;
                    } else if ((int)dArray[3] != TextFileTableModel.this.fDimensions[1]) {
                        if (dArray[3] > 0.0) {
                            pair = new Pair((Object)(TextFileTableModel.this.fDimensions[1] + 1), (Object)((int)dArray[3]));
                        }
                        object = TextFileTableModel.this.fTextParser.getDefaultSelectionStartCell();
                        TextFileTableModel.this.setInitialSelection(object[0], object[1], TextFileTableModel.this.fDimensions[0], (int)dArray[3]);
                        TextFileTableModel.this.setSheetDimensions(TextFileTableModel.this.fDimensions[0], (int)dArray[3], 0, 0);
                    }
                    try {
                        if (TextFileTableModel.this.fDimensions[0] < NONWINDOWED_TEXTSIZE[0] && TextFileTableModel.this.fDimensions[1] < NONWINDOWED_TEXTSIZE[1]) {
                            matlabUpdateRequest.iStartRow = 1;
                            matlabUpdateRequest.iStartCol = 1;
                            matlabUpdateRequest.iEndCol = TextFileTableModel.this.fDimensions[1];
                            matlabUpdateRequest.iEndRow = TextFileTableModel.this.fDimensions[0];
                            TextFileTableModel.this.ROWBLOCKSIZE = TextFileTableModel.this.fDimensions[0];
                            TextFileTableModel.this.COLUMNBLOCKSIZE = TextFileTableModel.this.fDimensions[1];
                        }
                        ((MatlabTextFileUpdateRequest)matlabUpdateRequest).setTargetType(TextFileTableModel.this.fTargetType);
                        object = matlabUpdateRequest.mtFeval();
                        if (TextFileTableModel.this.fColumnMetaData == null || !TextFileTableModel.this.fColumnMetaData.isValid()) {
                            TextFileTableModel.this.fColumnMetaData = ((MatlabTextFileUpdateRequest)matlabUpdateRequest).getColumnMetaData();
                        }
                        Pair pair2 = pair;
                        SwingUtilities.invokeLater(new Runnable((SpreadsheetDataSection)object, pair2){
                            final /* synthetic */ SpreadsheetDataSection val$spreadsheetDataSection;
                            final /* synthetic */ Pair val$finalAddedColumnInterval;
                            {
                                this.val$spreadsheetDataSection = spreadsheetDataSection;
                                this.val$finalAddedColumnInterval = pair;
                            }

                            @Override
                            public void run() {
                                TextFileTableModel.this.matlabCallback(this.val$spreadsheetDataSection, (Pair<Integer, Integer>)this.val$finalAddedColumnInterval);
                            }
                        });
                    }
                    catch (Exception exception) {
                        Log.log((String)exception.toString());
                    }
                }
            });
        }
    }

    void populateTextImportUIState(TextImportUIState textImportUIState) {
        List<ParseRule> list = this.getColumnParseRules();
        ArrayList<ParseRule> arrayList = new ArrayList<ParseRule>();
        for (int n : textImportUIState.getSelectedColumns()) {
            arrayList.add(list.get(n));
        }
        textImportUIState.setSelectedColumnParseRules(arrayList);
        textImportUIState.setFile(this.fFile);
        textImportUIState.setDimensions(this.fDimensions);
        textImportUIState.setRules(this.fRules);
    }

    @Override
    protected void requestValueFromMatlab(int n, int n2, int n3, int n4) {
        SpreadsheetDataSection spreadsheetDataSection;
        Point point = this.getPointForIndices(n, n2);
        if (!point.equals(this.fCurrentMatlabBlock) && ((spreadsheetDataSection = (SpreadsheetDataSection)this.fBlockCache.get(point)) == null || spreadsheetDataSection.isRulesDirty())) {
            this.fCurrentMatlabBlock = point;
            MatlabTextFileUpdateRequest matlabTextFileUpdateRequest = new MatlabTextFileUpdateRequest(this.getTextParser(), this.fColumnMetaData, this.fRules, n, n3, n2, n4);
            if (!this.fMatlabBusy) {
                this.makeCallToMatlab(matlabTextFileUpdateRequest);
            } else {
                this.setQueuedItem(matlabTextFileUpdateRequest);
            }
        }
    }

    void matlabCallback(SpreadsheetDataSection spreadsheetDataSection, Pair<Integer, Integer> pair) {
        assert (SwingUtilities.isEventDispatchThread());
        if (spreadsheetDataSection != null) {
            this.updateBlockCache(spreadsheetDataSection);
        }
        if (!this.fTableStructureInitialized) {
            this.fireTableStructureChanged();
            if (this.fQueuedUpdateRequest == null) {
                this.fTableStructureInitialized = true;
            }
        }
        if (pair != null) {
            this.fireTableChanged(new TableModelEvent(this, 0, this.getRowCount() - 1, (Integer)pair.getSecond()));
        }
        this.fCachedSelectedRowIntervals.clear();
        this.fCachedSelectedColumnIntervals.clear();
        this.fireWorksheetCachedDataListeners(new EventObject(this));
        final AbstractFileTableModel.MatlabUpdateRequest matlabUpdateRequest = this.getQueuedUpdateRequest();
        if (matlabUpdateRequest != null) {
            this.setQueuedItem(null);
            Matlab.whenMatlabReady((Runnable)new Runnable(){

                @Override
                public void run() {
                    TextFileTableModel.this.makeCallToMatlab(matlabUpdateRequest);
                }
            });
        } else {
            this.fMatlabBusy = false;
        }
    }

    @Override
    protected synchronized void setQueuedItem(AbstractFileTableModel.MatlabUpdateRequest matlabUpdateRequest) {
        this.fQueuedUpdateRequest = matlabUpdateRequest;
    }

    private synchronized AbstractFileTableModel.MatlabUpdateRequest getQueuedUpdateRequest() {
        return this.fQueuedUpdateRequest;
    }

    void reset(final int n, final ParseRule parseRule, Rectangle rectangle) {
        Object object2;
        final ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (Object object2 : this.fBlockCache.values()) {
            Cloneable cloneable = new Rectangle(((SpreadsheetDataSection)object2).getStartColumn(), ((SpreadsheetDataSection)object2).getStartRow(), ((SpreadsheetDataSection)object2).getEndColumn() - ((SpreadsheetDataSection)object2).getStartColumn() + 1, ((SpreadsheetDataSection)object2).getEndRow() - ((SpreadsheetDataSection)object2).getStartRow() + 1);
            if (((SpreadsheetDataSection)object2).getEndColumn() < n || ((SpreadsheetDataSection)object2).getStartColumn() > n) continue;
            if (rectangle.intersects((Rectangle)cloneable)) {
                arrayList.add(object2);
                continue;
            }
            arrayList2.add(object2);
        }
        HashMap hashMap = (HashMap)this.fBlockCache.clone();
        for (Cloneable cloneable : hashMap.keySet()) {
            if (!arrayList2.contains(hashMap.get(cloneable))) continue;
            this.fBlockCache.remove(cloneable);
        }
        object2 = new MatlabWorker<List<TextSpreadsheetDataSection>>(){

            public List<TextSpreadsheetDataSection> runOnMatlabThread() {
                ArrayList<TextSpreadsheetDataSection> arrayList2 = new ArrayList<TextSpreadsheetDataSection>();
                for (SpreadsheetDataSection spreadsheetDataSection : arrayList) {
                    TextSpreadsheetDataSection textSpreadsheetDataSection = (TextSpreadsheetDataSection)spreadsheetDataSection;
                    MatlabTextFileUpdateRequest matlabTextFileUpdateRequest = new MatlabTextFileUpdateRequest(TextFileTableModel.this.getTextParser(), TextFileTableModel.this.fColumnMetaData, TextFileTableModel.this.fRules, textSpreadsheetDataSection.getStartRow() + 1, textSpreadsheetDataSection.getEndRow() + 1, textSpreadsheetDataSection.getStartColumn() + 1, textSpreadsheetDataSection.getEndColumn() + 1);
                    matlabTextFileUpdateRequest.setTargetType(TextFileTableModel.this.fTargetType);
                    arrayList2.add(matlabTextFileUpdateRequest.reparse(textSpreadsheetDataSection, n, parseRule));
                }
                return arrayList2;
            }

            public void runOnAWTEventDispatchThread(List<TextSpreadsheetDataSection> list) {
                List<ParseRule> list2 = TextFileTableModel.this.getColumnParseRules();
                list2.set(n, parseRule);
                TextFileTableModel.this.setColumnParseRules(list2);
                for (TextSpreadsheetDataSection textSpreadsheetDataSection : list) {
                    TextFileTableModel.this.updateBlockCache(textSpreadsheetDataSection);
                }
                TextFileTableModel.this.fCachedSelectedRowIntervals.clear();
                TextFileTableModel.this.fCachedSelectedColumnIntervals.clear();
                TextFileTableModel.this.fireWorksheetCachedDataListeners(new EventObject(TextFileTableModel.this));
            }
        };
        object2.start();
    }

    static class MatlabTextFileUpdateRequest
    extends AbstractFileTableModel.MatlabUpdateRequest {
        TextscanTextParser iTextParser;
        TextscanTextParser.ColumnMetaData iColumnMetaData;
        ImportClient.TargetType iTargetType;
        List<String> iDelimiterList;
        Boolean iIsFixedWidth;

        MatlabTextFileUpdateRequest(TextscanTextParser textscanTextParser, TextscanTextParser.ColumnMetaData columnMetaData, List<WorksheetRule> list, int n, int n2, int n3, int n4) {
            this.iStartRow = n;
            this.iEndRow = n2;
            this.iStartCol = n3;
            this.iEndCol = n4;
            this.iRules = list;
            this.iColumnMetaData = columnMetaData;
            this.iTextParser = textscanTextParser;
        }

        void setTargetType(ImportClient.TargetType targetType) {
            this.iTargetType = targetType;
        }

        TextscanTextParser.ColumnMetaData getColumnMetaData() {
            return this.iColumnMetaData;
        }

        private static void parseColumn(Object[] objectArray, double[] dArray, int n, int n2, WorksheetRule worksheetRule) {
            Object[] objectArray2;
            Object[] objectArray3 = Arrays.copyOfRange(objectArray, n * n2, n * (n2 + 1));
            try {
                objectArray2 = (Object[])Matlab.mtFeval((String)"feval", (Object[])new Object[]{worksheetRule.getApplyFcn(), worksheetRule, null, objectArray3}, (int)2);
            }
            catch (Exception exception) {
                return;
            }
            if (!(objectArray2[0] instanceof double[])) {
                return;
            }
            double[] dArray2 = (double[])objectArray2[0];
            if (!(objectArray2[1] instanceof boolean[])) {
                return;
            }
            boolean[] blArray = (boolean[])objectArray2[1];
            for (int i = 0; i < blArray.length; ++i) {
                if (!blArray[i]) continue;
                objectArray[n * n2 + i] = dArray2[i];
                dArray[n * n2 + i] = dArray2[i];
            }
        }

        protected TextSpreadsheetDataSection reparse(TextSpreadsheetDataSection textSpreadsheetDataSection, int n, ParseRule parseRule) {
            Object object;
            int n2 = this.iStartRow - 1;
            int n3 = this.iEndRow - 1;
            int n4 = this.iStartCol - 1;
            int n5 = this.iEndCol - 1;
            int n6 = n3 - n2 + 1;
            List<List<Object>> list = this.iTextParser.read(n2, n3, n, n);
            int n7 = n3 > list.size() + n2 - 1 ? list.size() + n2 - 1 : n3;
            Object[] objectArray = new Object[n7 - n2 + 1];
            double[] dArray = new double[n7 - n2 + 1];
            Arrays.fill(dArray, Double.NaN);
            for (int i = n2; i <= n7; ++i) {
                List<Object> list2 = list.get(i - n2);
                if (list2.isEmpty()) continue;
                objectArray[i - n2] = list2.get(0);
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = n4; i <= n5; ++i) {
                object = null;
                if (i == n) {
                    object = parseRule;
                } else if (i < this.iColumnMetaData.getParseRules(this.iTargetType).size()) {
                    object = this.iColumnMetaData.getParseRules(this.iTargetType).get(i);
                }
                if (object != null || this.iTargetType != ImportClient.TargetType.COLUMNVECTORS && this.iTargetType != ImportClient.TargetType.CELLARRAY && this.iTargetType != ImportClient.TargetType.DATASET) continue;
                arrayList.add(i - n4);
            }
            if (parseRule != null) {
                MatlabTextFileUpdateRequest.parseColumn(objectArray, dArray, n6, 0, parseRule);
            }
            Object[] objectArray2 = Arrays.copyOf(textSpreadsheetDataSection.getUnPostProcessedRawData(), textSpreadsheetDataSection.getUnPostProcessedRawData().length);
            object = Arrays.copyOf(textSpreadsheetDataSection.getNumericData(), textSpreadsheetDataSection.getNumericData().length);
            String[] stringArray = Arrays.copyOf(textSpreadsheetDataSection.getDisplayedData(), textSpreadsheetDataSection.getDisplayedData().length);
            for (int i = n2; i <= n7; ++i) {
                objectArray2[i - textSpreadsheetDataSection.getStartRow() + n6 * (n - textSpreadsheetDataSection.getStartColumn())] = objectArray[i - n2];
                object[i - textSpreadsheetDataSection.getStartRow() + n6 * (n - textSpreadsheetDataSection.getStartColumn())] = dArray[i - n2];
            }
            Pair<Class[], Object[]> pair = AbstractFileTableModel.getRuleResults(objectArray2, (double[])object, this.iRules, this.iEndRow - this.iStartRow + 1, arrayList);
            Class[] classArray = (Class[])pair.getFirst();
            Object[] objectArray3 = (Object[])pair.getSecond();
            return new TextSpreadsheetDataSection(this.iStartRow - 1, this.iStartCol - 1, this.iEndRow - 1, this.iEndCol - 1, stringArray, objectArray2, (double[])object, classArray, objectArray3);
        }

        @Override
        protected SpreadsheetDataSection mtFeval() {
            int n;
            int n2 = this.iStartCol - 1;
            int n3 = this.iEndCol - 1;
            int n4 = this.iStartRow - 1;
            int n5 = this.iEndRow - 1;
            int n6 = n5 - n4 + 1;
            Object[] objectArray = new Object[(n5 - n4 + 1) * (n3 - n2 + 1)];
            double[] dArray = new double[(n5 - n4 + 1) * (n3 - n2 + 1)];
            String[] stringArray = new String[(n5 - n4 + 1) * (n3 - n2 + 1)];
            Arrays.fill(dArray, Double.NaN);
            List<List<Object>> list = this.iTextParser.read(n4, n5, n2, n3);
            for (n = n4; n <= (n5 > list.size() + n4 - 1 ? list.size() + n4 - 1 : n5); ++n) {
                List<Object> list2 = list.get(n - n4);
                int n7 = n3 <= n2 + list2.size() - 1 ? n3 : n2 + list2.size() - 1;
                for (int i = n2; i <= n7; ++i) {
                    objectArray[n6 * (i - n2) + n - n4] = list2.get(i - n2);
                    stringArray[n6 * (i - n2) + n - n4] = (String)list2.get(i - n2);
                }
            }
            if (this.iColumnMetaData == null) {
                this.iColumnMetaData = new TextscanTextParser.ColumnMetaData(this.iTextParser);
            } else if (!this.iColumnMetaData.isValid()) {
                n = this.iColumnMetaData.getHeaderRow();
                this.iColumnMetaData = new TextscanTextParser.ColumnMetaData(this.iTextParser, n);
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = n2; i <= n3; ++i) {
                WorksheetRule worksheetRule = i < this.iColumnMetaData.getParseRules(this.iTargetType).size() ? (WorksheetRule)this.iColumnMetaData.getParseRules(this.iTargetType).get(i) : (WorksheetRule)this.iColumnMetaData.getParseRules(this.iTargetType).get(this.iColumnMetaData.getParseRules(this.iTargetType).size() - 1);
                if (worksheetRule != null) {
                    MatlabTextFileUpdateRequest.parseColumn(objectArray, dArray, n6, i - n2, worksheetRule);
                    continue;
                }
                if (this.iTargetType != ImportClient.TargetType.COLUMNVECTORS && this.iTargetType != ImportClient.TargetType.CELLARRAY && this.iTargetType != ImportClient.TargetType.DATASET) continue;
                arrayList.add(i - n2);
            }
            Pair<Class[], Object[]> pair = AbstractFileTableModel.getRuleResults(objectArray, dArray, this.iRules, this.iEndRow - this.iStartRow + 1, arrayList);
            Class[] classArray = (Class[])pair.getFirst();
            Object[] objectArray2 = (Object[])pair.getSecond();
            return new TextSpreadsheetDataSection(this.iStartRow - 1, this.iStartCol - 1, this.iEndRow - 1, this.iEndCol - 1, stringArray, objectArray, dArray, classArray, objectArray2);
        }
    }

    static interface WorksheetCachedDataListener {
        public void worksheetCachedDataChanged(EventObject var1);
    }
}

