/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.mlwidgets.importtool.WorksheetRule;
import com.mathworks.widgets.spreadsheet.data.ComplexArrayDouble;
import java.awt.Rectangle;
import java.lang.reflect.Method;

class SpreadsheetDataSection {
    protected int fStartRow;
    protected int fStartColumn;
    protected int fEndRow;
    protected int fEndColumn;
    protected Object[] fContents = null;
    private Class<WorksheetRule>[] fRuleTypeArray;
    private Object[] fRuleResultArray;
    protected double[] fNumericData;
    private boolean fRulesDirty = false;

    private void setPositions(int n, int n2, int n3, int n4) {
        this.fStartRow = n;
        this.fStartColumn = n2;
        this.fEndRow = n3;
        this.fEndColumn = n4;
    }

    SpreadsheetDataSection(int n, int n2, int n3, int n4, Object[] objectArray, double[] dArray, Class[] classArray, Object[] objectArray2) {
        this(n, n2, n3, n4);
        this.fContents = objectArray;
        this.fRuleTypeArray = classArray;
        this.fRuleResultArray = objectArray2;
        this.fNumericData = dArray;
    }

    private SpreadsheetDataSection(int n, int n2, int n3, int n4) {
        this.setPositions(n, n2, n3, n4);
    }

    boolean isRulesDirty() {
        return this.fRulesDirty;
    }

    void setRulesDirty(boolean bl) {
        this.fRulesDirty = bl;
    }

    boolean isEmpty() {
        return this.fContents == null;
    }

    int getStartRow() {
        return this.fStartRow;
    }

    int getStartColumn() {
        return this.fStartColumn;
    }

    int getEndRow() {
        return this.fEndRow;
    }

    int getEndColumn() {
        return this.fEndColumn;
    }

    protected boolean hasDataAt(int n, int n2) {
        return n >= this.getStartRow() && n2 >= this.getStartColumn() && n <= this.getEndRow() && n2 <= this.getEndColumn();
    }

    Object getValueAt(int n, int n2) {
        int n3 = n - this.getStartRow();
        int n4 = n2 - this.getStartColumn();
        if (this.hasDataAt(n, n2)) {
            return this.getDataAt(n3, n4);
        }
        return ComplexArrayDouble.getEmptyRealInstance();
    }

    boolean isRuleAppliedAt(int n, int n2) {
        int n3 = n - this.getStartRow();
        int n4 = n2 - this.getStartColumn();
        return !this.isEmpty() && this.fRuleTypeArray != null && this.fRuleTypeArray[n3 + (this.fEndRow - this.fStartRow + 1) * n4] != null;
    }

    boolean isUntreatedAt(int n, int n2) {
        if (this.fRulesDirty) {
            return false;
        }
        int n3 = n - this.getStartRow();
        int n4 = n2 - this.getStartColumn();
        if (this.isEmpty() || this.fRuleTypeArray == null || this.fRuleTypeArray[n3 + (this.fEndRow - this.fStartRow + 1) * n4] != null) {
            return false;
        }
        return Double.isNaN(this.fNumericData[n3 + (this.fEndRow - this.fStartRow + 1) * n4]);
    }

    private static WorksheetRule.RuleType getRuleType(Class clazz) {
        try {
            Method method = clazz.getDeclaredMethod("getRuleType", new Class[0]);
            return (WorksheetRule.RuleType)((Object)method.invoke((Object)clazz, new Object[0]));
        }
        catch (Exception exception) {
            return null;
        }
    }

    Class getRuleClassAt(int n, int n2) {
        int n3 = n - this.getStartRow();
        int n4 = n2 - this.getStartColumn();
        if (this.isEmpty() || this.fRuleTypeArray == null) {
            return null;
        }
        return this.fRuleTypeArray[n3 + (this.fEndRow - this.fStartRow + 1) * n4];
    }

    Object getConvertedValueAt(int n, int n2) {
        int n3 = n - this.getStartRow();
        int n4 = n2 - this.getStartColumn();
        if (this.isEmpty() || this.fRuleTypeArray == null || this.fRuleResultArray == null) {
            return null;
        }
        WorksheetRule.RuleType ruleType = SpreadsheetDataSection.getRuleType(this.fRuleTypeArray[n3 + (this.fEndRow - this.fStartRow + 1) * n4]);
        if (ruleType == WorksheetRule.RuleType.CONVERT || ruleType == WorksheetRule.RuleType.CONVERTTEXT) {
            return this.fRuleResultArray[n3 + (this.fEndRow - this.fStartRow + 1) * n4];
        }
        return null;
    }

    Object getReplacedValueAt(int n, int n2) {
        int n3 = n - this.getStartRow();
        int n4 = n2 - this.getStartColumn();
        if (this.isEmpty() || this.fRuleTypeArray == null || this.fRuleResultArray == null || SpreadsheetDataSection.getRuleType(this.fRuleTypeArray[n3 + (this.fEndRow - this.fStartRow + 1) * n4]) != WorksheetRule.RuleType.REPLACE) {
            return null;
        }
        return this.fRuleResultArray[n3 + (this.fEndRow - this.fStartRow + 1) * n4];
    }

    boolean getRowExcludedRuleAt(int n, int n2) {
        return this.getExcludedRuleAt(n, n2, WorksheetRule.RuleType.ROWEXCLUDE);
    }

    boolean getColumnExcludedRuleAt(int n, int n2) {
        return this.getExcludedRuleAt(n, n2, WorksheetRule.RuleType.COLUMNEXCLUDE);
    }

    private boolean getExcludedRuleAt(int n, int n2, WorksheetRule.RuleType ruleType) {
        int n3 = n - this.getStartRow();
        int n4 = n2 - this.getStartColumn();
        return !this.isEmpty() && this.fRuleTypeArray != null && SpreadsheetDataSection.getRuleType(this.fRuleTypeArray[n3 + (this.fEndRow - this.fStartRow + 1) * n4]) == ruleType;
    }

    protected Object getDataAt(int n, int n2) {
        if (this.isEmpty()) {
            return ComplexArrayDouble.getEmptyRealInstance();
        }
        return this.fContents[n + (this.fEndRow - this.fStartRow + 1) * n2];
    }

    int getInterectingCellCount(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        Rectangle rectangle2 = rectangle.intersection(new Rectangle(this.fStartRow, this.fStartColumn, this.fEndRow - this.fStartRow + 1, this.fEndColumn - this.fStartColumn + 1));
        if (rectangle2.isEmpty()) {
            return 0;
        }
        return (int)(rectangle2.getHeight() * rectangle2.getWidth());
    }
}

