/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.mlwidgets.importtool.GeneratedCode;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.WorksheetRule;
import java.util.List;

public class NonNumericColumnExcludeRule
extends WorksheetRule {
    @Override
    public WorksheetRule.RuleType getType() {
        return WorksheetRule.RuleType.COLUMNEXCLUDE;
    }

    public static WorksheetRule.RuleType getRuleType() {
        return WorksheetRule.RuleType.COLUMNEXCLUDE;
    }

    @Override
    public Object clone() {
        return new NonNumericColumnExcludeRule();
    }

    @Override
    public String getSummaryComment() {
        return ImportToolUtils.getResourceString("codeGen.nonnumcolexcludesummary");
    }

    @Override
    public void generateMatlabCode(List<WorksheetRule> list, GeneratedCode generatedCode) {
        boolean bl = WorksheetRule.isRuleFollowedByDateRule(list, this);
        generatedCode.addCode("\n%% ");
        generatedCode.addCode(ImportToolUtils.getResourceString("CodeGen.excludecolnonnumeric"));
        generatedCode.addCode("\n");
        generatedCode.addCode(generatedCode.getColumnExclusionIndex());
        if (WorksheetRule.rulesNeedNaNConvert(list)) {
            generatedCode.addCode(" = ~all(cellfun(@(x) isnumeric(x) || islogical(x),");
        } else {
            generatedCode.addCode(" = ~all(cellfun(@(x) (isnumeric(x) || islogical(x)) && ~isnan(x),");
        }
        generatedCode.addCode(generatedCode.getRawCellArray());
        generatedCode.addCode("),1); % ");
        generatedCode.addCode(ImportToolUtils.getResourceString("CodeGen.findnonnumcellcol"));
        generatedCode.addCode("\n");
        generatedCode.addCode(generatedCode.getRawCellArray());
        generatedCode.addCode("(:,");
        generatedCode.addCode(generatedCode.getColumnExclusionIndex());
        generatedCode.addCode(") = [];\n");
        if (bl) {
            generatedCode.addCode(generatedCode.getDateArray());
            generatedCode.addCode("(:,");
            generatedCode.addCode(generatedCode.getColumnExclusionIndex());
            generatedCode.addCode(") = [];\n");
        }
    }

    @Override
    public String getApplyFcn() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(AbstractSpreadsheetPath);
        stringBuilder.append(".");
        stringBuilder.append("excludeColumnFcn");
        return stringBuilder.toString();
    }

    public String toString() {
        return ImportToolUtils.getResourceString("RuleType.nonnumericcells");
    }
}

