/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.mlwidgets.importtool.AbstractFileTableModel;
import com.mathworks.mlwidgets.importtool.TextTable;
import java.util.EventObject;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class FixedWidthUndoableEdit
extends AbstractUndoableEdit {
    TextTable fTable;
    List<Integer> fCurrentCharPositions;
    List<Integer> fNewCharPositions;
    String fPresentationName;
    String fCurrentSelectionRange;
    String fNewSelectionRange;

    public FixedWidthUndoableEdit(TextTable textTable, List<Integer> list, List<Integer> list2, String string) {
        this.fTable = textTable;
        this.fCurrentCharPositions = list;
        this.fNewCharPositions = list2;
        this.fPresentationName = string;
        this.fCurrentSelectionRange = this.fTable.getSelectedRange();
    }

    public void setNewSelectionRange(String string) {
        this.fNewSelectionRange = string;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.fTable.setFixedWidthColumnPositions(this.fCurrentCharPositions);
        if (this.fCurrentSelectionRange != null) {
            this.fTable.getWorksheetTableModel().addWorksheetCachedDataListener(new AbstractFileTableModel.WorksheetCachedDataListener(){

                @Override
                public void worksheetCachedDataChanged(EventObject eventObject) {
                    FixedWidthUndoableEdit.this.fTable.getWorksheetTableModel().removeWorksheetCachedDataListener(this);
                    FixedWidthUndoableEdit.this.fTable.setSelectedRanges(FixedWidthUndoableEdit.this.fCurrentSelectionRange);
                }
            });
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.fTable.setFixedWidthColumnPositions(this.fNewCharPositions);
        if (this.fNewSelectionRange != null) {
            this.fTable.getWorksheetTableModel().addWorksheetCachedDataListener(new AbstractFileTableModel.WorksheetCachedDataListener(){

                @Override
                public void worksheetCachedDataChanged(EventObject eventObject) {
                    FixedWidthUndoableEdit.this.fTable.getWorksheetTableModel().removeWorksheetCachedDataListener(this);
                    FixedWidthUndoableEdit.this.fTable.setSelectedRanges(FixedWidthUndoableEdit.this.fNewSelectionRange);
                }
            });
        }
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public String getPresentationName() {
        return this.fPresentationName;
    }
}

