/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.mlwidgets.importtool.GeneratedCode;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.WorksheetRule;
import java.util.List;

public class BlankColumnExcludeRule
extends WorksheetRule {
    @Override
    public WorksheetRule.RuleType getType() {
        return WorksheetRule.RuleType.COLUMNEXCLUDE;
    }

    public static WorksheetRule.RuleType getRuleType() {
        return WorksheetRule.RuleType.COLUMNEXCLUDE;
    }

    @Override
    public Object clone() {
        return new BlankColumnExcludeRule();
    }

    @Override
    public boolean codeGenUsesDates() {
        return false;
    }

    @Override
    public boolean codeGenNeedsNaNConvert() {
        return true;
    }

    @Override
    public String getSummaryComment() {
        return ImportToolUtils.getResourceString("codeGen.blankcolexcludesummary");
    }

    @Override
    public void generateMatlabCode(List<WorksheetRule> list, GeneratedCode generatedCode) {
        boolean bl = WorksheetRule.isRuleFollowedByDateRule(list, this);
        generatedCode.addCode("\n%% ");
        generatedCode.addCode(ImportToolUtils.getResourceString("CodeGen.excludecol"));
        generatedCode.addCode("\n");
        generatedCode.addCode(generatedCode.getColumnExclusionIndex());
        generatedCode.addCode(" = any(cellfun(@(x) isempty(x) || (ischar(x) && all(x==' ')),");
        generatedCode.addCode(generatedCode.getRawCellArray());
        generatedCode.addCode("),1); % ");
        generatedCode.addCode(ImportToolUtils.getResourceString("CodeGen.findblankcellcol"));
        generatedCode.addCode("\n");
        generatedCode.addCode(generatedCode.getRawCellArray());
        generatedCode.addCode("(:,");
        generatedCode.addCode(generatedCode.getColumnExclusionIndex());
        generatedCode.addCode(") = [];\n");
        if (bl) {
            generatedCode.addCode(generatedCode.getDateArray());
            generatedCode.addCode("(:,");
            generatedCode.addCode(generatedCode.getColumnExclusionIndex());
            generatedCode.addCode(") = [];\n");
        }
    }

    @Override
    public String getApplyFcn() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(AbstractSpreadsheetPath);
        stringBuilder.append(".");
        stringBuilder.append("blankExcludeColumnFcn");
        return stringBuilder.toString();
    }

    public String toString() {
        return ImportToolUtils.getResourceString("RuleType.blankcells");
    }
}

