/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.html;

import com.mathworks.mlwidgets.html.WebRenderer;
import com.mathworks.util.PlatformInfo;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;

class WebRendererFocusRequest {
    private static final String FOCUS_OWNER_PROP = "focusOwner";
    private final WebRenderer fWebRenderer;

    WebRendererFocusRequest(WebRenderer webRenderer) {
        this.fWebRenderer = webRenderer;
    }

    void doFocusRequest() {
        this.fWebRenderer.setActiveFocusRequest(this);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                WebRendererFocusRequest.this.finishFocusRequest();
            }
        };
        if (!this.fWebRenderer.addPostSetupThread(runnable) && this.fWebRenderer.getBrowser() != null) {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void finishFocusRequest() {
        if (this.isActiveRequest()) {
            this.fWebRenderer.doComponentFocusRequest();
            this.fWebRenderer.getBrowser().getCanvas().requestFocus();
            if (PlatformInfo.isWindows()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (WebRendererFocusRequest.this.isActiveRequest()) {
                            WebRendererFocusRequest.this.fWebRenderer.getBrowser().grabFocus();
                            WebRendererFocusRequest.this.fWebRenderer.setAlreadyFocused(true);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    WebRendererFocusRequest.this.setUpFocusListener();
                                }
                            });
                            WebRendererFocusRequest.this.fWebRenderer.setActiveFocusRequest(null);
                        }
                    }
                });
            } else {
                this.fWebRenderer.setActiveFocusRequest(null);
            }
        }
    }

    private boolean isActiveRequest() {
        return this.equals(this.fWebRenderer.getActiveFocusRequest());
    }

    private void setUpFocusListener() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (keyboardFocusManager.getFocusOwner() == null) {
            keyboardFocusManager.addPropertyChangeListener(FOCUS_OWNER_PROP, new FocusLostListener());
        } else {
            this.fWebRenderer.setAlreadyFocused(false);
        }
    }

    private class FocusLostListener
    implements PropertyChangeListener {
        private FocusLostListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(WebRendererFocusRequest.FOCUS_OWNER_PROP) && propertyChangeEvent.getOldValue() == null && propertyChangeEvent.getNewValue() != null) {
                WebRendererFocusRequest.this.fWebRenderer.setAlreadyFocused(false);
                KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                keyboardFocusManager.removePropertyChangeListener(WebRendererFocusRequest.FOCUS_OWNER_PROP, this);
            }
        }
    }
}

