/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.html;

import com.mathworks.html.BasicHtmlActions;
import com.mathworks.html.DefaultHtmlActionLabels;
import com.mathworks.html.FindInPageHandler;
import com.mathworks.html.HtmlActions;
import com.mathworks.html.HtmlComponent;
import com.mathworks.html.HtmlPanel;
import com.mathworks.html.StandardHtmlActionId;
import com.mathworks.mlservices.MLExecuteServices;
import com.mathworks.mlwidgets.html.DummyMatlabHtmlActions;
import com.mathworks.mlwidgets.html.MatlabFindHandler;
import com.mathworks.mlwidgets.html.MatlabHtmlActionUtils;
import com.mathworks.mlwidgets.html.MatlabHtmlActions;
import com.mathworks.mlwidgets.html.MatlabSaveFileSelector;
import com.mathworks.mlwidgets.html.MatlabViewSourceHandler;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.Action;

public class MJHtmlPanelActions
implements MatlabHtmlActions {
    private final HtmlActions fUnderlyingActions;
    private final Map<StandardHtmlActionId, MJAbstractAction> fDecoratedActions;
    private final Map<MatlabHtmlActions.MatlabActionId, MJAbstractAction> fMatlabActions;
    private final MatlabFindHandler fFindHandler;

    public MJHtmlPanelActions(HtmlPanel htmlPanel) {
        this(htmlPanel, new BasicHtmlActions((HtmlComponent)htmlPanel, (BasicHtmlActions.BasicHtmlActionLabels)new DefaultHtmlActionLabels()));
    }

    private MJHtmlPanelActions(HtmlPanel htmlPanel, BasicHtmlActions basicHtmlActions) {
        this.fUnderlyingActions = basicHtmlActions;
        this.fFindHandler = new MatlabFindHandler((HtmlComponent)htmlPanel);
        basicHtmlActions.setFindInPageHandler((FindInPageHandler)this.fFindHandler);
        basicHtmlActions.setViewSourceHandler((BasicHtmlActions.ViewSourceHandler)new MatlabViewSourceHandler((HtmlComponent)htmlPanel));
        basicHtmlActions.setSaveFileSelector((BasicHtmlActions.SaveFileSelector)new MatlabSaveFileSelector((HtmlComponent)htmlPanel));
        this.fDecoratedActions = new HashMap<StandardHtmlActionId, MJAbstractAction>();
        this.fDecoratedActions.putAll(MatlabHtmlActionUtils.decorateStandardActions(basicHtmlActions.getBasicActions()));
        this.fMatlabActions = this.createMatlabActions((HtmlComponent)htmlPanel);
        this.fillInMissingStandardActions();
    }

    private void fillInMissingStandardActions() {
        for (StandardHtmlActionId standardHtmlActionId : StandardHtmlActionId.values()) {
            if (this.fDecoratedActions.containsKey(standardHtmlActionId) && this.fDecoratedActions.get(standardHtmlActionId) != null) continue;
            this.fDecoratedActions.put(standardHtmlActionId, DummyMatlabHtmlActions.createDummyAction(standardHtmlActionId));
        }
    }

    private Map<MatlabHtmlActions.MatlabActionId, MJAbstractAction> createMatlabActions(HtmlComponent htmlComponent) {
        HashMap<MatlabHtmlActions.MatlabActionId, MJAbstractAction> hashMap = new HashMap<MatlabHtmlActions.MatlabActionId, MJAbstractAction>();
        hashMap.put(MatlabHtmlActions.MatlabActionId.OPEN_SELECTION, new ConsoleEvalAction(htmlComponent, "open-selection", "open "));
        hashMap.put(MatlabHtmlActions.MatlabActionId.EVALUATE_SELECTION, new EvaluateSelectionAction(htmlComponent));
        hashMap.put(MatlabHtmlActions.MatlabActionId.HELP_ON_SELECTION, new ConsoleEvalAction(htmlComponent, "help-on-selection", "doc "));
        return hashMap;
    }

    public Map<StandardHtmlActionId, MJAbstractAction> getBasicActions() {
        return Collections.unmodifiableMap(this.fDecoratedActions);
    }

    public Collection<MJAbstractAction> getCustomActions() {
        LinkedList<MJAbstractAction> linkedList = new LinkedList<MJAbstractAction>();
        for (Action action : this.fUnderlyingActions.getCustomActions()) {
            linkedList.add(MatlabHtmlActionUtils.wrapAction(action));
        }
        linkedList.addAll(this.fMatlabActions.values());
        return linkedList;
    }

    @Override
    public Action getMatlabAction(MatlabHtmlActions.MatlabActionId matlabActionId) {
        return (Action)this.fMatlabActions.get((Object)matlabActionId);
    }

    Collection<MJAbstractAction> getAllActions() {
        LinkedList<MJAbstractAction> linkedList = new LinkedList<MJAbstractAction>();
        linkedList.addAll(this.getBasicActions().values());
        linkedList.addAll(this.getCustomActions());
        return linkedList;
    }

    public void removeNavigationActions() {
        this.fUnderlyingActions.removeNavigationActions();
    }

    public void dispose() {
        this.fFindHandler.dispose();
    }

    private class ConsoleEvalAction
    extends MatlabSelectedTextAction {
        private final String iCommandPrefix;

        protected ConsoleEvalAction(HtmlComponent htmlComponent, String string, String string2) {
            super(htmlComponent, string);
            this.iCommandPrefix = string2;
        }

        @Override
        protected void execute(String string) {
            String string2 = this.iCommandPrefix + "'" + StringUtils.quoteSingleQuotes((String)string) + "'";
            MLExecuteServices.consoleEval((String)string2);
        }
    }

    private class EvaluateSelectionAction
    extends MatlabSelectedTextAction {
        protected EvaluateSelectionAction(HtmlComponent htmlComponent) {
            super(htmlComponent, "evaluate-selection");
        }

        @Override
        protected void execute(String string) {
            MLExecuteServices.executeCommand((String)string);
        }
    }

    private abstract class MatlabSelectedTextAction
    extends MJAbstractAction {
        private final HtmlComponent iHtmlComponent;

        protected MatlabSelectedTextAction(HtmlComponent htmlComponent, String string) {
            this.iHtmlComponent = htmlComponent;
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("HTMLRenderer", string, (ExtendedAction)this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.iHtmlComponent.getSelectedText();
            if (string != null) {
                this.execute(string);
            }
        }

        protected abstract void execute(String var1);
    }
}

