/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.html;

import com.mathworks.html.BrowserRequest;
import com.mathworks.html.RequestHandler;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mlwidgets.html.CharsetDetectionStrategy;
import com.mathworks.mlwidgets.html.DefaultPDFFileHandler;
import com.mathworks.mlwidgets.html.HTMLPrefs;
import com.mathworks.mlwidgets.html.HTMLPrinterJob;
import com.mathworks.mlwidgets.html.HTMLRenderer;
import com.mathworks.mlwidgets.html.HTMLRendererSupport;
import com.mathworks.mlwidgets.html.HTMLUtils;
import com.mathworks.mlwidgets.html.ICERendererUtils;
import com.mathworks.mlwidgets.html.PDFFileHandler;
import com.mathworks.mlwidgets.html.StreamingTextCache;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJStatusBar;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.MPopup;
import com.mathworks.mwswing.datatransfer.MJClipboard;
import com.mathworks.services.AntialiasedFontPrefs;
import com.mathworks.util.PlatformInfo;
import ice.net.Authentication;
import ice.net.CookieManager;
import ice.net.HttpURLConnection;
import ice.net.proxy.Proxy;
import ice.net.proxy.ProxyManager;
import ice.pilots.html4.DAnchorElement;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.Search;
import ice.pilots.html4.ThePilot;
import ice.storm.ContentLoader;
import ice.storm.DocPane;
import ice.storm.HistoryEntry;
import ice.storm.HistoryManager;
import ice.storm.Pilot;
import ice.storm.Scripter;
import ice.storm.ScripterCallback;
import ice.storm.StormBase;
import ice.storm.Viewport;
import ice.storm.ViewportCallback;
import ice.util.net.URLStreamHandlerFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.Undefined;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MouseEvent;
import org.w3c.dom.html.HTMLCollection;

class ICERenderer
extends HTMLRendererSupport {
    private static int sCurrentStreamingTextId = 0;
    private static boolean sMatlabProtocolOK = false;
    private static Matlab sMatlab = new Matlab();
    private static ProxyManager sProxyManager;
    private static boolean sManagersInitialized;
    private MyStormBase fStormBase;
    private Scripter fScripter;
    private MJPanel fContainer;
    private boolean fUseToplevelWindow = true;
    private boolean fInitialized = false;
    private String fSearchText = "";
    private Search fSearch = null;
    private Viewport fLastSearchViewport = null;
    private Hashtable<String, String> fVisitedLinks = new Hashtable();
    private String fCurrentTitle = "";
    private PDFFileHandler fPdfFileHandler;
    private String fSelectedText = "";
    private String fCurrentFilename = "";
    private SetLocationThread fSetLocationThread = null;
    private String fMainViewportId;
    private String fCurrentHtmlText = null;
    private static final int FIND_ACTION = 1;
    private static final int FIND_BACK_ACTION = 2;
    private int fPrevFindAction = 1;
    private MouseUpListener fMouseUpListener;
    private Vector<HTMLTooltip> fTooltipVector = new Vector();
    private Vector<MJPopupMenu> fPopupMenuVector = new Vector();
    private boolean fNavigationEnabled = true;
    private static String sLocalhost;
    private boolean fRequestFocusImmediately = false;
    private String fHandledLink;
    private HTMLRenderer fParent;

    ICERenderer() {
    }

    static String[] getClassNames() {
        String[] stringArray = new String[]{"ice.storm.StormBase", "ice.storm.Viewport", "ice.pilots.html4.ThePilot", "ice.pilots.html4.CSSLayout", "ice.pilots.html4.FontCache"};
        return stringArray;
    }

    private static boolean isWindowsSystemAntialiasingEnabled() {
        if (PlatformInfo.isWindows()) {
            Map map = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
            return map != null && map.size() > 1;
        }
        return false;
    }

    private static void setProxyForICE() {
        if (HTMLPrefs.getUseProxy()) {
            try {
                Proxy proxy = new Proxy(HTMLPrefs.getProxyHost(), Integer.parseInt(HTMLPrefs.getProxyPort()));
                String string = HTMLPrefs.getProxyUsername();
                String string2 = HTMLPrefs.getProxyPassword();
                if (string != null && string.trim().length() > 0 && string2 != null && string2.trim().length() > 0) {
                    Authentication authentication = new Authentication(null);
                    authentication.setUserName(string);
                    authentication.setPassword(string2);
                    proxy.setAuthentication(authentication);
                }
                sProxyManager.setProxyUse(true);
                sProxyManager.setGlobalProxy(proxy);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            sProxyManager.setProxyUse(false);
            sProxyManager.removeAllProxies();
            sProxyManager.setGlobalProxy(null);
        }
    }

    @Override
    public HTMLRendererSupport createRenderer(HTMLRenderer hTMLRenderer) {
        this.fParent = hTMLRenderer;
        ICERenderer.initializeManagers();
        this.fStormBase = new MyStormBase();
        this.fContainer = new MJPanel((LayoutManager)new BorderLayout());
        this.setLayout(new BorderLayout());
        this.add((Component)this.fContainer, "Center");
        this.fStormBase.setComponentToolkitName("swing");
        this.fStormBase.setViewportCallback(new ICECallback());
        this.fStormBase.setScripterCallback(new MyScripterCallback());
        this.fScripter = this.fStormBase.getScripter("ECMAScript");
        this.fPdfFileHandler = new DefaultPDFFileHandler(this);
        this.fUseToplevelWindow = false;
        if (this.fRequestFocusImmediately) {
            this.requestFocusInWindow();
        }
        return this;
    }

    private static synchronized void initializeManagers() {
        if (!sManagersInitialized) {
            sManagersInitialized = true;
            CookieManager cookieManager = new CookieManager();
            HttpURLConnection.setGlobalCookieManager((CookieManager)cookieManager);
            sProxyManager = new ProxyManager();
            HttpURLConnection.setGlobalProxyManager((ProxyManager)sProxyManager);
            ICERenderer.setProxyForICE();
            HTMLPrefs.addProxyListener(new MyProxyListener());
        }
    }

    public void addPdfFileHandler(PDFFileHandler pDFFileHandler) {
        this.fPdfFileHandler = pDFFileHandler;
    }

    @Override
    public void disableNavigation() {
        this.fNavigationEnabled = false;
        this.fStormBase.getHistoryManager().setBackHistorySize(0);
        this.fStormBase.getHistoryManager().setForwardHistorySize(0);
    }

    @Override
    void clearHistory() {
        this.fStormBase.getHistoryManager().clearAllHistories();
        this.fParent.enableDisableEvents();
    }

    @Override
    void setHTMLFont(Font font) {
        Properties properties = System.getProperties();
        int n = Math.round((float)font.getSize() * 0.6f);
        properties.put("ice.pilots.html4.baseFontSize", String.valueOf(n));
        properties.put("ice.pilots.html4.baseFontFamily", font.getName());
        if (this.fInitialized) {
            this.reload();
        }
    }

    @Override
    String getLocalhostPrefix() {
        return sLocalhost;
    }

    @Override
    void setHtmlText(String string) {
        this.setHtmlText(null, string, this.fMainViewportId);
    }

    @Override
    void setHtmlText(String string, String string2) {
        this.setHtmlText(string, string2, this.fMainViewportId);
    }

    @Override
    void setHtmlText(String string, String string2, boolean bl) {
        if (!bl) {
            this.setHtmlTextWithoutHandler(string, string2, this.fMainViewportId);
        } else {
            this.setHtmlText(string, string2, this.fMainViewportId);
        }
    }

    private void setHtmlTextWithoutHandler(String string, String string2, String string3) {
        if (string2 == null) {
            string2 = "";
        }
        string2 = HTMLUtils.encodeNonAscii(string2);
        URL uRL = HTMLUtils.getUrlFromLocation(sLocalhost, string);
        Integer n = sCurrentStreamingTextId++;
        String string4 = n.toString();
        if (uRL == null) {
            try {
                uRL = new URL("text://" + string4);
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println("Malformed url: text://" + string4);
                return;
            }
        }
        if (this.fNavigationEnabled) {
            StreamingTextCache.saveStreamingText(uRL.toString(), string2);
        } else {
            this.fCurrentHtmlText = string2;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
        ContentLoader contentLoader = new ContentLoader(uRL, (InputStream)byteArrayInputStream, "text/html");
        if (this.fStormBase != null) {
            this.fStormBase.renderContentWithoutHandler(contentLoader, string3);
            this.fInitialized = true;
        }
    }

    void setHtmlText(String string, String string2, String string3) {
        if (string2 == null) {
            string2 = "";
        }
        string2 = HTMLUtils.encodeNonAscii(string2);
        URL uRL = HTMLUtils.getUrlFromLocation(sLocalhost, string);
        Integer n = sCurrentStreamingTextId++;
        String string4 = n.toString();
        if (uRL == null) {
            try {
                uRL = new URL("text://" + string4);
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println("Malformed url: text://" + string4);
                return;
            }
        }
        if (this.fNavigationEnabled) {
            StreamingTextCache.saveStreamingText(uRL.toString(), string2);
        } else {
            this.fCurrentHtmlText = string2;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
        ContentLoader contentLoader = new ContentLoader(uRL, (InputStream)byteArrayInputStream, "text/html");
        if (this.fStormBase != null) {
            this.fStormBase.renderContent(contentLoader, string3);
            this.fInitialized = true;
        }
    }

    @Override
    void setCurrentLocation(String string) {
        if (string.startsWith("text:")) {
            String string2 = StreamingTextCache.getStreamingText(string);
            this.setHtmlText(string2);
        } else {
            this.setCurrentLocation(string, this.fMainViewportId, null);
        }
    }

    void setCurrentLocation(String string, String string2, String string3) {
        if (string == null || string.equals("")) {
            return;
        }
        string = HTMLUtils.getUrlStringFromLocation(sLocalhost, string);
        this.waitForLoadingThreadToStop(true);
        this.fSetLocationThread = new SetLocationThread(string, string2);
        SwingUtilities.invokeLater(this.fSetLocationThread);
    }

    ICERenderer getRenderer() {
        return this;
    }

    @Override
    void dispose() {
        this.fStormBase.dispose();
        this.fStormBase = null;
    }

    @Override
    String getCurrentPageTitle() {
        return this.fCurrentTitle;
    }

    @Override
    String getCurrentLocation() {
        Viewport viewport;
        String string = "";
        String string2 = this.getActiveViewportName();
        if (this.fStormBase != null && string2 != null && (viewport = this.fStormBase.findViewportByName(string2)) != null) {
            string = viewport.getLocation();
        }
        return string;
    }

    String getCurrentFilename() {
        String string = this.getCurrentLocation();
        if (string != null && !string.equals("")) {
            string = HTMLUtils.getFilenameFromURL(string);
        }
        return string;
    }

    @Override
    void copySelection() {
        MJClipboard.getMJClipboard().setContents(this.getSelectedText(), null);
    }

    @Override
    void goBack() {
        if (this.fStormBase == null) {
            return;
        }
        String string = this.getActiveToplevelViewport();
        HistoryManager historyManager = this.fStormBase.getHistoryManager();
        HistoryEntry[] historyEntryArray = historyManager.getBackEntries(string);
        if (historyEntryArray.length > 0) {
            this.clearBrowserForNavigation(historyEntryArray[historyEntryArray.length - 1].getURL());
        }
        this.fStormBase.getHistoryManager().goBack(string);
        this.fParent.enableDisableEvents();
    }

    @Override
    void goForward() {
        if (this.fStormBase == null) {
            return;
        }
        String string = this.getActiveToplevelViewport();
        HistoryManager historyManager = this.fStormBase.getHistoryManager();
        HistoryEntry[] historyEntryArray = historyManager.getForwardEntries(string);
        if (historyEntryArray.length > 0) {
            this.clearBrowserForNavigation(historyEntryArray[0].getURL());
        }
        this.fStormBase.getHistoryManager().goForward(this.getActiveToplevelViewport());
        this.fParent.enableDisableEvents();
    }

    private void clearBrowserForNavigation(String string) {
        String string2 = this.getCurrentLocation();
        if (string2 == null || string == null) {
            return;
        }
        if (HTMLUtils.isTargetOnPage(string2, string)) {
            this.clearBrowser();
        }
    }

    @Override
    boolean canGoBack(String string) {
        if (this.fStormBase == null || this.fStormBase.getHistoryManager() == null || string == null) {
            return false;
        }
        return this.fStormBase.getHistoryManager().canGoBack(string);
    }

    @Override
    boolean canGoForward(String string) {
        if (this.fStormBase == null || this.fStormBase.getHistoryManager() == null || string == null) {
            return false;
        }
        return this.fStormBase.getHistoryManager().canGoForward(string);
    }

    @Override
    void reload() {
        if (this.fStormBase == null) {
            return;
        }
        String string = this.getCurrentFilename();
        if (string != null && string.startsWith("text:") && !this.fNavigationEnabled) {
            this.setHtmlText(this.fCurrentHtmlText);
            return;
        }
        this.fStormBase.getHistoryManager().reload(this.getActiveToplevelViewport());
    }

    @Override
    boolean search(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        boolean bl5 = this.searchOnce(string, bl, bl2, bl3);
        if (!bl5) {
            Toolkit.getDefaultToolkit().beep();
            if (!bl4 && !bl3) {
                this.searchOnce(string, !bl, bl2, bl3);
            }
            if (bl4) {
                bl5 = this.searchOnce(string, bl, bl2, bl3);
            }
        }
        return bl5;
    }

    @Override
    void saveAs(File file) {
        if (!ICERenderer.isParentWritable(file)) {
            MJOptionPane.showMessageDialog((Component)SwingUtilities.windowForComponent((Component)this.fContainer), (Object)MessageFormat.format(HTMLUtils.sRes.getString("alert.error_writing"), file.getName()), (String)HTMLUtils.sRes.getString("alert.alert_title"), (int)0);
            return;
        }
        ICERendererUtils.saveAs(this.getActiveOrDefaultViewport(), this.getCurrentFilename(), file);
    }

    private static boolean isParentWritable(File file) {
        String string = file.getParent();
        File file2 = new File(string);
        return file2.exists() && file2.canWrite();
    }

    private boolean searchOnce(String string, boolean bl, boolean bl2, boolean bl3) {
        Viewport viewport = this.getActiveOrDefaultViewport();
        if (viewport == null) {
            return false;
        }
        boolean bl4 = false;
        ThePilot thePilot = (ThePilot)viewport.getPilot();
        if (this.fSearch == null || viewport != this.fLastSearchViewport) {
            this.fSearch = thePilot.getSearch();
            this.fSearchText = "";
        }
        if (!string.equals(this.fSearchText)) {
            this.fSearch.setSearchText(string);
            this.fSearch.setSearchPosToStart();
        }
        this.fSearch.setMatchCase(bl2);
        this.fSearch.setWholeWordSearch(bl3);
        if (bl) {
            try {
                bl4 = this.fSearch.findPrevious();
                if (bl4 && this.fPrevFindAction == 1) {
                    bl4 = this.fSearch.findPrevious();
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
            this.fPrevFindAction = 2;
        } else {
            try {
                bl4 = this.fSearch.findNext();
                if (bl4 && this.fPrevFindAction == 2) {
                    bl4 = this.fSearch.findNext();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fPrevFindAction = 1;
        }
        this.fSearchText = string;
        this.fLastSearchViewport = viewport;
        return bl4;
    }

    @Override
    boolean isFindSupported() {
        Pilot pilot;
        boolean bl = false;
        Viewport viewport = this.getActiveOrDefaultViewport();
        if (viewport != null && (pilot = viewport.getPilot()) instanceof ThePilot) {
            bl = true;
        }
        return bl;
    }

    @Override
    void print(ActionListener actionListener) {
        Viewport viewport = this.getActiveOrDefaultViewport();
        if (viewport != null) {
            String string = "";
            Window window = SwingUtilities.windowForComponent((Component)this.fContainer);
            if (window instanceof Frame) {
                string = ((Frame)window).getTitle();
            } else if (window instanceof Dialog) {
                string = ((Dialog)window).getTitle();
            }
            HTMLPrinterJob hTMLPrinterJob = new HTMLPrinterJob(viewport, string + " - " + this.fCurrentTitle, this.fStormBase.findViewportByName(this.fMainViewportId));
            hTMLPrinterJob.print(actionListener);
        }
    }

    void showLinkErrPage(String string) {
        String string2 = this.fParent.getFileNotFoundText(string);
        this.setHtmlText(string2);
    }

    @Override
    public void clearBrowser() {
        Viewport viewport = this.getActiveOrDefaultViewport();
        if (viewport != null) {
            try {
                this.fStormBase.clearViewportContent("text/html", viewport);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    private void gotoLocation(String string, String string2) {
        if (string2 == null) {
            string2 = this.fMainViewportId;
        }
        if (this.fInitialized) {
            this.fUseToplevelWindow = true;
        }
        if (this.fStormBase != null) {
            this.fStormBase.renderContent(string, null, string2);
        }
        this.fUseToplevelWindow = false;
        this.fInitialized = true;
    }

    private String resolveLocation(String string, Viewport viewport) {
        if (this.fParent.getJarFileLinkListener() != null && string.startsWith("file:")) {
            String string2 = this.fCurrentFilename;
            if (viewport != null) {
                string2 = viewport.getBaseUrl();
            }
            if (HTMLUtils.needsDecoding(string2)) {
                string2 = HTMLUtils.decodeUrl(string2);
            }
            string = this.fParent.getJarFileLinkListener().getRealFilename(string2, string);
        }
        return string;
    }

    private boolean fileSizeOk(Viewport viewport, String string) {
        boolean bl = true;
        String string2 = HTMLUtils.getFilenameFromURL(string);
        File file = new File(string2);
        if (Matlab.isMatlabAvailable() && file.exists() && (double)file.length() > HTMLPrefs.getMaxFileSize()) {
            if (this.fStormBase != null && viewport != null) {
                this.fStormBase.stopLoading(viewport.getName());
                this.finishedLoading(viewport);
                String string3 = HTMLUtils.sRes.getString("icecontainer.redirect_title");
                String string4 = HTMLUtils.sRes.getString("icecontainer.redirect_body_file_size");
                this.setHtmlText("<html><title>" + string3 + "</title><body>" + string4 + "</body></html>");
            }
            sMatlab.evalConsoleOutput("web('" + HTMLUtils.getFilenameFromURL(this.fCurrentFilename) + "', '-browser')", (CompletionObserver)new SystemBrowserCompletionObserver());
            bl = false;
        }
        return bl;
    }

    private void waitForLoadingThreadToStop(boolean bl) {
        if (this.fSetLocationThread != null && this.fSetLocationThread.isAlive()) {
            if (bl) {
                this.fStormBase.stopLoading(this.getActiveViewportName());
            }
            try {
                this.fSetLocationThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    String getSelectedText() {
        String string = this.getBrowserSelectedText();
        if (PlatformInfo.isMacintosh() && string.equals("")) {
            string = this.fSelectedText;
        }
        return string;
    }

    @Override
    String getHtmlText() {
        String string;
        String string2 = null;
        Viewport viewport = this.getActiveOrDefaultViewport();
        if (viewport != null && (string = viewport.getLocation()) != null) {
            string2 = string.startsWith("text:") ? (this.fNavigationEnabled ? StreamingTextCache.getStreamingText(string) : this.fCurrentHtmlText) : HTMLUtils.getSource(string, CharsetDetectionStrategy.getAutoDetectStrategy());
        }
        return string2;
    }

    private DAnchorElement getAnchorElement(Node node) {
        if (node instanceof DAnchorElement) {
            return (DAnchorElement)node;
        }
        if (node.getParentNode() != null) {
            return this.getAnchorElement(node.getParentNode());
        }
        return null;
    }

    private void updateStatusBar(Viewport viewport, String string) {
        Container container;
        if (viewport == null) {
            return;
        }
        String string2 = string;
        if (string2 != null && HTMLUtils.needsDecoding(string2)) {
            string2 = HTMLUtils.decodeUrl(string2);
        }
        if ((container = viewport.getTopLevelContainer()) instanceof BrowserFrame) {
            BrowserFrame browserFrame = (BrowserFrame)((Object)container);
            MJStatusBar mJStatusBar = browserFrame.getStatusBar();
            if (string2 == null || string2.equals("")) {
                mJStatusBar.clearText();
            } else {
                mJStatusBar.setText(string2);
            }
        }
        this.fParent.updateStatusBar(string2);
    }

    private void finishedLoading(Viewport viewport) {
        this.setWaitCursor(viewport, false);
        this.fParent.enableDisableEvents();
    }

    private boolean handleUncommonProtocols(String string, boolean bl) {
        if (string.startsWith("matlab:")) {
            if (!Matlab.isMatlabAvailable()) {
                MJOptionPane.showMessageDialog((Component)SwingUtilities.windowForComponent((Component)this.fContainer), (Object)HTMLUtils.sRes.getString("alert.matlab_protocol_not_supported"), (String)HTMLUtils.sRes.getString("alert.alert_title"), (int)0);
                return true;
            }
            String string2 = this.getCurrentLocation();
            if (!(string2 == null || string2.equals("") || string2.startsWith("file:") || string2.startsWith("jar:") || string2.startsWith("matlab:") || string2.startsWith("linkerr:") || string2.startsWith("text:") || !bl || sMatlabProtocolOK)) {
                int n = MJOptionPane.showConfirmDialog((Component)SwingUtilities.windowForComponent((Component)this.fContainer), (Object)HTMLUtils.sRes.getString("alert.security_warning"), (String)HTMLUtils.sRes.getString("alert.security_warning_title"), (int)2, (int)2);
                if (n == 2) {
                    return true;
                }
                sMatlabProtocolOK = true;
            }
            this.setWaitCursor(this.getActiveOrDefaultViewport(), true);
            String string3 = HTMLUtils.buildMatlabEvalString(string, this.fParent.getBrowserId());
            sMatlab.evalConsoleOutput(string3, (CompletionObserver)new MatlabColonObserver());
            return true;
        }
        if (string.endsWith(".pdf")) {
            Viewport viewport;
            if (this.fParent.getJarFileLinkListener() != null && (viewport = this.fStormBase.getActiveViewport()) != null) {
                String string4 = viewport.getBaseUrl();
                if (HTMLUtils.needsDecoding(string4)) {
                    string4 = HTMLUtils.decodeUrl(string4);
                }
                if (string4.startsWith("jar:") && string.startsWith("file:")) {
                    string = this.fParent.getJarFileLinkListener().getRealFilename(string4, string);
                }
            }
            this.fPdfFileHandler.open((Frame)SwingUtilities.windowForComponent((Component)this.fContainer), string);
            return true;
        }
        if (Matlab.isMatlabAvailable() && string.startsWith("mailto:") || string.startsWith("news:") || string.startsWith("ftp:")) {
            sMatlab.evalConsoleOutput("web('" + string + "', '-browser')");
            return true;
        }
        return false;
    }

    private static boolean willUrlBeHandledOutsideICE(String string) {
        return string.startsWith("matlab:") || string.endsWith(".pdf") || string.startsWith("mailto:") || string.startsWith("news:") || string.startsWith("ftp:");
    }

    @Override
    void setWaitCursor(boolean bl) {
        this.setWaitCursor(this.getActiveOrDefaultViewport(), bl);
    }

    private void setWaitCursor(Viewport viewport, boolean bl) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new CursorHandler(viewport, bl));
        } else {
            Pilot pilot;
            Cursor cursor;
            int n;
            if (bl) {
                n = 3;
                cursor = Cursor.getPredefinedCursor(n);
            } else {
                n = 0;
                cursor = Cursor.getDefaultCursor();
            }
            if (viewport != null && (pilot = viewport.getPilot()) instanceof ThePilot) {
                ThePilot thePilot = (ThePilot)pilot;
                if (!bl) {
                    thePilot.setCursorChangeable(true);
                }
                thePilot.setCursor(n);
                if (bl) {
                    thePilot.setCursorChangeable(false);
                }
            }
            pilot = this.fContainer;
            pilot.setCursor(cursor);
        }
    }

    private void showPopupMenu(int n, int n2) {
        Viewport viewport = this.getActiveOrDefaultViewport();
        Window window = SwingUtilities.windowForComponent(viewport.getContainer());
        if (window != null) {
            MJPopupMenu mJPopupMenu = this.popupMenuForWindow(window);
            if (mJPopupMenu == null) {
                mJPopupMenu = this.fParent.createPopupMenu();
                this.fPopupMenuVector.addElement(mJPopupMenu);
            }
            if (PlatformInfo.isMacintosh()) {
                this.fSelectedText = this.getBrowserSelectedText();
            }
            if (mJPopupMenu != null) {
                mJPopupMenu.show(viewport.getPilotComponent(), n, n2);
            }
        }
    }

    private String getActiveViewportName() {
        String string = this.fMainViewportId;
        Viewport viewport = this.getActiveOrDefaultViewport();
        if (viewport != null) {
            string = viewport.getName();
        }
        return string;
    }

    private Viewport getActiveOrDefaultViewport() {
        Viewport viewport = null;
        if (this.fStormBase != null && (viewport = this.fStormBase.getActiveViewport()) == null && this.fMainViewportId != null) {
            viewport = this.fStormBase.findViewportByName(this.fMainViewportId);
        }
        return viewport;
    }

    @Override
    String getViewportName() {
        return this.getActiveToplevelViewport();
    }

    private String getActiveToplevelViewport() {
        String string = "";
        Viewport viewport = this.getActiveOrDefaultViewport();
        if (viewport != null) {
            Container container = viewport.getTopLevelContainer();
            if (container instanceof BrowserFrame) {
                BrowserFrame browserFrame = (BrowserFrame)((Object)container);
                string = browserFrame.getViewportId();
            } else {
                string = this.fMainViewportId;
            }
        }
        return string;
    }

    private String getBrowserSelectedText() {
        ThePilot thePilot;
        Pilot pilot;
        String string = null;
        Viewport viewport = this.getActiveOrDefaultViewport();
        if (viewport != null && (pilot = viewport.getPilot()) instanceof ThePilot && (thePilot = (ThePilot)viewport.getPilot()) != null && (string = thePilot.getSelectedText()) != null) {
            char c = '\u00c3';
            string = string.replace(c, ' ');
            c = '\u0082';
            string = string.replace(c, ' ');
            c = '\u00c2';
            string = string.replace(c, ' ');
            c = '\u00a0';
            if ((string = string.replace(c, ' ')).length() > 1 && string.charAt(string.length() - 1) == '\n') {
                string = string.substring(0, string.length() - 1);
            }
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    void scrollToBottom() {
        Viewport viewport = this.getActiveOrDefaultViewport();
        if (viewport != null) {
            ThePilot thePilot = (ThePilot)viewport.getPilot();
            DocPane docPane = thePilot.getDocPane();
            docPane.setScrollPosition(0, docPane.getScrollMaxY());
        }
    }

    @Override
    void scrollToTarget(String string) {
        Viewport viewport = this.getActiveOrDefaultViewport();
        if (viewport != null) {
            ThePilot thePilot = (ThePilot)viewport.getPilot();
            thePilot.gotoRef(string);
        }
    }

    @Override
    int getVerticalScrollPosition() {
        int n = 0;
        Viewport viewport = this.getActiveOrDefaultViewport();
        if (viewport != null) {
            ThePilot thePilot = (ThePilot)viewport.getPilot();
            DocPane docPane = thePilot.getDocPane();
            n = docPane.getScrollY();
        }
        return n;
    }

    @Override
    public void setVerticalScrollPosition(int n) {
        Viewport viewport = this.getActiveOrDefaultViewport();
        if (viewport != null) {
            ThePilot thePilot = (ThePilot)viewport.getPilot();
            DocPane docPane = thePilot.getDocPane();
            docPane.setScrollPosition(0, n);
        }
    }

    private void hideAllTooltips() {
        for (int i = 0; i < this.fTooltipVector.size(); ++i) {
            HTMLTooltip hTMLTooltip = this.fTooltipVector.elementAt(i);
            hTMLTooltip.hide();
        }
    }

    private MJPopupMenu popupMenuForWindow(Window window) {
        for (int i = 0; i < this.fPopupMenuVector.size(); ++i) {
            MJPopupMenu mJPopupMenu = this.fPopupMenuVector.elementAt(i);
            if (mJPopupMenu.getParent() != window) continue;
            return mJPopupMenu;
        }
        return null;
    }

    public boolean requestFocusInWindow() {
        if (this.fContainer != null) {
            if (this.fContainer.getComponentCount() > 0) {
                this.requestFocusInDocPane();
                return true;
            }
            this.fContainer.addContainerListener((ContainerListener)new ContainerAdapter(){

                @Override
                public void componentAdded(ContainerEvent containerEvent) {
                    ICERenderer.this.requestFocusInDocPane();
                }
            });
            return true;
        }
        this.fRequestFocusImmediately = true;
        return true;
    }

    private void requestFocusInDocPane() {
        Viewport viewport = this.getActiveOrDefaultViewport();
        if (viewport == null) {
            return;
        }
        Pilot pilot = viewport.getPilot();
        if (pilot == null) {
            return;
        }
        DocPane docPane = pilot.getDocPane();
        if (docPane != null) {
            docPane.reqFocus();
        }
    }

    @Override
    boolean isFocusInRenderer() {
        return this.hasFocus();
    }

    @Override
    public boolean canExecuteScripts() {
        return this.fStormBase != null && this.fScripter != null;
    }

    @Override
    public void executeScript(String string) throws UnsupportedOperationException {
        this.evalCodeLocation(string);
    }

    @Override
    public String executeScriptWithReturn(String string) throws UnsupportedOperationException {
        Object object = this.evalCodeLocation(string);
        if (object instanceof Undefined) {
            return "undefined";
        }
        return object.toString();
    }

    private Object evalCodeLocation(String string) throws UnsupportedOperationException {
        this.fParent.updateStatusBar("");
        if (this.fStormBase == null || this.fScripter == null) {
            throw new UnsupportedOperationException();
        }
        Viewport viewport = this.fStormBase.findViewportByName(this.getViewportName());
        Object object = this.fScripter.evalCodeLocation(viewport, string);
        if (object instanceof EcmaError) {
            this.fParent.updateStatusBar(HTMLUtils.sRes.getString("script.error"));
            return "";
        }
        return object;
    }

    static {
        sManagersInitialized = false;
        sLocalhost = "localhost";
        Properties properties = System.getProperties();
        if (MJUtilities.isAssistiveTechAvailable()) {
            properties.put("ice.pilots.html4.swing.accessible", "jaws");
        }
        if (AntialiasedFontPrefs.isDesktopFontAntialiased() || ICERenderer.isWindowsSystemAntialiasingEnabled()) {
            properties.put("ice.pilots.html4.antiAliasing", "VALUE_ANTIALISING_ON");
            properties.put("ice.pilots.html4.textAntiAliasing", "VALUE_TEXT_ANTIALIAS_ON");
        }
        System.setProperties(properties);
        try {
            URLStreamHandlerFactory.addStreamHandler((String)"http", (String)"com.mathworks.mlwidgets.html.HttpURLStreamHandler");
            URLStreamHandlerFactory.addStreamHandler((String)"https", (String)"ice.https.HttpsURLStreamHandler");
            URL.setURLStreamHandlerFactory((java.net.URLStreamHandlerFactory)new URLStreamHandlerFactory());
            URLStreamHandlerFactory.addStreamHandler((String)"text", (String)"com.mathworks.mlwidgets.html.StreamingTextURLStreamHandler");
        }
        catch (Error error) {
            // empty catch block
        }
    }

    private class HTMLTooltip
    implements EventListener {
        private Node fCurrentTooltipNode;
        private Viewport fViewport = null;
        private HTMLTooltipThread fTooltip;
        private boolean fPendingTooltip = false;
        private MJLabel fLabel;

        public HTMLTooltip(Viewport viewport) {
            this.fViewport = viewport;
            this.fLabel = new MJLabel();
            this.fLabel.setBackground(UIManager.getColor("ToolTip.background"));
            this.fLabel.setForeground(UIManager.getColor("ToolTip.foreground"));
            this.fLabel.setFont(UIManager.getFont("ToolTip.font"));
            this.fLabel.setOpaque(true);
            Border border = BorderFactory.createEmptyBorder(0, 3, 0, 3);
            CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), border);
            this.fLabel.setBorder((Border)compoundBorder);
        }

        @Override
        public void handleEvent(Event event) {
            Node node;
            if ((!SwingUtilities.windowForComponent(this.fViewport.getContainer()).isFocused() || event.getType().equals("mouseout")) && this.fTooltip != null) {
                this.hide();
                return;
            }
            MouseEvent mouseEvent = (MouseEvent)event;
            String string = null;
            for (node = (Node)((Object)mouseEvent.getTarget()); node != null; node = node.getParentNode()) {
                if (!(node instanceof Element)) continue;
                Element element = (Element)node;
                string = element.getAttribute("title");
                if (string == null) {
                    string = element.getAttribute("alt");
                }
                if (string != null && (string = string.trim()).length() != 0) break;
            }
            if (this.fCurrentTooltipNode != node) {
                this.fCurrentTooltipNode = node;
                if (node != null) {
                    this.show(string, mouseEvent.getScreenX(), mouseEvent.getScreenY() + 15);
                } else {
                    this.hide();
                }
            } else if (this.fPendingTooltip) {
                this.show(string, mouseEvent.getScreenX(), mouseEvent.getScreenY() + 15);
            }
        }

        Viewport getViewport() {
            return this.fViewport;
        }

        void show(String string, int n, int n2) {
            if (this.fPendingTooltip) {
                this.fTooltip.suppress();
            }
            this.hide();
            this.fTooltip = new HTMLTooltipThread(string, n, n2);
            this.fPendingTooltip = true;
            ICERenderer.this.fStormBase.runOnEventThreadLater(this.fTooltip, 500L);
        }

        void hide() {
            if (this.fTooltip != null) {
                this.fTooltip.hide();
            }
        }

        private class HTMLTooltipThread
        implements Runnable {
            private String fTitle;
            private int fXPos;
            private int fYPos;
            private MPopup fPopup;
            private boolean fSuppress = false;

            HTMLTooltipThread(String string, int n, int n2) {
                this.fTitle = string;
                this.fXPos = n;
                this.fYPos = n2;
            }

            public void hide() {
                this.suppress();
                if (this.fPopup != null) {
                    this.fPopup.hide();
                }
            }

            public void suppress() {
                this.fSuppress = true;
            }

            @Override
            public void run() {
                if (!this.fSuppress) {
                    HTMLTooltip.this.fLabel.setText(this.fTitle);
                    this.fPopup = MPopup.getPopup((Component)HTMLTooltip.this.fViewport.getContainer(), (Component)HTMLTooltip.this.fLabel, (int)this.fXPos, (int)(this.fYPos + 5));
                    if (!this.fSuppress) {
                        this.fPopup.show();
                    }
                    HTMLTooltip.this.fPendingTooltip = false;
                }
            }
        }
    }

    private class MouseUpListener
    implements EventListener {
        private MouseUpListener() {
        }

        @Override
        public void handleEvent(Event event) {
            MouseEvent mouseEvent = (MouseEvent)event;
            if (PlatformInfo.isWindows() && mouseEvent.getButton() == 1 && mouseEvent.getClientX() == 0 && mouseEvent.getClientY() == 0) {
                ICERenderer.this.showPopupMenu(mouseEvent.getClientX(), mouseEvent.getClientY());
            }
            if (mouseEvent.getButton() == 0) {
                if (PlatformInfo.isMacintosh()) {
                    ICERenderer.this.fSelectedText = "";
                }
                ICERenderer.this.fParent.enableDisableEvents();
                if (PlatformInfo.isXWindows()) {
                    MJClipboard.getMJClipboard().setXSelectionContents(ICERenderer.this.getSelectedText());
                }
            }
            if (mouseEvent.getButton() == 2 || PlatformInfo.isMacintosh() && mouseEvent.getButton() == 0 && mouseEvent.getCtrlKey()) {
                ICERenderer.this.fParent.enableDisableEvents();
                ICERenderer.this.showPopupMenu(mouseEvent.getClientX(), mouseEvent.getClientY());
            }
        }
    }

    private class HTMLKeyAdapter
    extends KeyAdapter {
        private HTMLKeyAdapter() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\b') {
                ((ICERenderer)ICERenderer.this).fParent.getActions().fGoBackAction.actionPerformed(new ActionEvent(keyEvent.getSource(), 0, ""));
            }
            ICERenderer.this.fParent.enableTextSelectionActions();
        }
    }

    private class CursorHandler
    implements Runnable {
        private Viewport fViewport;
        private boolean fOn;

        public CursorHandler(Viewport viewport, boolean bl) {
            this.fViewport = viewport;
            this.fOn = bl;
        }

        @Override
        public void run() {
            ICERenderer.this.setWaitCursor(this.fViewport, this.fOn);
        }
    }

    private class MatlabColonObserver
    implements CompletionObserver {
        private MatlabColonObserver() {
        }

        public void completed(int n, Object object) {
            ICERenderer.this.setWaitCursor(ICERenderer.this.getActiveOrDefaultViewport(), false);
        }
    }

    private class LinkClickListener
    implements EventListener {
        private LinkClickListener() {
        }

        @Override
        public void handleEvent(Event event) {
            EventTarget eventTarget = event.getTarget();
            if (eventTarget instanceof Node) {
                DAnchorElement dAnchorElement = ICERenderer.this.getAnchorElement((Node)((Object)eventTarget));
                if (dAnchorElement == null || dAnchorElement.getHref() == null) {
                    return;
                }
                String string = dAnchorElement.getHref();
                if (ICERenderer.willUrlBeHandledOutsideICE(string)) {
                    return;
                }
                boolean bl = HTMLUtils.isTargetOnPage(ICERenderer.this.getCurrentLocation(), string);
                if (!bl) {
                    Viewport viewport;
                    if (ICERenderer.this.fParent.getLinkClickedHandler() != null && (viewport = ICERenderer.this.getActiveOrDefaultViewport()) != null) {
                        ICERenderer.this.fParent.getLinkClickedHandler().linkClicked(ICERenderer.this.resolveLocation(string, viewport));
                        ICERenderer.this.fHandledLink = string;
                    }
                } else {
                    ICERenderer.this.fParent.notifyPageChangedListeners(ICERenderer.this.fCurrentTitle, string, true);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ICERenderer.this.fParent.enableDisableEvents();
                        }
                    });
                }
            }
        }
    }

    private class MyPropertyChangeListener
    implements PropertyChangeListener {
        private String fViewportId;

        public MyPropertyChangeListener(String string) {
            this.fViewportId = string;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            try {
                Object object;
                String string = propertyChangeEvent.getPropertyName();
                Viewport viewport = (Viewport)propertyChangeEvent.getSource();
                String string2 = "";
                if (propertyChangeEvent.getNewValue() instanceof String) {
                    string2 = (String)propertyChangeEvent.getNewValue();
                }
                if (string.equals("pilotLoading") && string2.equals("end") && viewport.getPilot() instanceof ThePilot) {
                    object = (ThePilot)viewport.getPilot();
                    object.addPersistentDOMEventListener("click", (EventListener)new LinkClickListener(), true);
                }
                if (string2.equals("error")) {
                    object = propertyChangeEvent.getOldValue();
                    if (object instanceof ContentLoader) {
                        String string3 = ((ContentLoader)object).getLocation();
                        String string4 = ICERenderer.this.fParent.getFileNotFoundText(HTMLUtils.getFilenameFromURL(string3));
                        ICERenderer.this.finishedLoading(viewport);
                        ICERenderer.this.setHtmlText(null, string4, viewport.getName());
                    } else {
                        System.out.println(object);
                    }
                    return;
                }
                if (string.equals("pilotLoading") && string2.equals("end")) {
                    if (viewport.getPilot() instanceof ThePilot) {
                        object = (ThePilot)viewport.getPilot();
                        if (object != null) {
                            object.setKeyHandler((KeyAdapter)new HTMLKeyAdapter());
                        }
                        if (ICERenderer.this.fMouseUpListener == null) {
                            ICERenderer.this.fMouseUpListener = new MouseUpListener();
                        }
                        object.addPersistentDOMEventListener("mouseup", (EventListener)ICERenderer.this.fMouseUpListener, true);
                        HTMLTooltip hTMLTooltip = new HTMLTooltip(viewport);
                        ICERenderer.this.fTooltipVector.addElement(hTMLTooltip);
                        object.addPersistentDOMEventListener("mouseover", (EventListener)hTMLTooltip, true);
                        object.addPersistentDOMEventListener("mouseout", (EventListener)hTMLTooltip, true);
                        object.addPersistentDOMEventListener("mousemove", (EventListener)hTMLTooltip, true);
                    }
                } else if (string.equals("contentLoading")) {
                    if (string2.equals("request")) {
                        ICERenderer.this.setWaitCursor(viewport, true);
                        ICERenderer.this.fParent.enableDisableEvents();
                        ICERenderer.this.hideAllTooltips();
                        object = ((ContentLoader)propertyChangeEvent.getOldValue()).getLocation();
                        if (object != null && !((String)object).startsWith("text://") && ICERenderer.this.fileSizeOk(viewport, (String)object) && !ICERenderer.this.fVisitedLinks.containsKey(object)) {
                            ICERenderer.this.fVisitedLinks.put(object, "visited");
                        }
                    }
                    if (string2.equals("end")) {
                        ICERenderer.this.fSearch = null;
                        if (viewport.getLocation() != null) {
                            ICERenderer.this.fCurrentFilename = viewport.getLocation();
                            if (ICERenderer.this.fCurrentTitle == null || ICERenderer.this.fCurrentTitle.equals("")) {
                                ICERenderer.this.fCurrentTitle = HTMLUtils.getCanonicalUrl(ICERenderer.this.fCurrentFilename);
                            }
                            if (viewport.isTopLevel()) {
                                ICERenderer.this.fParent.notifyPageChangedListeners(ICERenderer.this.fCurrentTitle, HTMLUtils.getCanonicalUrl(ICERenderer.this.fCurrentFilename), false);
                                ICERenderer.this.fParent.resetFindDialogTitle(ICERenderer.this.fCurrentTitle);
                            }
                        }
                        if (viewport.getPilot() instanceof ThePilot) {
                            object = (ThePilot)viewport.getPilot();
                            DDocument dDocument = (DDocument)object.getDocument();
                            HTMLCollection hTMLCollection = dDocument.getLinks();
                            int n = hTMLCollection.getLength();
                            if (n < 1000) {
                                for (int i = 0; i < hTMLCollection.getLength(); ++i) {
                                    DAnchorElement dAnchorElement;
                                    if (!(hTMLCollection.item(i) instanceof DAnchorElement) || (dAnchorElement = (DAnchorElement)hTMLCollection.item(i)) == null || !ICERenderer.this.fVisitedLinks.containsKey(dAnchorElement.getHref())) continue;
                                    dAnchorElement.setVisited(true);
                                }
                            }
                        } else {
                            ICERenderer.this.finishedLoading(viewport);
                        }
                    }
                } else if (string.equals("outstandingImages")) {
                    if (string2.equals("0")) {
                        ICERenderer.this.finishedLoading(viewport);
                    }
                } else if (string.equals("title") && viewport.getId().equals(this.fViewportId)) {
                    ICERenderer.this.fCurrentTitle = string2;
                    object = viewport.getTopLevelContainer();
                    if (object instanceof BrowserFrame) {
                        BrowserFrame browserFrame = (BrowserFrame)((Object)object);
                        browserFrame.setTitle(ICERenderer.this.fCurrentTitle);
                    }
                } else if (string.equals("statusLine")) {
                    ICERenderer.this.updateStatusBar(viewport, HTMLUtils.getCanonicalUrl(string2));
                }
            }
            catch (Exception exception) {
                if (!(exception instanceof InterruptedException)) {
                    exception.printStackTrace();
                }
                ICERenderer.this.finishedLoading((Viewport)propertyChangeEvent.getSource());
            }
        }
    }

    private class BrowserFrame
    extends MJFrame {
        private MJPanel fPanel;
        private MJStatusBar fStatusBar;
        private StormBase fBase;
        private Viewport fViewport;

        public BrowserFrame(StormBase stormBase, Viewport viewport) {
            this.fBase = stormBase;
            this.fViewport = viewport;
            this.fPanel = new MJPanel();
            this.getContentPane().add((Component)this.fPanel, "Center");
            this.fStatusBar = new MJStatusBar();
            this.getContentPane().add((Component)this.fStatusBar, "South");
            this.setName("HtmlPopupFrame");
            this.setSize(600, 600);
            String string = viewport.getId();
            stormBase.addPropertyChangeListener((PropertyChangeListener)new MyPropertyChangeListener(string), string);
            this.setDefaultCloseOperation(2);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    BrowserFrame.this.setVisible(false);
                    BrowserFrame.this.fBase.closeViewport(BrowserFrame.this.fViewport.getId());
                }
            });
        }

        public MJPanel getPanel() {
            return this.fPanel;
        }

        public MJStatusBar getStatusBar() {
            return this.fStatusBar;
        }

        public String getViewportId() {
            return this.fViewport.getId();
        }
    }

    private class ICECallback
    implements ViewportCallback {
        private StormBase base;
        private Hashtable<String, BrowserFrame> fWindows = new Hashtable();

        private ICECallback() {
        }

        public void init(StormBase stormBase) {
            this.base = stormBase;
        }

        public Container createTopLevelContainer(Viewport viewport) {
            if (!ICERenderer.this.fUseToplevelWindow) {
                if (!ICERenderer.this.fInitialized) {
                    ICERenderer.this.fMainViewportId = viewport.getId();
                    ICERenderer.this.fStormBase.addPropertyChangeListener(new MyPropertyChangeListener(ICERenderer.this.fMainViewportId), ICERenderer.this.fMainViewportId);
                } else {
                    BrowserFrame browserFrame = new BrowserFrame(this.base, viewport);
                    this.fWindows.put(viewport.getId(), browserFrame);
                    browserFrame.setVisible(true);
                    return browserFrame.getPanel();
                }
            }
            return ICERenderer.this.fContainer;
        }

        public void disposeTopLevelContainer(Viewport viewport) {
            BrowserFrame browserFrame = this.fWindows.get(viewport.getId());
            if (browserFrame != null) {
                this.fWindows.remove(viewport.getId());
                browserFrame.setVisible(false);
                browserFrame.dispose();
            }
        }

        public void processViewportMessage(Viewport viewport, String string, Object object, Object object2) {
        }
    }

    private class SystemBrowserCompletionObserver
    implements CompletionObserver {
        private SystemBrowserCompletionObserver() {
        }

        public void completed(int n, Object object) {
            ICERenderer.this.setWaitCursor(false);
        }
    }

    private class MyScripterCallback
    implements ScripterCallback {
        private MyScripterCallback() {
        }

        public boolean allowScriptClose(Viewport viewport, boolean bl) {
            return true;
        }

        public long getMaxScriptRunningTime() {
            return 20000L;
        }

        public boolean interruptLongRunningScript(Viewport viewport, long l) {
            String string = HTMLUtils.sRes.getString("icecontainer.long_script_warning");
            Object[] objectArray = new Object[]{HTMLUtils.sRes.getString("icecontainer.long_script_continue"), HTMLUtils.sRes.getString("icecontainer.long_script_stop")};
            Icon icon = null;
            MJOptionPane mJOptionPane = new MJOptionPane((Object)string, 3, 0, icon, objectArray, objectArray[0]);
            Container container = viewport.getContainer();
            while (container.getParent() != null) {
                container = container.getParent();
            }
            String string2 = null;
            JDialog jDialog = mJOptionPane.createDialog((Component)container, string2);
            jDialog.setLocation(5, 5);
            jDialog.setVisible(true);
            Object object = mJOptionPane.getValue();
            return object.equals(HTMLUtils.sRes.getString("icecontainer.long_script_stop"));
        }

        public void reportScriptError(Viewport viewport, boolean bl, String string, String string2, int n, String string3, int n2) {
        }

        public void scriptAlert(Viewport viewport, String string) {
            throw new UnsupportedOperationException();
        }

        public boolean scriptConfirm(Viewport viewport, String string) {
            throw new UnsupportedOperationException();
        }

        public void scriptPrint(Viewport viewport) {
            throw new UnsupportedOperationException();
        }

        public String scriptPrompt(Viewport viewport, String string, String string2) {
            throw new UnsupportedOperationException();
        }
    }

    private class MyStormBase
    extends StormBase {
        private MyStormBase() {
        }

        public void renderContent(String string, String string2, String string3) {
            Object object;
            boolean bl = false;
            if (ICERenderer.this.fHandledLink != null && ICERenderer.this.fHandledLink.equals(string)) {
                bl = true;
            }
            ICERenderer.this.fHandledLink = null;
            if (!bl && (this.isExternalLink((String)(object = HTMLUtils.getUrlStringFromLocation(sLocalhost, string))) && ((String)object).endsWith(".pdf") || ICERenderer.this.fParent.getUseSystemBrowserForExternalLinks() && this.isExternalLink((String)object))) {
                ICERenderer.this.handleUncommonProtocols("matlab:web('" + (String)object + "', '-browser');", false);
                ICERenderer.this.updateStatusBar(ICERenderer.this.fStormBase.findViewportByName(string3), HTMLUtils.sRes.getString("icecontainer.redirect_body"));
                this.stopLoading(string3);
                return;
            }
            if (!bl) {
                for (RequestHandler requestHandler : ICERenderer.this.fParent.getRequestHandlers()) {
                    bl = requestHandler.handleRequest(new BrowserRequest(string, BrowserRequest.Origin.USER_INTERACTION, true));
                }
            }
            if (!bl) {
                bl = ICERenderer.this.handleUncommonProtocols(string, true);
            }
            if (!bl) {
                string = ICERenderer.this.resolveLocation(string, this.getActiveViewport());
                string = HTMLUtils.getUrlStringFromLocation(sLocalhost, string);
                super.renderContent(string, string2, string3);
                ICERenderer.this.fCurrentFilename = string;
            } else if (string != null && !ICERenderer.this.fVisitedLinks.containsKey(string)) {
                ICERenderer.this.fVisitedLinks.put(string, "visited");
            }
        }

        public void renderContent(ContentLoader contentLoader, String string) {
            boolean bl = false;
            for (RequestHandler requestHandler : ICERenderer.this.fParent.getRequestHandlers()) {
                bl = requestHandler.handleRequest(new BrowserRequest(contentLoader.getURL().toString(), BrowserRequest.Origin.USER_INTERACTION, true));
            }
            if (!bl) {
                super.renderContent(contentLoader, string);
            }
        }

        public void renderContent(String string, String string2, Viewport viewport) {
            super.renderContent(string, string2, viewport);
        }

        private boolean isExternalLink(String string) {
            return string.startsWith("http://") || string.startsWith("https://");
        }

        public void renderContentWithoutHandler(ContentLoader contentLoader, String string) {
            super.renderContent(contentLoader, string);
        }
    }

    private class SetLocationThread
    extends Thread {
        private String url;
        private String targetFrame;

        SetLocationThread(String string, String string2) {
            this.url = string;
            this.targetFrame = string2;
        }

        @Override
        public void run() {
            Object malformedURLException;
            boolean bl = false;
            for (RequestHandler object22 : ICERenderer.this.fParent.getRequestHandlers()) {
                bl = object22.handleRequest(new BrowserRequest(this.url, BrowserRequest.Origin.USER_INTERACTION, true));
            }
            if (bl) {
                return;
            }
            Object object3 = HTMLUtils.getFilenameFromURL(this.url);
            bl = ICERenderer.this.handleUncommonProtocols((String)object3, true);
            if (bl) {
                return;
            }
            if (((String)object3).lastIndexOf(63) >= 0) {
                this.url = object3 = HTMLUtils.removeQueryString((String)object3);
            }
            File file = new File((String)object3);
            boolean bl2 = false;
            if (!file.exists()) {
                if (PlatformInfo.isWindows() && (((String)object3).startsWith("//") || ((String)object3).length() > 1 && ((String)object3).charAt(1) == ':')) {
                    bl2 = true;
                } else if (PlatformInfo.isUnix() && ((String)object3).startsWith("/")) {
                    bl2 = true;
                } else {
                    try {
                        malformedURLException = new URL((String)object3);
                        ((URL)malformedURLException).getProtocol();
                    }
                    catch (MalformedURLException malformedURLException2) {
                        this.url = "http://" + (String)object3;
                    }
                }
            }
            if (bl2) {
                ICERenderer.this.showLinkErrPage((String)object3);
            } else {
                malformedURLException = ICERenderer.this.fCurrentFilename;
                ICERenderer.this.gotoLocation(this.url, this.targetFrame);
                ICERenderer.this.fCurrentFilename = HTMLUtils.correctSlashes(this.url);
                if (malformedURLException != null && ICERenderer.this.fCurrentFilename.indexOf("#") > -1 && HTMLUtils.isTargetOnPage((String)malformedURLException, ICERenderer.this.fCurrentFilename)) {
                    ICERenderer.this.fParent.notifyPageChangedListeners(ICERenderer.this.fCurrentTitle, ICERenderer.this.fCurrentFilename, true);
                }
            }
        }
    }

    private static class MyProxyListener
    implements ActionListener {
        private MyProxyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ICERenderer.setProxyForICE();
        }
    }
}

